"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formulas = void 0;
var _cpu_usage = require("./cpu_usage");
var _cpu_usage_iowait = require("./cpu_usage_iowait");
var _cpu_usage_irq = require("./cpu_usage_irq");
var _cpu_usage_nice = require("./cpu_usage_nice");
var _cpu_usage_softirq = require("./cpu_usage_softirq");
var _cpu_usage_steal = require("./cpu_usage_steal");
var _cpu_usage_user = require("./cpu_usage_user");
var _cpu_usage_system = require("./cpu_usage_system");
var _disk_read_iops = require("./disk_read_iops");
var _disk_write_iops = require("./disk_write_iops");
var _disk_read_throughput = require("./disk_read_throughput");
var _disk_write_throughput = require("./disk_write_throughput");
var _disk_space_availability = require("./disk_space_availability");
var _disk_space_available = require("./disk_space_available");
var _disk_usage = require("./disk_usage");
var _host_count = require("./host_count");
var _log_rate = require("./log_rate");
var _normalized_load_1m = require("./normalized_load_1m");
var _load_1m = require("./load_1m");
var _load_5m = require("./load_5m");
var _load_15m = require("./load_15m");
var _memory_usage = require("./memory_usage");
var _memory_free = require("./memory_free");
var _memory_used = require("./memory_used");
var _memory_free_excluding_cache = require("./memory_free_excluding_cache");
var _memory_cache = require("./memory_cache");
var _rx = require("./rx");
var _tx = require("./tx");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formulas = {
  cpuUsage: _cpu_usage.cpuUsage,
  cpuUsageIowait: _cpu_usage_iowait.cpuUsageIowait,
  cpuUsageIrq: _cpu_usage_irq.cpuUsageIrq,
  cpuUsageNice: _cpu_usage_nice.cpuUsageNice,
  cpuUsageSoftirq: _cpu_usage_softirq.cpuUsageSoftirq,
  cpuUsageSteal: _cpu_usage_steal.cpuUsageSteal,
  cpuUsageUser: _cpu_usage_user.cpuUsageUser,
  cpuUsageSystem: _cpu_usage_system.cpuUsageSystem,
  diskIORead: _disk_read_iops.diskIORead,
  diskIOWrite: _disk_write_iops.diskIOWrite,
  diskReadThroughput: _disk_read_throughput.diskReadThroughput,
  diskWriteThroughput: _disk_write_throughput.diskWriteThroughput,
  diskSpaceAvailability: _disk_space_availability.diskSpaceAvailability,
  diskSpaceAvailable: _disk_space_available.diskSpaceAvailable,
  diskUsage: _disk_usage.diskUsage,
  hostCount: _host_count.hostCount,
  logRate: _log_rate.logRate,
  normalizedLoad1m: _normalized_load_1m.normalizedLoad1m,
  load1m: _load_1m.load1m,
  load5m: _load_5m.load5m,
  load15m: _load_15m.load15m,
  memoryUsage: _memory_usage.memoryUsage,
  memoryFree: _memory_free.memoryFree,
  memoryUsed: _memory_used.memoryUsed,
  memoryFreeExcludingCache: _memory_free_excluding_cache.memoryFreeExcludingCache,
  memoryCache: _memory_cache.memoryCache,
  rx: _rx.rx,
  tx: _tx.tx
};
exports.formulas = formulas;