"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskSpaceAvailable = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskSpaceAvailable = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.diskSpaceAvailable', {
    defaultMessage: 'Disk Space Available'
  }),
  value: 'average(system.filesystem.free)',
  format: {
    id: 'bytes',
    params: {
      decimals: 0
    }
  }
};
exports.diskSpaceAvailable = diskSpaceAvailable;