"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kpi = void 0;
var _i18n = require("@kbn/i18n");
var _create_dashboard_model = require("../../../create_dashboard_model");
var _charts = require("../charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AVERAGE = _i18n.i18n.translate('xpack.metricsData.assetDetails.overview.kpi.subtitle.average', {
  defaultMessage: 'Average'
});
const kpi = {
  get: ({
    metricsDataView,
    options
  }) => {
    const {
      cpuUsage,
      diskUsage,
      memoryUsage,
      normalizedLoad1m
    } = (0, _charts.createBasicCharts)({
      visualizationType: 'lnsMetric',
      formulaIds: ['cpuUsage', 'diskUsage', 'memoryUsage', 'normalizedLoad1m'],
      layerOptions: {
        showTrendLine: true,
        subtitle: AVERAGE,
        ...options
      },
      dataView: metricsDataView
    });
    return (0, _create_dashboard_model.createDashboardModel)({
      charts: [{
        ...cpuUsage,
        layers: {
          ...cpuUsage.layers,
          data: {
            ...cpuUsage.layers.data,
            format: cpuUsage.layers.data.format ? {
              ...cpuUsage.layers.data.format,
              params: {
                decimals: 1
              }
            } : undefined
          }
        }
      }, {
        ...normalizedLoad1m,
        layers: {
          ...normalizedLoad1m.layers,
          data: {
            ...normalizedLoad1m.layers.data,
            format: normalizedLoad1m.layers.data.format ? {
              ...normalizedLoad1m.layers.data.format,
              params: {
                decimals: 1
              }
            } : undefined
          }
        }
      }, {
        ...memoryUsage,
        layers: {
          ...memoryUsage.layers,
          data: {
            ...memoryUsage.layers.data,
            format: memoryUsage.layers.data.format ? {
              ...memoryUsage.layers.data.format,
              params: {
                decimals: 1
              }
            } : undefined
          }
        }
      }, {
        ...diskUsage,
        layers: {
          ...diskUsage.layers,
          data: {
            ...diskUsage.layers.data,
            format: diskUsage.layers.data.format ? {
              ...diskUsage.layers.data.format,
              params: {
                decimals: 1
              }
            } : undefined
          }
        }
      }]
    });
  }
};
exports.kpi = kpi;