"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetDetailsKubernetesNode = void 0;
var _i18n = require("@kbn/i18n");
var _create_dashboard_model = require("../../../create_dashboard_model");
var _metrics = require("../../../kubernetes/node/metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetDetailsKubernetesNode = {
  get: ({
    metricsDataView
  }) => {
    const commonVisualOptions = {
      showDottedLine: true,
      missingValues: 'Linear',
      legend: {
        isVisible: true,
        position: 'bottom'
      }
    };
    return (0, _create_dashboard_model.createDashboardModel)({
      dependsOn: ['kubernetes.node'],
      charts: [{
        id: 'nodeCpuCapacity',
        title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodeCpuCapacity', {
          defaultMessage: 'Node CPU Capacity'
        }),
        layers: [{
          data: [_metrics.formulas.nodeCpuCapacity, _metrics.formulas.nodeCpuUsed],
          options: {
            seriesType: 'area'
          },
          layerType: 'data'
        }],
        dataView: metricsDataView,
        visualizationType: 'lnsXY',
        visualOptions: commonVisualOptions
      }, {
        id: 'nodeMemoryCapacity',
        title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodeMemoryCapacity', {
          defaultMessage: 'Node Memory Capacity'
        }),
        layers: [{
          data: [_metrics.formulas.nodeMemoryCapacity, _metrics.formulas.nodeMemoryUsed],
          options: {
            seriesType: 'area'
          },
          layerType: 'data'
        }],
        visualizationType: 'lnsXY',
        dataView: metricsDataView,
        visualOptions: commonVisualOptions
      }, {
        id: 'nodeDiskCapacity',
        title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodeDiskCapacity', {
          defaultMessage: 'Node Disk Capacity'
        }),
        layers: [{
          data: [_metrics.formulas.nodeDiskCapacity, _metrics.formulas.nodeDiskUsed],
          options: {
            seriesType: 'area'
          },
          layerType: 'data'
        }],
        visualizationType: 'lnsXY',
        dataView: metricsDataView,
        visualOptions: commonVisualOptions
      }, {
        id: 'nodePodCapacity',
        title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodePodCapacity', {
          defaultMessage: 'Node Pod Capacity'
        }),
        layers: [{
          data: [_metrics.formulas.nodePodCapacity, _metrics.formulas.nodePodUsed],
          options: {
            seriesType: 'area'
          },
          layerType: 'data'
        }],
        visualizationType: 'lnsXY',
        dataView: metricsDataView,
        visualOptions: commonVisualOptions
      }]
    });
  }
};
exports.assetDetailsKubernetesNode = assetDetailsKubernetesNode;