"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rxTx = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rxTx = {
  get: ({
    dataView
  }) => ({
    id: 'rxTx',
    title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.network', {
      defaultMessage: 'Network'
    }),
    layers: [{
      data: [{
        ..._formulas.formulas.rx,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.network.label.rx', {
          defaultMessage: 'Inbound (RX)'
        })
      }, {
        ..._formulas.formulas.tx,
        label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.network.label.tx', {
          defaultMessage: 'Outbound (TX)'
        })
      }],
      options: {
        seriesType: 'area'
      },
      layerType: 'data'
    }],
    visualOptions: {
      yLeftExtent: {
        mode: 'dataBounds',
        lowerBound: 0,
        upperBound: 1
      }
    },
    visualizationType: 'lnsXY',
    dataView
  })
};
exports.rxTx = rxTx;