"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "cpuUsageBreakdown", {
  enumerable: true,
  get: function () {
    return _cpu_charts.cpuUsageBreakdown;
  }
});
exports.createBasicCharts = void 0;
Object.defineProperty(exports, "diskIOReadWrite", {
  enumerable: true,
  get: function () {
    return _disk_charts.diskIOReadWrite;
  }
});
Object.defineProperty(exports, "diskSpaceUsageAvailable", {
  enumerable: true,
  get: function () {
    return _disk_charts.diskSpaceUsageAvailable;
  }
});
Object.defineProperty(exports, "diskThroughputReadWrite", {
  enumerable: true,
  get: function () {
    return _disk_charts.diskThroughputReadWrite;
  }
});
Object.defineProperty(exports, "diskUsageByMountPoint", {
  enumerable: true,
  get: function () {
    return _disk_charts.diskUsageByMountPoint;
  }
});
Object.defineProperty(exports, "loadBreakdown", {
  enumerable: true,
  get: function () {
    return _cpu_charts.loadBreakdown;
  }
});
Object.defineProperty(exports, "memoryUsageBreakdown", {
  enumerable: true,
  get: function () {
    return _memory_charts.memoryUsageBreakdown;
  }
});
Object.defineProperty(exports, "normalizedLoad1m", {
  enumerable: true,
  get: function () {
    return _cpu_charts.normalizedLoad1m;
  }
});
Object.defineProperty(exports, "rxTx", {
  enumerable: true,
  get: function () {
    return _network_charts.rxTx;
  }
});
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _formulas = require("../formulas");
var _cpu_charts = require("./cpu_charts");
var _disk_charts = require("./disk_charts");
var _memory_charts = require("./memory_charts");
var _network_charts = require("./network_charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBasicCharts = ({
  formulaIds,
  visualizationType,
  dataView,
  layerOptions,
  ...rest
}) => {
  return formulaIds.reduce((acc, curr) => {
    const layers = {
      data: visualizationType === _lensEmbeddableUtils.XY_ID ? [_formulas.formulas[curr]] : _formulas.formulas[curr],
      layerType: visualizationType === _lensEmbeddableUtils.XY_ID ? 'data' : 'metricTrendline',
      options: layerOptions
    };
    const chartModel = {
      id: curr,
      title: _formulas.formulas[curr].label,
      dataView,
      visualizationType,
      layers: visualizationType === _lensEmbeddableUtils.XY_ID ? [layers] : layers,
      ...rest
    };
    return {
      ...acc,
      [curr]: chartModel
    };
  }, {});
};

// custom charts
exports.createBasicCharts = createBasicCharts;