"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMapsFilterMigrations = exports.getMapsDataViewMigrations = void 0;
exports.setupSavedObjects = setupSavedObjects;
var _lodash = require("lodash");
var _server = require("@kbn/core/server");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _constants = require("../../common/constants");
var _content_management = require("../../common/content_management");
var _migrate_data_persisted_state = require("../../common/migrations/migrate_data_persisted_state");
var _migrate_data_view_persisted_state = require("../../common/migrations/migrate_data_view_persisted_state");
var _saved_object_migrations = require("./saved_object_migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setupSavedObjects(core, getFilterMigrations, getDataViewMigrations) {
  core.savedObjects.registerType({
    name: _content_management.CONTENT_ID,
    indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
    hidden: false,
    namespaceType: 'multiple-isolated',
    convertToMultiNamespaceTypeVersion: '8.0.0',
    mappings: {
      properties: {
        description: {
          type: 'text'
        },
        title: {
          type: 'text'
        },
        version: {
          type: 'integer'
        },
        mapStateJSON: {
          type: 'text'
        },
        layerListJSON: {
          type: 'text'
        },
        uiStateJSON: {
          type: 'text'
        },
        bounds: {
          dynamic: false,
          properties: {}
        } // Disable removed field
      }
    },

    management: {
      icon: _constants.APP_ICON,
      defaultSearchField: 'title',
      importableAndExportable: true,
      getTitle(obj) {
        return obj.attributes.title;
      },
      getInAppUrl(obj) {
        return {
          path: (0, _constants.getFullPath)(obj.id),
          uiCapabilitiesPath: 'maps.show'
        };
      }
    },
    migrations: () => {
      return (0, _server.mergeSavedObjectMigrationMaps)((0, _server.mergeSavedObjectMigrationMaps)(_saved_object_migrations.savedObjectMigrations, getMapsFilterMigrations(getFilterMigrations())), getMapsDataViewMigrations(getDataViewMigrations()));
    }
  });
}

/**
 * This creates a migration map that applies external data plugin migrations to persisted filter state stored in Maps
 */
const getMapsFilterMigrations = filterMigrations => (0, _lodash.mapValues)(filterMigrations, filterMigration => doc => {
  try {
    const attributes = (0, _migrate_data_persisted_state.migrateDataPersistedState)(doc, filterMigration);
    return {
      ...doc,
      attributes
    };
  } catch (e) {
    // Do not fail migration
    // Maps application can display error when saved object is viewed
    return doc;
  }
});

/**
 * This creates a migration map that applies external data view plugin migrations to persisted data view state stored in Maps
 */
exports.getMapsFilterMigrations = getMapsFilterMigrations;
const getMapsDataViewMigrations = migrations => (0, _lodash.mapValues)(migrations, migration => doc => {
  try {
    const attributes = (0, _migrate_data_view_persisted_state.migrateDataViewsPersistedState)(doc, migration);
    return {
      ...doc,
      attributes
    };
  } catch (e) {
    // Do not fail migration
    // Maps application can display error when saved object is viewed
    return doc;
  }
});
exports.getMapsDataViewMigrations = getMapsDataViewMigrations;