"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCancelRequestCallbacks = exports.cancelRequest = void 0;
exports.getChartsPaletteServiceGetColor = getChartsPaletteServiceGetColor;
exports.getInspectorAdapters = exports.getEventHandlers = void 0;
exports.getOnMapMove = getOnMapMove;
exports.nonSerializableInstances = nonSerializableInstances;
exports.registerCancelCallback = void 0;
exports.setChartsPaletteServiceGetColor = setChartsPaletteServiceGetColor;
exports.setEventHandlers = void 0;
exports.setOnMapMove = setOnMapMove;
exports.unregisterCancelCallback = void 0;
var _request = require("@kbn/inspector-plugin/common/adapters/request");
var _inspector = require("../inspector");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REGISTER_CANCEL_CALLBACK = 'REGISTER_CANCEL_CALLBACK';
const UNREGISTER_CANCEL_CALLBACK = 'UNREGISTER_CANCEL_CALLBACK';
const SET_EVENT_HANDLERS = 'SET_EVENT_HANDLERS';
const SET_CHARTS_PALETTE_SERVICE_GET_COLOR = 'SET_CHARTS_PALETTE_SERVICE_GET_COLOR';
const SET_ON_MAP_MOVE = 'SET_ON_MAP_MOVE';
function createInspectorAdapters() {
  const inspectorAdapters = {
    requests: new _request.RequestAdapter(),
    vectorTiles: new _inspector.VectorTileAdapter()
  };
  if ((0, _kibana_services.getShowMapsInspectorAdapter)()) {
    inspectorAdapters.map = new _inspector.MapAdapter();
  }
  return inspectorAdapters;
}

// Reducer
function nonSerializableInstances(state, action = {}) {
  if (!state) {
    return {
      inspectorAdapters: createInspectorAdapters(),
      cancelRequestCallbacks: new Map(),
      // key is request token, value is cancel callback
      eventHandlers: {},
      chartsPaletteServiceGetColor: null
    };
  }
  switch (action.type) {
    case REGISTER_CANCEL_CALLBACK:
      state.cancelRequestCallbacks.set(action.requestToken, action.callback);
      return {
        ...state
      };
    case UNREGISTER_CANCEL_CALLBACK:
      state.cancelRequestCallbacks.delete(action.requestToken);
      return {
        ...state
      };
    case SET_EVENT_HANDLERS:
      {
        return {
          ...state,
          eventHandlers: action.eventHandlers
        };
      }
    case SET_CHARTS_PALETTE_SERVICE_GET_COLOR:
      {
        return {
          ...state,
          chartsPaletteServiceGetColor: action.chartsPaletteServiceGetColor
        };
      }
    case SET_ON_MAP_MOVE:
      {
        return {
          ...state,
          onMapMove: action.onMapMove
        };
      }
    default:
      return state;
  }
}

// Selectors
const getInspectorAdapters = ({
  nonSerializableInstances
}) => {
  return nonSerializableInstances.inspectorAdapters;
};
exports.getInspectorAdapters = getInspectorAdapters;
const getCancelRequestCallbacks = ({
  nonSerializableInstances
}) => {
  return nonSerializableInstances.cancelRequestCallbacks;
};
exports.getCancelRequestCallbacks = getCancelRequestCallbacks;
const getEventHandlers = ({
  nonSerializableInstances
}) => {
  return nonSerializableInstances.eventHandlers;
};
exports.getEventHandlers = getEventHandlers;
function getChartsPaletteServiceGetColor({
  nonSerializableInstances
}) {
  return nonSerializableInstances.chartsPaletteServiceGetColor;
}
function getOnMapMove({
  nonSerializableInstances
}) {
  return nonSerializableInstances.onMapMove;
}

// Actions
const registerCancelCallback = (requestToken, callback) => {
  return {
    type: REGISTER_CANCEL_CALLBACK,
    requestToken,
    callback
  };
};
exports.registerCancelCallback = registerCancelCallback;
const unregisterCancelCallback = requestToken => {
  return {
    type: UNREGISTER_CANCEL_CALLBACK,
    requestToken
  };
};
exports.unregisterCancelCallback = unregisterCancelCallback;
const cancelRequest = requestToken => {
  return (dispatch, getState) => {
    if (!requestToken) {
      return;
    }
    const cancelCallback = getCancelRequestCallbacks(getState()).get(requestToken);
    if (cancelCallback) {
      cancelCallback();
      dispatch(unregisterCancelCallback(requestToken));
    }
  };
};
exports.cancelRequest = cancelRequest;
const setEventHandlers = (eventHandlers = {}) => {
  return {
    type: SET_EVENT_HANDLERS,
    eventHandlers
  };
};
exports.setEventHandlers = setEventHandlers;
function setChartsPaletteServiceGetColor(chartsPaletteServiceGetColor) {
  return {
    type: SET_CHARTS_PALETTE_SERVICE_GET_COLOR,
    chartsPaletteServiceGetColor
  };
}
function setOnMapMove(onMapMove) {
  return {
    type: SET_ON_MAP_MOVE,
    onMapMove
  };
}