"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegionKeyEditor = RegionKeyEditor;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ems_file_select = require("../../components/ems_file_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RegionKeyEditor(props) {
  function onEmsLayerSelect(emsLayerId) {
    const emsFields = getEmsFields(props.emsFileLayers, emsLayerId);
    props.setState({
      ...props.state,
      emsLayerId,
      emsField: emsFields.length ? emsFields[0].value : undefined
    });
  }
  function onEmsFieldSelect(selectedOptions) {
    if (selectedOptions.length === 0) {
      return;
    }
    props.setState({
      ...props.state,
      emsField: selectedOptions[0].value
    });
  }
  let emsFieldSelect;
  const emsFields = getEmsFields(props.emsFileLayers, props.state.emsLayerId);
  if (emsFields.length) {
    let selectedOption;
    if (props.state.emsField) {
      selectedOption = emsFields.find(option => {
        return props.state.emsField === option.value;
      });
    }
    emsFieldSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.choropleth.joinFieldLabel', {
        defaultMessage: 'Join field'
      }),
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      singleSelection: true,
      isClearable: false,
      options: emsFields,
      selectedOptions: selectedOption ? [selectedOption] : [],
      onChange: onEmsFieldSelect
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ems_file_select.EMSFileSelect, {
    isColumnCompressed: true,
    value: props.state.emsLayerId ? props.state.emsLayerId : null,
    onChange: onEmsLayerSelect
  }), emsFieldSelect);
}
function getEmsFields(emsFileLayers, emsLayerId) {
  if (!emsLayerId) {
    return [];
  }
  const emsFileLayer = emsFileLayers.find(fileLayer => {
    return fileLayer.getId() === emsLayerId;
  });
  return emsFileLayer ? emsFileLayer.getFieldsInLanguage().filter(field => {
    return field.type === 'id';
  }).map(field => {
    return {
      value: field.name,
      label: field.description
    };
  }) : [];
}