"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _kibana_services = require("../../kibana_services");
var _view_in_maps = require("../view_in_maps");
var _utils = require("./utils");
var _tile_map_vis_type = require("./tile_map_vis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TileMapEditor(props) {
  const onClick = e => {
    e.preventDefault();
    const locator = (0, _kibana_services.getShareService)().url.locators.get('MAPS_APP_TILE_MAP_LOCATOR');
    if (!locator) return;
    const query = (0, _kibana_services.getData)().query;
    locator.navigate({
      ...(0, _utils.extractLayerDescriptorParams)(props.vis),
      filters: query.filterManager.getFilters(),
      query: query.queryString.getQuery(),
      timeRange: query.timefilter.timefilter.getTime()
    });
  };
  return /*#__PURE__*/_react.default.createElement(_view_in_maps.ViewInMaps, {
    onClick: onClick,
    visualizationLabel: _tile_map_vis_type.title
  });
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
var _default = TileMapEditor;
exports.default = _default;
module.exports = exports.default;