"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapEmbeddablesSingleton = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registry = {};
let location;
let primaryPanelId;
let primaryPanelTimeoutId;
const mapEmbeddablesSingleton = {
  getGeoFieldNames() {
    const geoFieldNames = [];
    Object.values(registry).forEach(mapPanel => {
      geoFieldNames.push(...mapPanel.getGeoFieldNames());
    });
    return _lodash.default.uniq(geoFieldNames);
  },
  getLocation() {
    return location;
  },
  getMapPanels() {
    return Object.keys(registry).map(key => {
      return {
        ...registry[key],
        id: key
      };
    });
  },
  hasMultipleMaps() {
    return Object.keys(registry).length > 1;
  },
  register(embeddableId, mapPanel) {
    registry[embeddableId] = mapPanel;
  },
  setLocation(triggeringEmbeddableId, lat, lon, zoom) {
    if (primaryPanelId && primaryPanelId !== triggeringEmbeddableId) {
      // to avoid callstack overflow and bouncing between locations,
      // do not propagate location changes from "follower" panels
      return;
    }
    primaryPanelId = triggeringEmbeddableId;
    if (primaryPanelTimeoutId) {
      clearTimeout(primaryPanelTimeoutId);
    }
    primaryPanelTimeoutId = setTimeout(() => {
      // release "primary" panel lock on timeout allowing movement in other panels to all them to become "primary"
      primaryPanelId = undefined;
    }, 500);
    location = {
      lat,
      lon,
      zoom
    };
    Object.keys(registry).forEach(key => {
      if (key === triggeringEmbeddableId) {
        return;
      }
      const mapPanel = registry[key];
      if (mapPanel.getIsMovementSynchronized()) {
        mapPanel.onLocationChange(lat, lon, zoom);
      }
    });
  },
  unregister(embeddableId) {
    delete registry[embeddableId];
    if (Object.keys(registry).length === 0) {
      // clear location to not pollute location between embeddable containers
      location = undefined;
    }
  }
};
exports.mapEmbeddablesSingleton = mapEmbeddablesSingleton;