"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOCEntryActionsPopover = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../../../../../actions");
var _map_selectors = require("../../../../../../selectors/map_selectors");
var _ui_selectors = require("../../../../../../selectors/ui_selectors");
var _toc_entry_actions_popover = require("./toc_entry_actions_popover");
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    isReadOnly: (0, _ui_selectors.getIsReadOnly)(state),
    numLayers: (0, _map_selectors.getLayerListRaw)(state).length
  };
}
function mapDispatchToProps(dispatch) {
  return {
    cloneLayer: layerId => {
      dispatch((0, _actions.cloneLayer)(layerId));
    },
    fitToBounds: layerId => {
      dispatch((0, _actions.fitToLayerExtent)(layerId));
    },
    removeLayer: layerId => {
      dispatch((0, _actions.removeLayer)(layerId));
    },
    toggleVisible: layerId => {
      dispatch((0, _actions.toggleLayerVisible)(layerId));
    },
    enableShapeEditing: layerId => {
      dispatch((0, _actions.updateEditLayer)(layerId));
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.DRAW_SHAPES));
    },
    enablePointEditing: layerId => {
      dispatch((0, _actions.updateEditLayer)(layerId));
      dispatch((0, _actions.setDrawMode)(_constants.DRAW_MODE.DRAW_POINTS));
    },
    showThisLayerOnly: layerId => {
      dispatch((0, _actions.showThisLayerOnly)(layerId));
    },
    ungroupLayer: layerId => {
      dispatch((0, _actions.ungroupLayer)(layerId));
    }
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_toc_entry_actions_popover.TOCEntryActionsPopover);
exports.TOCEntryActionsPopover = connected;