"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALL_LAYERS = '_ALL_LAYERS_';
const DEFAULT_PAGE_NUMBER = 0;
class Footer extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_prevFeatures", null);
    (0, _defineProperty2.default)(this, "state", {
      filteredFeatures: this.props.features,
      pageNumber: DEFAULT_PAGE_NUMBER,
      selectedLayerId: ALL_LAYERS,
      layerOptions: []
    });
    (0, _defineProperty2.default)(this, "_loadUniqueLayers", async () => {
      if (this._prevFeatures === this.props.features) {
        return;
      }
      this._prevFeatures = this.props.features;
      const countByLayerId = new Map();
      for (let i = 0; i < this.props.features.length; i++) {
        let count = countByLayerId.get(this.props.features[i].layerId);
        if (!count) {
          count = 0;
        }
        count++;
        countByLayerId.set(this.props.features[i].layerId, count);
      }
      const layers = [];
      countByLayerId.forEach((count, layerId) => {
        const layer = this.props.findLayerById(layerId);
        if (layer) {
          layers.push(layer);
        }
      });
      const layerNamePromises = layers.map(layer => {
        return layer.getDisplayName();
      });
      const layerNames = await Promise.all(layerNamePromises);
      if (this._isMounted) {
        this.setState({
          filteredFeatures: this.props.features,
          selectedLayerId: ALL_LAYERS,
          layerOptions: layers.map((layer, index) => {
            const displayName = layerNames[index];
            const count = countByLayerId.get(layer.getId());
            return {
              value: layer.getId(),
              text: `(${count}) ${displayName}`
            };
          })
        }, () => this._onPageChange(DEFAULT_PAGE_NUMBER));
      }
    });
    (0, _defineProperty2.default)(this, "_onPageChange", pageNumber => {
      this.setState({
        pageNumber
      });
      this.props.setCurrentFeature(this.state.filteredFeatures[pageNumber]);
    });
    (0, _defineProperty2.default)(this, "_onLayerChange", e => {
      const newLayerId = e.target.value;
      if (this.state.selectedLayerId === newLayerId) {
        return;
      }
      const filteredFeatures = newLayerId === ALL_LAYERS ? this.props.features : this.props.features.filter(feature => {
        return feature.layerId === newLayerId;
      });
      this.setState({
        filteredFeatures,
        selectedLayerId: newLayerId
      }, () => this._onPageChange(DEFAULT_PAGE_NUMBER));
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadUniqueLayers();
  }
  componentDidUpdate() {
    this._loadUniqueLayers();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    const {
      isLocked
    } = this.props;
    const {
      filteredFeatures,
      pageNumber,
      selectedLayerId,
      layerOptions
    } = this.state;
    const isLayerSelectVisible = isLocked && layerOptions.length > 1;
    const items = [];

    // Pagination controls
    if (isLocked && filteredFeatures.length > 1) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: "pagination"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
        pageCount: filteredFeatures.length,
        activePage: pageNumber,
        onPageClick: this._onPageChange,
        compressed: true
      })));
    }

    // Page number readout
    if (!isLocked && filteredFeatures.length > 1) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: !isLayerSelectVisible,
        key: "pageNumber"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.tooltip.pageNumerText",
        defaultMessage: "{pageNumber} of {total}",
        values: {
          pageNumber: pageNumber + 1,
          total: filteredFeatures.length
        }
      }))));
    }

    // Layer select
    if (isLayerSelectVisible) {
      items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: "layerSelect"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "rowCompressed"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        options: [{
          value: ALL_LAYERS,
          text: _i18n.i18n.translate('xpack.maps.tooltip.allLayersLabel', {
            defaultMessage: 'All layers'
          })
        }, ...layerOptions],
        onChange: this._onLayerChange,
        value: selectedLayerId,
        compressed: true,
        fullWidth: true,
        "aria-label": _i18n.i18n.translate('xpack.maps.tooltip.layerFilterLabel', {
          defaultMessage: 'Filter results by layer'
        })
      }))));
    }
    return items.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, items)) : null;
  }
}
exports.Footer = Footer;