"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeydownScrollZoom = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;
class KeydownScrollZoom extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_hideTimeout", void 0);
    (0, _defineProperty2.default)(this, "state", {
      show: false
    });
    (0, _defineProperty2.default)(this, "_onWheel", event => {
      if (this._hideTimeout) {
        clearTimeout(this._hideTimeout);
        this._hideTimeout = undefined;
      }
      if (isMac && event.originalEvent.metaKey || !isMac && event.originalEvent.ctrlKey) {
        this.setState({
          show: false
        });
        return;
      }
      this.setState({
        show: true
      });
      this._hideTimeout = setTimeout(() => {
        if (this._isMounted) {
          this.setState({
            show: false
          });
        }
      }, 1500);
      event.preventDefault();
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.props.mbMap.on('wheel', this._onWheel);
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.mbMap.off('wheel', this._onWheel);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("aside", {
      className: (0, _classnames.default)('mapKeydownScrollZoom', {
        'mapKeydownScrollZoom--show': this.state.show
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      size: "s",
      color: "ghost"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.maps.keydownScrollZoom.keydownToZoomInstructions', {
      defaultMessage: 'Use {key} + scroll to zoom the map',
      values: {
        key: isMac ? '⌘' : 'control'
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.maps.keydownScrollZoom.keydownClickAndDragZoomInstructions', {
      defaultMessage: 'Use shift + click and drag to zoom the map to fit within a bounding box'
    }))));
  }
}
exports.KeydownScrollZoom = KeydownScrollZoom;