"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpatialFiltersPanel = SpatialFiltersPanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _alpha_slider = require("../../components/alpha_slider");
var _mb_validated_color_picker = require("../../classes/styles/vector/components/color/mb_validated_color_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SpatialFiltersPanel({
  settings,
  updateMapSetting
}) {
  const onAlphaChange = alpha => {
    updateMapSetting('spatialFiltersAlpa', alpha);
  };
  const onFillColorChange = color => {
    updateMapSetting('spatialFiltersFillColor', color);
  };
  const onLineColorChange = color => {
    updateMapSetting('spatialFiltersLineColor', color);
  };
  const onShowSpatialFiltersChange = event => {
    updateMapSetting('showSpatialFilters', event.target.checked);
  };
  const renderStyleInputs = () => {
    if (!settings.showSpatialFilters) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alpha_slider.AlphaSlider, {
      alpha: settings.spatialFiltersAlpa,
      onChange: onAlphaChange
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.spatialFiltersFillColorLabel', {
        defaultMessage: 'Fill color'
      }),
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_mb_validated_color_picker.MbValidatedColorPicker, {
      color: settings.spatialFiltersFillColor,
      onChange: onFillColorChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.spatialFiltersLineColorLabel', {
        defaultMessage: 'Border color'
      }),
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_mb_validated_color_picker.MbValidatedColorPicker, {
      color: settings.spatialFiltersLineColor,
      onChange: onLineColorChange
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.mapSettingsPanel.spatialFiltersTitle",
    defaultMessage: "Spatial filters"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.showSpatialFiltersLabel', {
      defaultMessage: 'Show spatial filters on map'
    }),
    checked: settings.showSpatialFilters,
    onChange: onShowSpatialFiltersChange,
    compressed: true
  })), renderStyleInputs());
}