"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapSettingsPanel = void 0;
var _reactRedux = require("react-redux");
var _ui = require("../../reducers/ui");
var _map_settings_panel = require("./map_settings_panel");
var _actions = require("../../actions");
var _map_selectors = require("../../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    center: (0, _map_selectors.getMapCenter)(state),
    customIcons: (0, _map_selectors.getCustomIcons)(state),
    hasMapSettingsChanges: (0, _map_selectors.hasMapSettingsChanges)(state),
    settings: (0, _map_selectors.getMapSettings)(state),
    zoom: (0, _map_selectors.getMapZoom)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    cancelChanges: () => {
      dispatch((0, _actions.rollbackMapSettings)());
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.NONE));
    },
    keepChanges: () => {
      dispatch((0, _actions.updateFlyout)(_ui.FLYOUT_STATE.NONE));
    },
    updateMapSetting: (settingKey, settingValue) => {
      dispatch((0, _actions.updateMapSetting)(settingKey, settingValue));
    },
    updateCustomIcons: customIcons => {
      dispatch((0, _actions.updateCustomIcons)(customIcons));
    },
    deleteCustomIcon: symbolId => {
      dispatch((0, _actions.deleteCustomIcon)(symbolId));
    }
  };
}
const connectedMapSettingsPanel = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_map_settings_panel.MapSettingsPanel);
exports.MapSettingsPanel = connectedMapSettingsPanel;