"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditLayerPanel = void 0;
var _reactRedux = require("react-redux");
var _edit_layer_panel = require("./edit_layer_panel");
var _map_selectors = require("../../selectors/map_selectors");
var _actions = require("../../actions");
var _vector_layer = require("../../classes/layers/vector_layer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  const selectedLayer = (0, _map_selectors.getSelectedLayer)(state);
  let key = 'none';
  if (selectedLayer) {
    key = (0, _vector_layer.isVectorLayer)(selectedLayer) ? `${selectedLayer.getId()}${selectedLayer.getSource().supportsJoins()}` : selectedLayer.getId();
  }
  return {
    key,
    selectedLayer
  };
}
function mapDispatchToProps(dispatch) {
  return {
    updateSourceProps: async (id, sourcePropChanges) => await dispatch((0, _actions.updateSourceProps)(id, sourcePropChanges)),
    updateStyleDescriptor: styleDescriptor => {
      dispatch((0, _actions.updateLayerStyleForSelectedLayer)(styleDescriptor));
    }
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_edit_layer_panel.EditLayerPanel);
exports.EditLayerPanel = connected;