"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TermJoinKeyLabel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TermJoinKeyLabel extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      rightSourceLabels: []
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadRightSourceLabels();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadRightSourceLabels() {
    const rightSourceLabels = await (0, _std.asyncMap)(this.props.termJoins, async termJoin => {
      const termField = termJoin.getTermField();
      return `'${await termField.getLabel()}'`;
    });
    if (this._isMounted) {
      this.setState({
        rightSourceLabels
      });
    }
  }
  render() {
    if (this.state.rightSourceLabels.length === 0) {
      return this.props.leftFieldName;
    }
    const content = _i18n.i18n.translate('xpack.maps.tooltip.joinPropertyTooltipContent', {
      defaultMessage: `Shared key '{leftFieldName}' is joined with {rightSources}`,
      values: {
        leftFieldName: this.props.leftFieldName,
        rightSources: this.state.rightSourceLabels.join(',')
      }
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.leftFieldName, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: content
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "link"
    })));
  }
}
exports.TermJoinKeyLabel = TermJoinKeyLabel;