"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLYGON_STYLES = exports.MIN_SIZE = exports.MAX_SIZE = exports.LINE_STYLES = exports.LABEL_STYLES = exports.DEFAULT_SIGMA = exports.DEFAULT_MIN_SIZE = exports.DEFAULT_MAX_SIZE = exports.DEFAULT_LABEL_SIZE = exports.DEFAULT_ICON_SIZE = exports.DEFAULT_COLOR_RAMP = exports.DEFAULT_COLOR_PALETTE = void 0;
exports.getDefaultDynamicProperties = getDefaultDynamicProperties;
exports.getDefaultStaticProperties = getDefaultStaticProperties;
var _constants = require("../../../../common/constants");
var _color_palettes = require("../color_palettes");
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_SIZE = 1;
exports.MIN_SIZE = MIN_SIZE;
const MAX_SIZE = 64;
exports.MAX_SIZE = MAX_SIZE;
const DEFAULT_MIN_SIZE = 7; // Make default large enough to fit default label size
exports.DEFAULT_MIN_SIZE = DEFAULT_MIN_SIZE;
const DEFAULT_MAX_SIZE = 32;
exports.DEFAULT_MAX_SIZE = DEFAULT_MAX_SIZE;
const DEFAULT_SIGMA = 3;
exports.DEFAULT_SIGMA = DEFAULT_SIGMA;
const DEFAULT_LABEL_SIZE = 14;
exports.DEFAULT_LABEL_SIZE = DEFAULT_LABEL_SIZE;
const DEFAULT_ICON_SIZE = 6;
exports.DEFAULT_ICON_SIZE = DEFAULT_ICON_SIZE;
const DEFAULT_COLOR_RAMP = _color_palettes.NUMERICAL_COLOR_PALETTES[0].value;
exports.DEFAULT_COLOR_RAMP = DEFAULT_COLOR_RAMP;
const DEFAULT_COLOR_PALETTE = _color_palettes.CATEGORICAL_COLOR_PALETTES[0].value;
exports.DEFAULT_COLOR_PALETTE = DEFAULT_COLOR_PALETTE;
const LABEL_STYLES = [_constants.VECTOR_STYLES.LABEL_SIZE, _constants.VECTOR_STYLES.LABEL_COLOR, _constants.VECTOR_STYLES.LABEL_BORDER_COLOR, _constants.VECTOR_STYLES.LABEL_BORDER_SIZE];
exports.LABEL_STYLES = LABEL_STYLES;
const LINE_STYLES = [_constants.VECTOR_STYLES.LINE_COLOR, _constants.VECTOR_STYLES.LINE_WIDTH, ...LABEL_STYLES];
exports.LINE_STYLES = LINE_STYLES;
const POLYGON_STYLES = [_constants.VECTOR_STYLES.FILL_COLOR, _constants.VECTOR_STYLES.LINE_COLOR, _constants.VECTOR_STYLES.LINE_WIDTH, ...LABEL_STYLES];
exports.POLYGON_STYLES = POLYGON_STYLES;
function getDefaultStaticProperties(mapColors = []) {
  let nextColorIndex = 0;
  if (mapColors.length) {
    const lastColor = mapColors[mapColors.length - 1];
    if (_color_palettes.DEFAULT_FILL_COLORS.includes(lastColor)) {
      nextColorIndex = (_color_palettes.DEFAULT_FILL_COLORS.indexOf(lastColor) + 1) % _color_palettes.DEFAULT_FILL_COLORS.length;
    }
  }
  const nextFillColor = _color_palettes.DEFAULT_FILL_COLORS[nextColorIndex];
  const nextLineColor = _color_palettes.DEFAULT_LINE_COLORS[nextColorIndex];
  const isDarkMode = (0, _kibana_services.getIsDarkMode)();
  return {
    [_constants.VECTOR_STYLES.ICON]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        value: _constants.DEFAULT_ICON
      }
    },
    [_constants.VECTOR_STYLES.FILL_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: nextFillColor
      }
    },
    [_constants.VECTOR_STYLES.LINE_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: nextLineColor
      }
    },
    [_constants.VECTOR_STYLES.LINE_WIDTH]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        size: 1
      }
    },
    [_constants.VECTOR_STYLES.ICON_SIZE]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        size: DEFAULT_ICON_SIZE
      }
    },
    [_constants.VECTOR_STYLES.ICON_ORIENTATION]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        orientation: 0
      }
    },
    [_constants.VECTOR_STYLES.LABEL_TEXT]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        value: ''
      }
    },
    [_constants.VECTOR_STYLES.LABEL_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: isDarkMode ? '#FFFFFF' : '#000000'
      }
    },
    [_constants.VECTOR_STYLES.LABEL_SIZE]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        size: DEFAULT_LABEL_SIZE
      }
    },
    [_constants.VECTOR_STYLES.LABEL_ZOOM_RANGE]: {
      options: {
        useLayerZoomRange: true,
        minZoom: _constants.MIN_ZOOM,
        maxZoom: _constants.MAX_ZOOM
      }
    },
    [_constants.VECTOR_STYLES.LABEL_BORDER_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: isDarkMode ? '#000000' : '#FFFFFF'
      }
    },
    [_constants.VECTOR_STYLES.SYMBOLIZE_AS]: {
      options: {
        value: _constants.SYMBOLIZE_AS_TYPES.CIRCLE
      }
    },
    [_constants.VECTOR_STYLES.LABEL_BORDER_SIZE]: {
      options: {
        size: _constants.LABEL_BORDER_SIZES.SMALL
      }
    },
    [_constants.VECTOR_STYLES.LABEL_POSITION]: {
      options: {
        position: _constants.LABEL_POSITIONS.CENTER
      }
    }
  };
}
function getDefaultDynamicProperties() {
  return {
    [_constants.VECTOR_STYLES.ICON]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        iconPaletteId: 'filledShapes',
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true
        }
      }
    },
    [_constants.VECTOR_STYLES.FILL_COLOR]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        color: DEFAULT_COLOR_RAMP,
        colorCategory: DEFAULT_COLOR_PALETTE,
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.LINE_COLOR]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        color: DEFAULT_COLOR_RAMP,
        colorCategory: DEFAULT_COLOR_PALETTE,
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.LINE_WIDTH]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        minSize: 1,
        maxSize: 10,
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.ICON_SIZE]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        minSize: DEFAULT_MIN_SIZE,
        maxSize: DEFAULT_MAX_SIZE,
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.ICON_ORIENTATION]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.LABEL_TEXT]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        field: undefined
      }
    },
    [_constants.VECTOR_STYLES.LABEL_ZOOM_RANGE]: {
      options: {
        useLayerZoomRange: true,
        minZoom: _constants.MIN_ZOOM,
        maxZoom: _constants.MAX_ZOOM
      }
    },
    [_constants.VECTOR_STYLES.LABEL_COLOR]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        color: DEFAULT_COLOR_RAMP,
        colorCategory: DEFAULT_COLOR_PALETTE,
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.LABEL_SIZE]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        minSize: DEFAULT_MIN_SIZE,
        maxSize: DEFAULT_MAX_SIZE,
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.LABEL_BORDER_COLOR]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        color: DEFAULT_COLOR_RAMP,
        colorCategory: DEFAULT_COLOR_PALETTE,
        field: undefined,
        fieldMetaOptions: {
          isEnabled: true,
          sigma: DEFAULT_SIGMA
        }
      }
    },
    [_constants.VECTOR_STYLES.SYMBOLIZE_AS]: {
      options: {
        value: _constants.SYMBOLIZE_AS_TYPES.CIRCLE
      }
    },
    [_constants.VECTOR_STYLES.LABEL_BORDER_SIZE]: {
      options: {
        size: _constants.LABEL_BORDER_SIZES.SMALL
      }
    },
    [_constants.VECTOR_STYLES.LABEL_POSITION]: {
      options: {
        position: _constants.LABEL_POSITIONS.CENTER
      }
    }
  };
}