"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAKI_ICONS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAKI_ICONS = {
  aerialway: {
    label: 'Aerialway',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="aerialway-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13,5H8V2.6c0.1854-0.1047,0.3325-0.2659,0.42-0.46L13.5,1.5C13.7761,1.5,14,1.2761,14,1s-0.2239-0.5-0.5-0.5L8.28,1.15&#xA;&#x9;C8.0954,0.9037,7.8077,0.7562,7.5,0.75C7.0963,0.752,6.7334,0.9966,6.58,1.37L1.5,2C1.2239,2,1,2.2239,1,2.5S1.2239,3,1.5,3&#xA;&#x9;l5.22-0.65C6.7967,2.4503,6.8917,2.5351,7,2.6V5H2C1.4477,5,1,5.4477,1,6v7c0,0.5523,0.4477,1,1,1h11c0.5523,0,1-0.4477,1-1V6&#xA;&#x9;C14,5.4477,13.5523,5,13,5z M7,11H3V7h4V11z M12,11H8V7h4V11z"/>\n</svg>'
  },
  airfield: {
    label: 'Airfield',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="airfield-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path5" d="M6.8182,0.6818H4.7727&#xA;&#x9;C4.0909,0.6818,4.0909,0,4.7727,0h5.4545c0.6818,0,0.6818,0.6818,0,0.6818H8.1818c0,0,0.8182,0.5909,0.8182,1.9545V4h6v2L9,8l-0.5,5&#xA;&#x9;l2.5,1.3182V15H4v-0.6818L6.5,13L6,8L0,6V4h6V2.6364C6,1.2727,6.8182,0.6818,6.8182,0.6818z"/>\n</svg>'
  },
  airport: {
    label: 'Airport',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="airport-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path7712-0" d="M15,6.8182L15,8.5l-6.5-1&#xA;&#x9;l-0.3182,4.7727L11,14v1l-3.5-0.6818L4,15v-1l2.8182-1.7273L6.5,7.5L0,8.5V6.8182L6.5,4.5v-3c0,0,0-1.5,1-1.5s1,1.5,1,1.5v2.8182&#xA;&#x9;L15,6.8182z"/>\n</svg>'
  },
  'alcohol-shop': {
    label: 'Alcohol shop',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="alcohol-shop-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,4h-4v3.44l0,0c0,0,0,0,0,0.06c0.003,0.9096,0.6193,1.7026,1.5,1.93V13H11c-0.2761,0-0.5,0.2239-0.5,0.5&#xA;&#x9;S10.7239,14,11,14h2c0.2761,0,0.5-0.2239,0.5-0.5S13.2761,13,13,13h-0.5V9.43c0.8807-0.2274,1.497-1.0204,1.5-1.93c0,0,0,0,0-0.06&#xA;&#x9;l0,0V4z M13,7.5c0,0.5523-0.4477,1-1,1s-1-0.4477-1-1V5h2V7.5z M5.5,2.5V2C5.7761,2,6,1.7761,6,1.5S5.7761,1,5.5,1V0.5&#xA;&#x9;C5.5,0.2239,5.2761,0,5,0H4C3.7239,0,3.5,0.2239,3.5,0.5V1C3.2239,1,3,1.2239,3,1.5S3.2239,2,3.5,2v0.5C3.5,3.93,1,5.57,1,7v6&#xA;&#x9;c0,0.5523,0.4477,1,1,1h5c0.5318-0.0465,0.9535-0.4682,1-1V7C8,5.65,5.5,3.85,5.5,2.5z M4.5,12C3.1193,12,2,10.8807,2,9.5&#xA;&#x9;S3.1193,7,4.5,7S7,8.1193,7,9.5S5.8807,12,4.5,12z"/>\n</svg>'
  },
  'american-football': {
    label: 'American football',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="american-football-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M7.53,3C3.09,3,1,7.5,1,7.5S3.09,12,7.53,12S14,7.5,14,7.5S12,3,7.53,3z M11,7v1.5C11,8.7761,10.7761,9,10.5,9&#xA;&#x9;S10,8.7761,10,8.5V8H8v0.5C8,8.7761,7.7761,9,7.5,9S7,8.7761,7,8.5V8H5v0.5C5,8.7761,4.7761,9,4.5,9S4,8.7761,4,8.5v-2&#xA;&#x9;C4,6.2239,4.2239,6,4.5,6S5,6.2239,5,6.5V7h2V6.5C7,6.2239,7.2239,6,7.5,6S8,6.2239,8,6.5V7h2V6.5C10,6.2239,10.2239,6,10.5,6&#xA;&#x9;S11,6.2239,11,6.5V7z"/>\n</svg>'
  },
  'amusement-park': {
    label: 'Amusement park',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="amusement-park-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path5082" d="M7.5,0C3.919,0,1,2.919,1,6.5c0,2.3161,1.2251,4.3484,3.0566,5.5H4l-1,2h9l-1-2h-0.0566&#xA;&#x9;C12.7749,10.8484,14,8.8161,14,6.5C14,2.919,11.081,0,7.5,0z M7.375,1.5059v3.5c-0.3108,0.026-0.6057,0.1482-0.8438,0.3496&#xA;&#x9;L4.0566,2.8809C4.9243,2.0555,6.0851,1.5376,7.375,1.5059z M7.625,1.5059c1.2899,0.0317,2.4507,0.5496,3.3184,1.375L8.4688,5.3555&#xA;&#x9;c-0.0007-0.0007-0.0013-0.0013-0.002-0.002C8.229,5.1532,7.9348,5.0317,7.625,5.0059V1.5059z M3.8809,3.0566l2.4746,2.4746&#xA;&#x9;c-0.0007,0.0007-0.0013,0.0013-0.002,0.002C6.1532,5.771,6.0317,6.0652,6.0059,6.375h-3.5&#xA;&#x9;C2.5376,5.0851,3.0555,3.9243,3.8809,3.0566z M11.1191,3.0566c0.8254,0.8676,1.3433,2.0285,1.375,3.3184h-3.5&#xA;&#x9;c-0.026-0.3108-0.1482-0.6057-0.3496-0.8438L11.1191,3.0566z M2.5059,6.625h3.5c0.026,0.3108,0.1482,0.6057,0.3496,0.8438&#xA;&#x9;L3.8809,9.9434C3.0555,9.0757,2.5376,7.9149,2.5059,6.625z M8.9941,6.625h3.5c-0.0317,1.2899-0.5496,2.4507-1.375,3.3184&#xA;&#x9;L8.6445,7.4688c0.0007-0.0007,0.0013-0.0013,0.002-0.002C8.8468,7.229,8.9683,6.9348,8.9941,6.625z M6.5312,7.6445&#xA;&#x9;c0.0007,0.0007,0.0013,0.0013,0.002,0.002C6.6716,7.7624,6.8297,7.8524,7,7.9121v3.5625c-1.1403-0.1124-2.1606-0.6108-2.9434-1.3555&#xA;&#x9;L6.5312,7.6445z M8.4688,7.6445l2.4746,2.4746c-0.7828,0.7447-1.803,1.243-2.9434,1.3555V7.9121&#xA;&#x9;C8.1711,7.852,8.33,7.7613,8.4688,7.6445z"/>\n</svg>'
  },
  aquarium: {
    label: 'Aquarium',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="aquarium-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M10.9,11.6c-0.3-0.6-0.3-2.3,0-2.8c0.4-0.6,3.4,1.4,3.4,1.4c0.9,0.4,0.9-6.1,0-5.7&#xA;&#x9;c0,0-3.1,2.1-3.4,1.4c-0.3-0.7-0.3-2.1,0-2.8C11.2,2.5,15,2.4,15,2.4C15,1.7,12.1,1,10.9,1S8.4,1.1,6.8,1.8C5.2,2.4,3.9,3.4,2.7,4.6&#xA;&#x9;S0,8.2,0,8.9s1.5,2.8,3.7,3.7s3.3,1.1,4.5,1.3c1.1,0.1,2.6,0,3.9-0.3c1-0.2,2.9-0.7,2.9-1.1C15,12.3,11.2,12.2,10.9,11.6z M4.5,9.3&#xA;&#x9;C3.7,9.3,3,8.6,3,7.8s0.7-1.5,1.5-1.5S6,7,6,7.8S5.3,9.3,4.5,9.3z"/>\n</svg>'
  },
  'arrow-es': {
    label: 'Arrow',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="arrow-es-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M10.2605799,13.3863593 C10.1395968,13.4287864 10.0527368,13.45 10,13.45 C9.86888463,13.45 9.7495566,13.3995324 9.66038175,13.3169629 C9.62336122,13.2826846 7.87888372,11.1717162 7.85312988,11.1460236 C7.76268134,11.05579 7.6378559,11 7.5,11 C7.36106093,11 7.23535789,11.0566702 7.14474446,11.1481569 C7.11712067,11.176047 5.38316951,13.2743383 5.3512134,13.3058781 C5.26092214,13.3949932 5.13688483,13.45 5,13.45 C4.94846592,13.45 4.86607927,13.4308817 4.75284004,13.3926451 C3.95322232,13.0192244 3.32116699,12.5002136 3.1295929,12.3130188 C3.04943242,12.222975 2.999749,12.1044865 2.999749,11.9743938 C2.999749,11.8971872 3.01724809,11.8240676 3.04849642,11.7587851 L7.04,1.29 L7.04612499,1.289958 C7.12548958,1.1187486 7.29887718,1 7.5,1 C7.6986843,1 7.87030186,1.11588651 7.9509469,1.28375376 L7.95635553,1.28371668 L11.962677,11.7834625 C11.993942,11.8487592 12.0005287,11.9135014 12.0005287,11.99073 C12.0005287,12.1135282 11.962677,12.2262726 11.8828125,12.3130188 C11.7159576,12.47 10.804184,13.1774445 10.2605799,13.3863593 Z"/>\n</svg>'
  },
  'art-gallery': {
    label: 'Art gallery',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="art-gallery-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M10.71,4L7.85,1.15C7.6555,0.9539,7.339,0.9526,7.1429,1.1471C7.1419,1.1481,7.141,1.149,7.14,1.15L4.29,4H1.5&#xA;&#x9;C1.2239,4,1,4.2239,1,4.5v9C1,13.7761,1.2239,14,1.5,14h12c0.2761,0,0.5-0.2239,0.5-0.5v-9C14,4.2239,13.7761,4,13.5,4H10.71z&#xA;&#x9; M7.5,2.21L9.29,4H5.71L7.5,2.21z M13,13H2V5h11V13z M5,8C4.4477,8,4,7.5523,4,7s0.4477-1,1-1s1,0.4477,1,1S5.5523,8,5,8z M12,12&#xA;&#x9;H4.5L6,9l1.25,2.5L9.5,7L12,12z"/>\n</svg>'
  },
  attraction: {
    label: 'Attraction',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="attraction-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect7143" d="M6,2C5.446,2,5.2478,2.5045,5,3L4.5,4h-2C1.669,4,1,4.669,1,5.5v5C1,11.331,1.669,12,2.5,12h10&#xA;&#x9;c0.831,0,1.5-0.669,1.5-1.5v-5C14,4.669,13.331,4,12.5,4h-2L10,3C9.75,2.5,9.554,2,9,2H6z M2.5,5C2.7761,5,3,5.2239,3,5.5&#xA;&#x9;S2.7761,6,2.5,6S2,5.7761,2,5.5S2.2239,5,2.5,5z M7.5,5c1.6569,0,3,1.3431,3,3s-1.3431,3-3,3s-3-1.3431-3-3S5.8431,5,7.5,5z&#xA;&#x9; M7.5,6.5C6.6716,6.5,6,7.1716,6,8l0,0c0,0.8284,0.6716,1.5,1.5,1.5l0,0C8.3284,9.5,9,8.8284,9,8l0,0C9,7.1716,8.3284,6.5,7.5,6.5&#xA;&#x9;L7.5,6.5z"/>\n</svg>'
  },
  bakery: {
    label: 'Bakery',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="bakery-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path5230" d="M5.2941,4.3824L6,9.5&#xA;&#x9;c0,0,0,1,1,1h1c1,0,1-1,1-1l0.7059-5.1176C9.7059,3,7.5,3,7.5,3S5.291,3,5.2941,4.3824z M3.5,5C2,5,2,6,2,6l1,4h1.5&#xA;&#x9;c0.755,0,0.7941-0.7647,0.7941-0.7647L4.5,5H3.5z M1.5,7.5c0,0-0.6176-0.0294-1.0588,0.4118C0,8.3529,0,8.7941,0,8.7941V11h0.8824&#xA;&#x9;C2,11,2,10,2,10L1.5,7.5z"/>\n  <path id="path5230-2" d="M11.5,5C13,5,13,6,13,6l-1,4h-1.5&#xA;&#x9;c-0.755,0-0.7941-0.7647-0.7941-0.7647L10.5,5H11.5z M13.5,7.5c0,0,0.6176-0.0294,1.0588,0.4118C15,8.3529,15,8.7941,15,8.7941V11&#xA;&#x9;h-0.8824C13,11,13,10,13,10L13.5,7.5z"/>\n</svg>'
  },
  bank: {
    label: 'Bank',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="bank-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect5668" d="M1,3C0.446,3,0,3.446,0,4v7c0,0.554,0.446,1,1,1h13c0.554,0,1-0.446,1-1V4c0-0.554-0.446-1-1-1H1z M1,4h1.5&#xA;&#x9;C2.7761,4,3,4.2239,3,4.5S2.7761,5,2.5,5S2,4.7761,2,4.5L1.5,5C1.7761,5,2,5.2239,2,5.5S1.7761,6,1.5,6S1,5.7761,1,5.5V4z M7.5,4&#xA;&#x9;C8.8807,4,10,5.567,10,7.5l0,0C10,9.433,8.8807,11,7.5,11S5,9.433,5,7.5S6.1193,4,7.5,4z M12.5,4H14v1.5C14,5.7761,13.7761,6,13.5,6&#xA;&#x9;S13,5.7761,13,5.5S13.2239,5,13.5,5L13,4.5C13,4.7761,12.7761,5,12.5,5S12,4.7761,12,4.5S12.2239,4,12.5,4z M7.5,5.5&#xA;&#x9;c-0.323,0-0.5336,0.1088-0.6816,0.25h1.3633C8.0336,5.6088,7.823,5.5,7.5,5.5z M6.625,6C6.5795,6.091,6.5633,6.1711,6.5449,6.25&#xA;&#x9;h1.9102C8.4367,6.1711,8.4205,6.091,8.375,6H6.625z M6.5,6.5v0.25h2V6.5H6.5z M6.5,7v0.25h2V7H6.5z M6.5,7.5v0.25h2V7.5H6.5z M6.5,8&#xA;&#x9;L6.25,8.25h2L8.5,8H6.5z M6,8.5c0,0,0.0353,0.1024,0.1016,0.25H8.375L8,8.5H6z M1.5,9C1.7761,9,2,9.2239,2,9.5S1.7761,10,1.5,10&#xA;&#x9;L2,10.5C2,10.2239,2.2239,10,2.5,10S3,10.2239,3,10.5S2.7761,11,2.5,11H1V9.5C1,9.2239,1.2239,9,1.5,9z M6.2383,9&#xA;&#x9;C6.2842,9.0856,6.3144,9.159,6.375,9.25h2.2676C8.7092,9.1121,8.75,9,8.75,9H6.2383z M13.5,9C13.7761,9,14,9.2239,14,9.5V11h-1.5&#xA;&#x9;c-0.2761,0-0.5-0.2239-0.5-0.5s0.2239-0.5,0.5-0.5s0.5,0.2239,0.5,0.5l0.5-0.5C13.2239,10,13,9.7761,13,9.5S13.2239,9,13.5,9z&#xA;&#x9; M6.5664,9.5c0.0786,0.0912,0.1647,0.1763,0.2598,0.25h1.4199C8.3462,9.6727,8.4338,9.5883,8.5,9.5H6.5664z"/>\n</svg>'
  },
  bar: {
    label: 'Bar',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="bar-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path4" d="M7.5,1c-2,0-7,0.25-6.5,0.75L7,8v4&#xA;&#x9;c0,1-3,0.5-3,2h7c0-1.5-3-1-3-2V8l6-6.25C14.5,1.25,9.5,1,7.5,1z M7.5,2c2.5,0,4.75,0.25,4.75,0.25L11.5,3h-8L2.75,2.25&#xA;&#x9;C2.75,2.25,5,2,7.5,2z"/>\n</svg>'
  },
  barrier: {
    label: 'Barrier',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="barrier-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M13,3H2A1,1,0,0,0,1,4v6a1,1,0,0,0,1,1H3v2.5a.5.5,0,0,0,1,0V13h7v.5a.5.5,0,0,0,1,0V11h1a1,1,0,0,0,1-1V4A1,1,0,0,0,13,3Zm0,1V6L11,4ZM9.5,4,13,7.5V10L7,4Zm-4,6L2,6.5V4l6,6ZM2,10V8l2,2Zm9,2H4V11h7Zm-.207-2H9.5l-6-6h2l6,6Z"/>\n</svg>'
  },
  baseball: {
    label: 'Baseball',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="baseball-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M10,3.5C10,4.3284,9.3284,5,8.5,5S7,4.3284,7,3.5S7.6716,2,8.5,2S10,2.6716,10,3.5z M7,0.28C7,0.1254,6.8746,0,6.72,0&#xA;&#x9;c0,0,0,0,0,0C6.6221,0.0262,6.5348,0.0821,6.47,0.16L4,4.59C3.9941,4.6331,3.9941,4.6769,4,4.72C4,4.8746,4.1254,5,4.28,5&#xA;&#x9;c0.1015-0.0243,0.1926-0.0803,0.26-0.16L7,0.41C7.006,0.3669,7.006,0.3231,7,0.28z M12.9,14.2L12.9,14.2L10,6.39l0,0&#xA;&#x9;C9.9526,6.1627,9.7522,5.9999,9.52,6h-5c-0.2761,0-0.5,0.2239-0.5,0.5S4.2439,7,4.52,7H7l1.45,2.51l-4.27,4.61l0,0&#xA;&#x9;C4.0659,14.2132,3.9998,14.3527,4,14.5C4,14.7761,4.2239,15,4.5,15c0.1224-0.0006,0.2401-0.047,0.33-0.13l0,0l4.45-4.15l2.76,4l0,0&#xA;&#x9;c0.0895,0.1592,0.2574,0.2584,0.44,0.26c0.2796,0.0002,0.5092-0.2207,0.52-0.5C12.9958,14.3787,12.961,14.281,12.9,14.2z"/>\n</svg>'
  },
  basketball: {
    label: 'Basketball',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="basketball-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="icon_concepts:_sports_leisure" d="M3.66,7.0016H2.03a5.3231,5.3231,0,0,1,1.01-2.71A8.7122,8.7122,0,0,1,3.66,7.0016Zm1.075,0h2.34v-4.97a5.4585,5.4585,0,0,0-3.24,1.44A9.2947,9.2947,0,0,1,4.735,7.0016Zm3.19-4.97v4.97h2.34a9.2947,9.2947,0,0,1,.9-3.53A5.4585,5.4585,0,0,0,7.925,2.0316Zm4.035,2.26a8.7122,8.7122,0,0,0-.62,2.71h1.63A5.3231,5.3231,0,0,0,11.96,4.2916ZM14,8.7516a.7555.7555,0,0,1-.75.75H11.72l-.76,1.52v2.38a.392.392,0,0,1-.24.35.5863.5863,0,0,1-.14.02.3274.3274,0,0,1-.26-.11l-1.02-1.01-1.59,1.06a.3975.3975,0,0,1-.42,0l-1.59-1.06-1.02,1.01a.3709.3709,0,0,1-.4.09.392.392,0,0,1-.24-.35v-2.38l-.76-1.52H1.75a.75.75,0,0,1,0-1.5h11.5A.749.749,0,0,1,14,8.75Zm-7.14.75H4.12l.63,1.27a.3175.3175,0,0,1,.04.16v1.56l.56-.55Zm1.98,2.55L7.5,9.8916l-1.34,2.16,1.34.9Zm2.05-2.55H8.14l1.51,2.44.56.55v-1.56a.3175.3175,0,0,1,.04-.16Z"/>\n</svg>'
  },
  bbq: {
    label: 'BBQ',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="bbq-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M9.32,7.655C10.8782,7.108,11.9471,5.6506,12,4H3c0.053,1.6299,1.0978,3.0728,2.63,3.631L4.923,9.044&#xA;&#x9;c-1.3571-0.2355-2.6482,0.6737-2.8837,2.0308s0.6737,2.6482,2.0308,2.8837C4.9927,14.1187,5.9273,13.7485,6.49,13h4.223l0.335,0.717&#xA;&#x9;c0.0836,0.1735,0.2594,0.2836,0.452,0.283c0.0733,0.0003,0.1457-0.0158,0.212-0.047c0.2497-0.117,0.3575-0.4141,0.241-0.664&#xA;&#x9;L9.32,7.655z M4.5,12.75c-0.6904,0-1.25-0.5596-1.25-1.25s0.5596-1.25,1.25-1.25s1.25,0.5596,1.25,1.25&#xA;&#x9;C5.7484,12.1897,5.1897,12.7484,4.5,12.75z M6.95,12c0.2066-1.007-0.2268-2.0374-1.091-2.594L6.6,7.923&#xA;&#x9;c0.577,0.1042,1.168,0.1042,1.745,0l1.9,4.07L6.95,12z M4.75,1C4.6119,1,4.5,1.1119,4.5,1.25c0,0.5-0.5,0.5-0.5,0.5c-1,0-1,1-1,1&#xA;&#x9;C3,2.8881,3.1119,3,3.25,3S3.5,2.8881,3.5,2.75c0-0.5,0.5-0.5,0.5-0.5c1,0,1-1,1-1C5,1.1119,4.8881,1,4.75,1z M6.75,1&#xA;&#x9;C6.6119,1,6.5,1.1119,6.5,1.25c0,0.5-0.5,0.5-0.5,0.5c-1,0-1,1-1,1C5,2.8881,5.1119,3,5.25,3S5.5,2.8881,5.5,2.75&#xA;&#x9;c0-0.5,0.5-0.5,0.5-0.5c1,0,1-1,1-1C7,1.1119,6.8881,1,6.75,1z M8.75,1C8.6119,1,8.5,1.1119,8.5,1.25c0,0.5-0.5,0.5-0.5,0.5&#xA;&#x9;c-1,0-1,1-1,1C7,2.8881,7.1119,3,7.25,3S7.5,2.8881,7.5,2.75c0-0.5,0.5-0.5,0.5-0.5c1,0,1-1,1-1C9,1.1119,8.8881,1,8.75,1z M10.75,1&#xA;&#x9;c-0.1381,0-0.25,0.1119-0.25,0.25c0,0.5-0.5,0.5-0.5,0.5c-1,0-1,1-1,1C9,2.8881,9.1119,3,9.25,3S9.5,2.8881,9.5,2.75&#xA;&#x9;c0-0.5,0.5-0.5,0.5-0.5c1,0,1-1,1-1C11,1.1119,10.8881,1,10.75,1z M12.75,1c-0.1381,0-0.25,0.1119-0.25,0.25c0,0.5-0.5,0.5-0.5,0.5&#xA;&#x9;c-1,0-1,1-1,1C11,2.8881,11.1119,3,11.25,3s0.25-0.1119,0.25-0.25c0-0.5,0.5-0.5,0.5-0.5c1,0,1-1,1-1C13,1.1119,12.8881,1,12.75,1z"/>\n</svg>'
  },
  beach: {
    label: 'Beach',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="beach-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M5.3608,1.67l-.01,4.02a4.4523,4.4523,0,0,0-1.1-.11c-.37.1-.74.63-1.1.76A4.2019,4.2019,0,0,1,5.3608,1.67Zm2.41-.64,2.03,3.45a3.1832,3.1832,0,0,1,.84-.61c.36-.1.94.17,1.34.11A4.2018,4.2018,0,0,0,7.7708,1.03ZM1.0008,13h13c-.66-.66-2.64-1.11-4.34-1.33l-1.87-7c.52-.05,1.15.03,1.53,0l-2.11-3.6h-.01a6.1743,6.1743,0,0,0-.7.14,4.3792,4.3792,0,0,0-.64.22l-.01,4.15c.35-.17.84-.54,1.3-.74l1.8,6.74c-.58-.05-1.09-.08-1.45-.08C6.0308,11.5,2.0008,12,1.0008,13Z"/>\n</svg>'
  },
  beer: {
    label: 'Beer',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="beer-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12,5V2c0,0-1-1-4.5-1S3,2,3,2v3c0.0288,1.3915,0.3706,2.7586,1,4c0.6255,1.4348,0.6255,3.0652,0,4.5c0,0,0,1,3.5,1&#xA;&#x9;s3.5-1,3.5-1c-0.6255-1.4348-0.6255-3.0652,0-4.5C11.6294,7.7586,11.9712,6.3915,12,5z M7.5,13.5&#xA;&#x9;c-0.7966,0.035-1.5937-0.0596-2.36-0.28c0.203-0.7224,0.304-1.4696,0.3-2.22h4.12c-0.004,0.7504,0.097,1.4976,0.3,2.22&#xA;&#x9;C9.0937,13.4404,8.2966,13.535,7.5,13.5z M7.5,5C6.3136,5.0299,5.1306,4.8609,4,4.5v-2C5.131,2.1411,6.3137,1.9722,7.5,2&#xA;&#x9;C8.6863,1.9722,9.869,2.1411,11,2.5v2C9.8694,4.8609,8.6864,5.0299,7.5,5z"/>\n</svg>'
  },
  bicycle: {
    label: 'Bicycle',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="bicycle-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path4668" d="&#xA;&#x9;M7.5,2c-0.6761-0.01-0.6761,1.0096,0,1H9v1.2656l-2.8027,2.334L5.2226,4H5.5c0.6761,0.01,0.6761-1.0096,0-1h-2&#xA;&#x9;c-0.6761-0.01-0.6761,1.0096,0,1h0.6523L5.043,6.375C4.5752,6.1424,4.0559,6,3.5,6C1.5729,6,0,7.5729,0,9.5S1.5729,13,3.5,13&#xA;&#x9;S7,11.4271,7,9.5c0-0.6699-0.2003-1.2911-0.5293-1.8242L9.291,5.3262l0.4629,1.1602C8.7114,7.0937,8,8.2112,8,9.5&#xA;&#x9;c0,1.9271,1.5729,3.5,3.5,3.5S15,11.4271,15,9.5S13.4271,6,11.5,6c-0.2831,0-0.5544,0.0434-0.8184,0.1074L10,4.4023V2.5&#xA;&#x9;c0-0.2761-0.2239-0.5-0.5-0.5H7.5z M3.5,7c0.5923,0,1.1276,0.2119,1.5547,0.5527l-1.875,1.5625&#xA;&#x9;c-0.5109,0.4273,0.1278,1.1945,0.6406,0.7695l1.875-1.5625C5.8835,8.674,6,9.0711,6,9.5C6,10.8866,4.8866,12,3.5,12S1,10.8866,1,9.5&#xA;&#x9;S2.1133,7,3.5,7L3.5,7z M11.5,7C12.8866,7,14,8.1134,14,9.5S12.8866,12,11.5,12S9,10.8866,9,9.5c0-0.877,0.4468-1.6421,1.125-2.0879&#xA;&#x9;l0.9102,2.2734c0.246,0.6231,1.1804,0.2501,0.9297-0.3711l-0.9082-2.2695C11.2009,7.0193,11.3481,7,11.5,7L11.5,7z"/>\n</svg>'
  },
  'bicycle-share': {
    label: 'Bicycle share',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="bicycle-share-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="circle4604" d="&#xA;&#x9;M10,1C9.4477,1,9,1.4477,9,2c0,0.5523,0.4477,1,1,1s1-0.4477,1-1C11,1.4477,10.5523,1,10,1z M8.1445,2.9941&#xA;&#x9;c-0.13,0.0005-0.2547,0.0517-0.3477,0.1426l-2.6406,2.5c-0.2256,0.2128-0.2051,0.5775,0.043,0.7637L7,7.75v2.75&#xA;&#x9;c-0.01,0.6762,1.0096,0.6762,1,0v-3c0.0003-0.1574-0.0735-0.3057-0.1992-0.4004L7.0332,6.5234l1.818-1.7212l0.7484,0.9985&#xA;&#x9;C9.6943,5.9265,9.8426,6.0003,10,6h1.5c0.6761,0.01,0.6761-1.0096,0-1h-1.25L9.5,4L8.9004,3.1992&#xA;&#x9;C8.8103,3.0756,8.6685,3,8.5156,2.9941H8.1445z M3,7c-1.6569,0-3,1.3432-3,3s1.3431,3,3,3s3-1.3432,3-3S4.6569,7,3,7z M12,7&#xA;&#x9;c-1.6569,0-3,1.3432-3,3s1.3431,3,3,3s3-1.3432,3-3S13.6569,7,12,7z M3,8c1.1046,0,2,0.8954,2,2s-0.8954,2-2,2s-2-0.8954-2-2&#xA;&#x9;S1.8954,8,3,8z M12,8c1.1046,0,2,0.8954,2,2s-0.8954,2-2,2s-2-0.8954-2-2S10.8954,8,12,8z"/>\n</svg>'
  },
  'blood-bank': {
    label: 'Blood bank',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="blood-bank-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11.2,7.1L11.2,7.1L7.5,2L3.8,7.1h0C3.3,7.8,3,8.7,3,9.6C3,12,5,14,7.5,14c0,0,0,0,0,0C10,14,12,12,12,9.6c0,0,0,0,0,0&#xA;&#x9;C12,8.7,11.7,7.8,11.2,7.1z M10,10H8v2H7v-2H5V9h2V7h1v2h2V10z"/>\n</svg>'
  },
  'boat-es': {
    label: 'Boat',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="boat-es-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M7.5,1 C8,1 9.87566518,2.18104212 10.5,4.5 C10.9049265,6.00401254 11.0940068,8.88591087 11,13.1405515 C10.9938023,13.421051 10.753592,13.5685436 10.630388,13.6000274 C9.58692536,13.8666758 8.54346268,14 7.5,14 C6.45774448,14 5.41548895,13.8669841 4.37323343,13.6009523 C4.24882229,13.5691968 4,13.4234619 4,13.1482845 C4,8.89280475 4.09292918,6.01197734 4.5,4.5 C5.1272892,2.1700687 7,1 7.5,1 Z M5,6.5 L5,7 C5.23163517,6.54355194 6.28428417,6 7.49376313,6 C8.70324208,6 9.76836483,6.54355194 10,7 L10,6.5 C10,5.67157288 8.874475,5 7.49376313,5 C6.11305125,5 5,5.67157288 5,6.5 Z M6,8 C5.44771525,8 5,8.44771525 5,9 L5,11 C5,11.5522847 5.44771525,12 6,12 L9,12 C9.55228475,12 10,11.5522847 10,11 L10,9 C10,8.44771525 9.55228475,8 9,8 L6,8 Z"/>\n</svg>'
  },
  'bowling-alley': {
    label: 'Bowling alley',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="bowling-alley-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="icon_concepts:_sports_leisure" d="M8.83,5.39a11.0127,11.0127,0,0,0-.96,4.28,11.4686,11.4686,0,0,0,.58,3.69A4.9424,4.9424,0,0,1,6,14,5,5,0,1,1,8.98,4.99C8.94,5.12,8.88,5.25,8.83,5.39ZM4.12,8.5a.62.62,0,1,0-.62.62h0a.6105.6105,0,0,0,.62-.6009C4.12,8.5128,4.12,8.5064,4.12,8.5ZM4.5,7.12a.62.62,0,1,0-.62-.62h0a.6106.6106,0,0,0,.6011.62ZM6.12,8.5a.62.62,0,1,0-.62.62h0a.6105.6105,0,0,0,.62-.6009C6.12,8.5128,6.12,8.5064,6.12,8.5Zm4.8022-5.3341c0-.7222-.1444-.7222-.1444-1.4444a.7222.7222,0,0,1,1.4444-.0007v.0007c0,.7222-.1444.7222-.1444,1.4444,0,2.1667,1.5528,3.6168,1.5528,6.5,0,2.1667-.6861,4.3333-1.4083,4.3333H10.7778c-.7222,0-1.4083-2.1667-1.4083-4.3333C9.3694,6.7826,10.9222,5.3325,10.9222,3.1659Z"/>\n</svg>'
  },
  bridge: {
    label: 'Bridge',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="bridge-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M0,8.842V13h2v-1c0.036-1.089,0.911-1.964,2-2c1.089,0.036,1.964,0.911,2,2v1h3v-1c0.036-1.089,0.911-1.964,2-2&#xA;&#x9;c1.089,0.036,1.964,0.911,2,2v1h2V8.842C10.6,3.082,3.071,4.4,0,8.842z M9.5,5.734c0.514,0.121,1.016,0.289,1.5,0.5V9H9.5V5.734z&#xA;&#x9; M9,5.634V9H7.5V5.506C8.003,5.506,8.505,5.549,9,5.634z M3.5,6.477C3.98,6.229,4.482,6.026,5,5.871V9H3.5V6.477z M5.5,9V5.73&#xA;&#x9;C5.993,5.615,6.495,5.543,7,5.515V9H5.5z M3,6.744V9H0.5C1.176,8.094,2.032,7.328,3,6.744z M11.5,9V6.5l-0.053-0.053&#xA;&#x9;C12.649,7.05,13.694,7.924,14.5,9H11.5z"/>\n</svg>'
  },
  building: {
    label: 'Building',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="building-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M3,2v11h5v-3h3v3h1V2H3z M7,12H4v-2h3V12z M7,9H4V7h3V9z M7,6H4V4h3V6z M11,9H8V7h3V9z M11,6H8V4h3V6z"/>\n</svg>'
  },
  'building-alt1': {
    label: 'Building 2',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="building-alt1-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11,13.5v-9C11,4.2,10.8,4,10.5,4H9V1L5,2.1v11.4H2V14h11v-0.5H11z M7,13.5V3h1v10.5H7z"/>\n</svg>'
  },
  bus: {
    label: 'Bus',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="bus-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path8043" d="M4,0C2.6364,0,1,0.7433,1,2.7461v5.4531V12c0,0,0,1,1,1v1c0,0,0,1,1,1s1-1,1-1v-1h7v1c0,0,0,1,1,1s1-1,1-1v-1&#xA;&#x9;c0,0,1,0,1-1V2.7461C14,0.7006,12.764,0,11.4004,0H4z M4.25,1.5h6.5C10.8885,1.5,11,1.6115,11,1.75S10.8885,2,10.75,2h-6.5&#xA;&#x9;C4.1115,2,4,1.8885,4,1.75S4.1115,1.5,4.25,1.5z M3,3h9c1,0,1,0.9668,1,0.9668V7c0,0,0,1-1,1H3C2,8,2,7,2,7V4C2,4,2,3,3,3z M3,10&#xA;&#x9;c0.5523,0,1,0.4477,1,1s-0.4477,1-1,1s-1-0.4477-1-1S2.4477,10,3,10z M12,10c0.5523,0,1,0.4477,1,1s-0.4477,1-1,1s-1-0.4477-1-1&#xA;&#x9;S11.4477,10,12,10z"/>\n</svg>'
  },
  cafe: {
    label: 'Cafe',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="cafe-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12,5h-2V3H2v4c0.0133,2.2091,1.8149,3.9891,4.024,3.9758C7.4345,10.9673,8.7362,10.2166,9.45,9H12c1.1046,0,2-0.8954,2-2&#xA;&#x9;S13.1046,5,12,5z M12,8H9.86C9.9487,7.6739,9.9958,7.3379,10,7V6h2c0.5523,0,1,0.4477,1,1S12.5523,8,12,8z M10,12.5&#xA;&#x9;c0,0.2761-0.2239,0.5-0.5,0.5h-7C2.2239,13,2,12.7761,2,12.5S2.2239,12,2.5,12h7C9.7761,12,10,12.2239,10,12.5z"/>\n</svg>'
  },
  campsite: {
    label: 'Campsite',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="campsite-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect3335" d="M7,1.5&#xA;&#x9;l-5.5,9H1c-1,0-1,1-1,1v1c0,0,0,1,1,1h13c1,0,1-1,1-1v-1c0,0,0-1-1-1h-0.5L8,1.5C7.8,1.1,7.2,1.1,7,1.5z M7.5,5l3.2,5.5H4.2L7.5,5z"/>\n</svg>'
  },
  car: {
    label: 'Car',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="car-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,7c-0.004-0.6904-0.4787-1.2889-1.15-1.45l-1.39-3.24l0,0l0,0l0,0C11.3833,2.1233,11.2019,2.001,11,2H4&#xA;&#x9;C3.8124,2.0034,3.6425,2.1115,3.56,2.28l0,0l0,0l0,0L2.15,5.54C1.475,5.702,0.9994,6.3059,1,7v3.5h1v1c0,0.5523,0.4477,1,1,1&#xA;&#x9;s1-0.4477,1-1v-1h7v1c0,0.5523,0.4477,1,1,1s1-0.4477,1-1v-1h1V7z M4.3,3h6.4l1.05,2.5h-8.5L4.3,3z M3,9C2.4477,9,2,8.5523,2,8&#xA;&#x9;s0.4477-1,1-1s1,0.4477,1,1S3.5523,9,3,9z M12,9c-0.5523,0-1-0.4477-1-1s0.4477-1,1-1s1,0.4477,1,1S12.5523,9,12,9z"/>\n</svg>'
  },
  'car-top-es': {
    label: 'Car 2',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="car-top-es-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11,7 L11,12 C11,13.1045695 10.1045695,14 9,14 L6,14 C4.8954305,14 4,13.1045695 4,12 L4,7 L3,7 C3,6.44771525 3.44771525,6 4,6 L4,4 C4,2.34314575 5.34314575,1 7,1 L8,1 C9.65685425,1 11,2.34314575 11,4 L11,6 C11.5522847,6 12,6.44771525 12,7 L11,7 Z M5.5,10 L5,11 C5.83333333,11.3333333 6.66666667,11.5 7.5,11.5 C8.33333333,11.5 9.16666667,11.3333333 10,11 L9.5,10 L7.5,10 L5.5,10 Z M5,6 L5.5,7 C6.16666667,6.66666667 6.83333333,6.5 7.5,6.5 C8.16666667,6.5 8.83333333,6.66666667 9.5,7 L10,6 C9.16666667,5.33333333 8.33333333,5 7.5,5 C6.66666667,5 5.83333333,5.33333333 5,6 Z M4.89290929,3.32453333 C5.05156229,3.45765901 5.39601532,3.30835135 5.66226667,2.99104535 C5.92851801,2.67373936 6.01574371,2.30859234 5.85709071,2.17546667 C5.69843771,2.04234099 5.35398468,2.19164865 5.08773333,2.50895465 C4.82148199,2.82626064 4.73425629,3.19140766 4.89290929,3.32453333 Z M10.1114481,3.32453333 C10.2701011,3.19140766 10.1828754,2.82626064 9.91662404,2.50895465 C9.65037269,2.19164865 9.30591967,2.04234099 9.14726667,2.17546667 C8.98861367,2.30859234 9.07583936,2.67373936 9.34209071,2.99104535 C9.60834205,3.30835135 9.95279508,3.45765901 10.1114481,3.32453333 Z"/>\n</svg>'
  },
  'car-rental': {
    label: 'Car rental',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="car-rental-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <g>\n    <path d="M11.5039,1H10C9.2616,1,8.6238,1.4047,8.2774,2H3.5l-1,1l1,1l1-1l1,1l1-1l1,1h0.7774C8.6238,4.5953,9.2616,5,10,5h1.4982&#xA;&#x9;&#x9;C11.7753,5,12,4.7753,12,4.4982V1.4961C12,1.2221,11.7779,1,11.5039,1z M11,3.5C11,3.7761,10.7761,4,10.5,4S10,3.7761,10,3.5v-1&#xA;&#x9;&#x9;C10,2.2238,10.2239,2,10.5,2S11,2.2238,11,2.5V3.5z"/>\n    <path d="M10.9252,9.0103l-0.3636-2.1802C10.4824,6.3491,10.0713,6,9.583,6H5.417C4.9302,6,4.5186,6.3486,4.4385,6.8291&#xA;&#x9;&#x9;L4.0746,9.0117C3.4776,9.0436,3,9.5277,3,10.1327V13h1c0,0.5522,0.4477,1,1,1s1-0.4478,1-1h3c0,0.5522,0.4477,1,1,1s1-0.4478,1-1h1&#xA;&#x9;&#x9;v-2.8744C12,9.522,11.5219,9.0383,10.9252,9.0103z M4.75,12C4.3358,12,4,11.6642,4,11.25c0-0.4142,0.3358-0.75,0.75-0.75&#xA;&#x9;&#x9;s0.75,0.3358,0.75,0.75C5.5,11.6642,5.1642,12,4.75,12z M5.0887,9L5.417,7l4.1582-0.0068L9.9098,9H5.0887z M10.25,12&#xA;&#x9;&#x9;c-0.4142,0-0.75-0.3358-0.75-0.75c0-0.4142,0.3358-0.75,0.75-0.75S11,10.8358,11,11.25C11,11.6642,10.6642,12,10.25,12z"/>\n  </g>\n</svg>'
  },
  'car-repair': {
    label: 'Car repair',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="car-repair-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <g>\n    <path d="M10.9252,9.0103l-0.3636-2.1802C10.4824,6.3491,10.0713,6,9.583,6H5.417C4.9302,6,4.5186,6.3486,4.4385,6.8291&#xA;&#x9;&#x9;L4.0746,9.0117C3.4776,9.0436,3,9.5277,3,10.1327V13h1c0,0.5522,0.4477,1,1,1s1-0.4478,1-1h3c0,0.5522,0.4477,1,1,1s1-0.4478,1-1h1&#xA;&#x9;&#x9;v-2.8744C12,9.522,11.5219,9.0383,10.9252,9.0103z M4.75,12C4.3358,12,4,11.6642,4,11.25c0-0.4142,0.3358-0.75,0.75-0.75&#xA;&#x9;&#x9;s0.75,0.3358,0.75,0.75C5.5,11.6642,5.1642,12,4.75,12z M5.0887,9L5.417,7l4.1582-0.0068L9.9098,9H5.0887z M10.25,12&#xA;&#x9;&#x9;c-0.4142,0-0.75-0.3358-0.75-0.75c0-0.4142,0.3358-0.75,0.75-0.75S11,10.8358,11,11.25C11,11.6642,10.6642,12,10.25,12z"/>\n    <path d="M12,2H5.7889C5.4029,1.1177,4.5247,0.5,3.5,0.5S1.5971,1.1177,1.2111,2H3.5L4,3L3.5,4H1.2111&#xA;&#x9;&#x9;C1.5972,4.8821,2.4754,5.5,3.5,5.5S5.4028,4.8821,5.7889,4H12c0.5527,0,1-0.4478,1-1S12.5527,2,12,2z"/>\n  </g>\n</svg>'
  },
  casino: {
    label: 'Casino',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="casino-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M8.5,10c0.4561,0.6072,1.1821,1,2,1c1.3807,0,2.5-1.1193,2.5-2.5c0-0.5642-0.1938-1.0789-0.509-1.4973L12.5,7l-5-6l-5,6&#xA;&#x9;l0.009,0.0027C2.1938,7.4211,2,7.9358,2,8.5C2,9.8807,3.1193,11,4.5,11c0.8179,0,1.5439-0.3928,2-1&#xA;&#x9;C6.5997,9.8672,6.7902,9.6135,7,9.3337V11.5C7,13,4.5,13,4.5,13C4.2239,13,4,13.2238,4,13.5C4,13.7761,4.2239,14,4.5,14H7h1h2.5&#xA;&#x9;c0.2761,0,0.5-0.2239,0.5-0.5c0-0.2762-0.2239-0.5-0.5-0.5c0,0-2.5,0-2.5-1.5V9.3337C8.2098,9.6135,8.4003,9.8672,8.5,10z"/>\n</svg>'
  },
  castle: {
    label: 'Castle',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="castle-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11,4H4C3.4477,4,3,3.5523,3,3V0.5C3,0.2239,3.2239,0,3.5,0S4,0.2239,4,0.5V2h1V1c0-0.5523,0.4477-1,1-1s1,0.4477,1,1v1h1V1&#xA;&#x9;c0-0.5523,0.4477-1,1-1s1,0.4477,1,1v1h1V0.5C11,0.2239,11.2239,0,11.5,0S12,0.2239,12,0.5V3C12,3.5523,11.5523,4,11,4z M14,14.5&#xA;&#x9;c0,0.2761-0.2239,0.5-0.5,0.5h-12C1.2239,15,1,14.7761,1,14.5S1.2239,14,1.5,14H2c0.5523,0,1-0.4477,1-1c0,0,1-6,1-7&#xA;&#x9;c0-0.5523,0.4477-1,1-1h5c0.5523,0,1,0.4477,1,1c0,1,1,7,1,7c0,0.5523,0.4477,1,1,1h0.5c0.2723-0.0001,0.4946,0.2178,0.5,0.49V14.5z&#xA;&#x9; M9,10.5C9,9.6716,8.3284,9,7.5,9S6,9.6716,6,10.5V14h3V10.5z"/>\n</svg>'
  },
  cemetery: {
    label: 'Cemetery',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="cemetery-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11.46,12h-0.68L12,3.55c0.0175-0.2867-0.2008-0.5332-0.4874-0.5507C11.4884,2.9979,11.4641,2.9981,11.44,3h-1.18&#xA;&#x9;c0-0.92-1.23-2-2.75-2S4.77,2.08,4.77,3H3.54C3.253,2.9885,3.0111,3.2117,2.9995,3.4987C2.9988,3.5158,2.999,3.5329,3,3.55L4.2,12&#xA;&#x9;H3.55C3.2609,11.9886,3.0162,12.2112,3,12.5V14h9v-1.51C11.9839,12.2067,11.7435,11.9886,11.46,12z M4.5,5h6v1h-6V5z"/>\n</svg>'
  },
  'charging-station': {
    label: 'Charging station',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="charging-station-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13,4V2.49C12.9946,2.2178,12.7723,1.9999,12.5,2c-0.2816,0.0047-0.5062,0.2367-0.5015,0.5184&#xA;&#x9;C11.9987,2.5289,11.9992,2.5395,12,2.55V5c0,0.5523,0.4477,1,1,1v5.5c0,0.2761-0.2239,0.5-0.5,0.5S12,11.7761,12,11.5v-2&#xA;&#x9;C12,8.6716,11.3284,8,10.5,8H9V2c0-0.5523-0.4477-1-1-1H2C1.4477,1,1,1.4477,1,2v11c0,0.5523,0.4477,1,1,1h6c0.5523,0,1-0.4477,1-1&#xA;&#x9;V9h1.5C10.7761,9,11,9.2239,11,9.5v2c0,0.8284,0.6716,1.5,1.5,1.5c0.8284,0,1.5-0.6716,1.5-1.5V5C14,4.4477,13.5523,4,13,4z&#xA;&#x9; M7.2004,7.3995l-2.6006,3.4674l-0.0164-0.0072C4.5369,10.9384,4.4667,11,4.3688,11c-0.1476,0-0.2672-0.1196-0.2672-0.2672&#xA;&#x9;c0-0.028,0.0217-0.0463,0.0297-0.0717l-0.0177-0.0078l0.7766-2.3245C4.9442,8.1671,4.8238,8,4.6533,8H2.9994&#xA;&#x9;C2.7936,8,2.6762,7.7651,2.7996,7.6005l2.6006-3.4674l0.0164,0.0072C5.4631,4.0616,5.5333,4,5.6312,4&#xA;&#x9;c0.1476,0,0.2672,0.1196,0.2672,0.2672c0,0.028-0.0217,0.0463-0.0297,0.0717l0.0176,0.0078L5.1099,6.6711&#xA;&#x9;C5.0558,6.8329,5.1762,7,5.3467,7h1.6539C7.2064,7,7.3238,7.2349,7.2004,7.3995z"/>\n</svg>'
  },
  cinema: {
    label: 'Cinema',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="cinema-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,7.5v2c0,0.2761-0.2239,0.5-0.5,0.5S13,9.7761,13,9.5c0,0,0.06-0.5-1-0.5h-1v2.5c0,0.2761-0.2239,0.5-0.5,0.5h-8&#xA;&#x9;C2.2239,12,2,11.7761,2,11.5v-4C2,7.2239,2.2239,7,2.5,7h8C10.7761,7,11,7.2239,11,7.5V8h1c1.06,0,1-0.5,1-0.5&#xA;&#x9;C13,7.2239,13.2239,7,13.5,7S14,7.2239,14,7.5z M4,3C2.8954,3,2,3.8954,2,5s0.8954,2,2,2s2-0.8954,2-2S5.1046,3,4,3z M4,6&#xA;&#x9;C3.4477,6,3,5.5523,3,5s0.4477-1,1-1s1,0.4477,1,1S4.5523,6,4,6z M8.5,2C7.1193,2,6,3.1193,6,4.5S7.1193,7,8.5,7S11,5.8807,11,4.5&#xA;&#x9;S9.8807,2,8.5,2z M8.5,6C7.6716,6,7,5.3284,7,4.5S7.6716,3,8.5,3S10,3.6716,10,4.5S9.3284,6,8.5,6z"/>\n</svg>'
  },
  circle: {
    label: 'Circle',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="circle-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,7.5c0,3.5899-2.9101,6.5-6.5,6.5S1,11.0899,1,7.5S3.9101,1,7.5,1S14,3.9101,14,7.5z"/>\n</svg>'
  },
  'circle-stroked': {
    label: 'Circle stroked',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="circle-stroked-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path8564-5-6-4" d="M7.5,0C11.6422,0,15,3.3578,15,7.5S11.6422,15,7.5,15&#xA;&#x9;S0,11.6422,0,7.5S3.3578,0,7.5,0z M7.5,1.6666c-3.2217,0-5.8333,2.6117-5.8333,5.8334S4.2783,13.3334,7.5,13.3334&#xA;&#x9;s5.8333-2.6117,5.8333-5.8334S10.7217,1.6666,7.5,1.6666z"/>\n</svg>'
  },
  city: {
    label: 'City',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15" id="city-15">\n  <path d="M13.6368,3.9994h-1.6387V1.3608C11.99804,1.16148,11.83642,0.99994,11.6371,1l0,0h-0.278&#xA;&#x9;c-0.19932,0-0.3609,0.16158-0.3609,0.3609l0,0v2.6385H9.36c-0.19932,0-0.3609,0.16158-0.3609,0.3609l0,0l0,0v5.6381h-3.637&#xA;&#x9;c-0.20042,0-0.3629,0.16248-0.3629,0.3629v3.2745c0.00055,0.20003,0.16287,0.3619,0.3629,0.3619h8.2747&#xA;&#x9;c0.19932,0,0.3609-0.16158,0.3609-0.3609l0,0V4.36c0-0.19932-0.16158-0.3609-0.3609-0.3609l0,0L13.6368,3.9994z M6.9989,11.9981h-1&#xA;&#x9;v-1h1V11.9981z M8.9989,11.9981h-1v-1h1V11.9981z M10.9989,11.9981h-1v-1h1V11.9981z M10.9989,9.9981h-1v-1h1V9.9981z&#xA;&#x9; M10.9989,7.9981h-1v-1h1V7.9981z M10.9989,5.9981h-1v-1h1V5.9981z M12.9989,11.9971h-1v-1h1V11.9971z M12.9989,9.9971h-1v-1h1&#xA;&#x9;V9.9971z M12.9989,7.9971h-1v-1h1V7.9971z M12.9989,5.9971h-1v-1h1V5.9971z M7.9987,1.3608C7.99864,1.16152,7.83708,1,7.6378,1H5.36&#xA;&#x9;C5.16068,1,4.9991,1.16158,4.9991,1.3609l0,0V3H3.36C3.16138,3.00049,3.00049,3.16138,3,3.36l0,0v0.6394H1.3608&#xA;&#x9;C1.16164,3.99945,1.00017,4.16084,1,4.36l0,0v9.2765c0,0.19932,0.16158,0.3609,0.3609,0.3609h2.6385V8.9986h3.9993V1.3608z&#xA;&#x9; M3,11.9981H2v-1h1V11.9981z M3,9.9981H2v-1h1V9.9981z M3,7.9981H2v-1h1V7.9981z M3,5.9981H2v-1h1V5.9981z M5,7.9981H4v-1h1V7.9981z&#xA;&#x9; M5,5.9981H4v-1h1V5.9981z M7,7.9981H6v-1h1V7.9981z M7,5.9981H6v-1h1V5.9981z M7,3.9981H6V3h1v1V3.9981z"/>\n</svg>'
  },
  'clothing-store': {
    label: 'Clothing store',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="clothing-store-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect4181-0-0" d="&#xA;&#x9;M3.5,1L0,4v3h2.9L3,14h9V7h3V4l-3.5-3H10L7.5,5L5,1H3.5z"/>\n</svg>'
  },
  college: {
    label: 'College',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="college-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M7.5,1L0,4.5l2,0.9v1.7C1.4,7.3,1,7.9,1,8.5s0.4,1.2,1,1.4V10l-0.9,2.1&#xA; C0.8,13,1,14,2.5,14s1.7-1,1.4-1.9L3,10c0.6-0.3,1-0.8,1-1.5S3.6,7.3,3,7.1V5.9L7.5,8L15,4.5L7.5,1z M11.9,7.5l-4.5,2L5,8.4v0.1&#xA; c0,0.7-0.3,1.3-0.8,1.8l0.6,1.4v0.1C4.9,12.2,5,12.6,4.9,13c0.7,0.3,1.5,0.5,2.5,0.5c3.3,0,4.5-2,4.5-3L11.9,7.5L11.9,7.5z"/>\n</svg>'
  },
  commercial: {
    label: 'Commercial',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="commercial-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,7H1c0.0881-1.3829,0.427-2.7383,1-4h11C13.5731,4.2617,13.9119,5.6171,14,7z M3,8h9v6h-1V9H8v5H3V8z M4,11h3V9H4V11z"/>\n</svg>'
  },
  'communications-tower': {
    label: 'Communications tower',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="communications-tower-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <g id="communications-tower-15">\n    <path d="M11.8545,6.4336l-.4131-.2813a4.7623,4.7623,0,0,0,.2813-4.8779l-.0835-.1533L12.0747.875l.0908.167a5.2619,5.2619,0,0,1-.311,5.3916Zm1.1521,7.1316V14h-11v-.4348H4.4952L6.0439,6.4a.5.5,0,0,1,.4888-.3945h.7255V4.6014A1.14,1.14,0,0,1,6.3756,3.5a1.1568,1.1568,0,1,1,2.3136,0,1.14,1.14,0,0,1-.931,1.1112V6.0059h.7223A.5.5,0,0,1,8.9692,6.4l1.5478,7.1648ZM8.4543,8.751H6.5588L6.236,10.2441H8.777ZM6.1279,10.7441l-.3233,1.4952H9.2082l-.3231-1.4952ZM6.936,7.0059,6.6669,8.251H8.3463L8.0771,7.0059ZM5.5179,13.5652H9.4948l-.1786-.8259h-3.62ZM5.21,5.0137a2.7523,2.7523,0,0,1,.0161-3.0518L4.812,1.6826a3.25,3.25,0,0,0-.019,3.6065ZM10.7568,3.5a3.2433,3.2433,0,0,0-.5341-1.7861l-.418.2754a2.7517,2.7517,0,0,1-.0176,3.0488l.4141.2793A3.2341,3.2341,0,0,0,10.7568,3.5ZM3.5342,6.1182A4.7637,4.7637,0,0,1,3.3813,1.13L2.9478.88a5.2643,5.2643,0,0,0,.1694,5.5137Z"/>\n  </g>\n</svg>'
  },
  confectionery: {
    label: 'Confectionery',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="confectionery-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <g id="confectionary-15">\n    <path d="M13,4a1,1,0,0,0-1-1,1,1,0,0,0-2,0V5.0673A3.4808,3.4808,0,0,0,4.3583,9H2a1,1,0,0,0,0,2,1,1,0,0,0,1,1,1,1,0,0,0,2,0V9.9326A3.4807,3.4807,0,0,0,10.6417,6H13a1,1,0,0,0,0-2ZM7.5,9.9925A2.484,2.484,0,0,1,6.3184,5.319a1.0809,1.0809,0,0,1,.5459.307A2.1243,2.1243,0,0,1,7.25,7.0117l.001.9561A2.5821,2.5821,0,0,0,7.76,9.7031a1.5462,1.5462,0,0,0,.2591.2333A2.4861,2.4861,0,0,1,7.5,9.9925ZM8.6815,9.681a1.0813,1.0813,0,0,1-.5458-.307A2.1243,2.1243,0,0,1,7.75,7.9883l-.001-.9561A2.5821,2.5821,0,0,0,7.24,5.2969a1.5557,1.5557,0,0,0-.2592-.2334A2.4843,2.4843,0,0,1,8.6815,9.681Z"/>\n  </g>\n</svg>'
  },
  convenience: {
    label: 'Convenience',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="convenience-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <g id="convenience-store-15">\n    <path d="M2.9982,3.0687s.1875-1.062,1-1.062H5.0043V1.7276a.5.5,0,0,1,.5-.5H9.4882a.5.5,0,0,1,.5.5v.2791h1.01a.8324.8324,0,0,1,.6373.2937,1.7589,1.7589,0,0,1,.3627.7683s.3108,1.5719.5921,2.9181h-.938L11,3,3.982,2.9956,3.3336,5.9868H2.382Zm11,4.9144a1,1,0,0,1-.9992,1l-1.0008,3.973s-.1875,1.0417-1,1.0417h-7c-.8125,0-1-1.0417-1-1.0417L1.9822,8.98a.9985.9985,0,0,1,.016-1.9968h11A1,1,0,0,1,13.9982,7.9831ZM5.0327,12.13,5.03,11.0051,4.6392,9.4686a.5373.5373,0,1,0-1.0649.1445L3.78,11.0075l.1874,1.2672A.5373.5373,0,1,0,5.0327,12.13Zm2-2.5967A.5332.5332,0,0,0,6.4994,9l-.0039.0008L6.4886,9a.4992.4992,0,0,0-.3575.1509.529.529,0,0,0-.1648.3828v2.68a.5332.5332,0,1,0,1.0663,0Zm1.998,0A.5314.5314,0,0,0,8.694,9.04a.4992.4992,0,0,0-.393,0,.5312.5312,0,0,0-.3366.4934v2.68a.5331.5331,0,1,0,1.0662,0Zm2.3857.08a.5373.5373,0,1,0-1.0649-.1445L9.96,10.9938,9.9579,12.13a.5373.5373,0,1,0,1.0649.1446Z"/>\n  </g>\n</svg>'
  },
  cricket: {
    label: 'Cricket',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="cricket-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M8,1.5C8,2.3284,7.3284,3,6.5,3S5,2.3284,5,1.5S5.6716,0,6.5,0S8,0.6716,8,1.5z M10.88,7.18L10.88,7.18l-2-2l0,0l0,0&#xA;&#x9;C8.7815,5.0616,8.6339,4.9952,8.48,5H3.75C3.3736,4.9915,3.0508,5.2669,3,5.64l0,0l-1,7.7l0,0c-0.0068,0.0464-0.0068,0.0936,0,0.14&#xA;&#x9;c0,0.2761,0.2239,0.5,0.5,0.5c0.2251,0.0153,0.4315-0.1251,0.5-0.34l0,0l1.2-3.89l0,0l0.26-0.83l0.4,0.44l0,0L6,10.6v2.9&#xA;&#x9;C6,13.7761,6.2239,14,6.5,14S7,13.7761,7,13.5v-3l0,0l0,0c-0.0081-0.0788-0.0356-0.1544-0.08-0.22l0,0L5.48,8.5l1-2.5h1.71l2,1.84&#xA;&#x9;l0,0c0.0928,0.1077,0.2278,0.1697,0.37,0.17C10.8163,7.9791,11.007,7.7581,11,7.5C10.9997,7.3824,10.9571,7.2688,10.88,7.18z&#xA;&#x9; M14,11.27c-0.4142,0-0.75,0.3358-0.75,0.75s0.3358,0.75,0.75,0.75s0.75-0.3358,0.75-0.75S14.4142,11.27,14,11.27z M10.76,9.74V9&#xA;&#x9;c0-0.1381-0.1119-0.25-0.25-0.25S10.26,8.8619,10.26,9v0.74c-0.1522,0.0855-0.2474,0.2455-0.25,0.42v3.34&#xA;&#x9;c0,0.2761,0.2239,0.5,0.5,0.5s0.5-0.2239,0.5-0.5v-3.34C11.0074,9.9855,10.9122,9.8255,10.76,9.74z"/>\n</svg>'
  },
  cross: {
    label: 'Cross',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="cross-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M2.64,1.27L7.5,6.13l4.84-4.84C12.5114,1.1076,12.7497,1.0029,13,1c0.5523,0,1,0.4477,1,1&#xA;&#x9;c0.0047,0.2478-0.093,0.4866-0.27,0.66L8.84,7.5l4.89,4.89c0.1648,0.1612,0.2615,0.3796,0.27,0.61c0,0.5523-0.4477,1-1,1&#xA;&#x9;c-0.2577,0.0107-0.508-0.0873-0.69-0.27L7.5,8.87l-4.85,4.85C2.4793,13.8963,2.2453,13.9971,2,14c-0.5523,0-1-0.4477-1-1&#xA;&#x9;c-0.0047-0.2478,0.093-0.4866,0.27-0.66L6.16,7.5L1.27,2.61C1.1052,2.4488,1.0085,2.2304,1,2c0-0.5523,0.4477-1,1-1&#xA;&#x9;C2.2404,1.0029,2.4701,1.0998,2.64,1.27z"/>\n</svg>'
  },
  dam: {
    label: 'Dam',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="dam-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.94,9.5c0,0.2761-0.2239,0.5-0.5,0.5l0,0c-0.259,0.0219-0.4994,0.1439-0.67,0.34c-0.2714,0.2887-0.6175,0.4964-1,0.6&#xA;&#x9;c-0.6115,0.1816-1.2734,0.0424-1.76-0.37l-0.39-0.35c-0.2976-0.3038-0.7851-0.3087-1.0889-0.0111&#xA;&#x9;C8.5274,10.2126,8.5237,10.2163,8.52,10.22c-0.14,0.12-0.27,0.25-0.42,0.37c-0.7278,0.5784-1.7663,0.5489-2.46-0.07L5.3,10.19&#xA;&#x9;l-0.1-0.06l0.3,1.22l0.49,2c0.0829,0.2634-0.0634,0.5441-0.3267,0.6271C5.6105,13.9937,5.5553,14.0014,5.5,14h-4&#xA;&#x9;C1.2239,14,1,13.7761,1,13.5v-12C1,1.2239,1.2239,1,1.5,1h1.1c0.2346-0.0011,0.4384,0.1611,0.49,0.39L4,5.06V5.2&#xA;&#x9;c0.6569-0.314,1.4361-0.2205,2,0.24c0.16,0.13,0.31,0.28,0.47,0.41c0.2847,0.2546,0.7153,0.2546,1,0c0.16-0.13,0.31-0.28,0.47-0.41&#xA;&#x9;c0.7076-0.5968,1.7424-0.5968,2.45,0c0.15,0.13,0.29,0.27,0.44,0.39c0.2847,0.2546,0.7153,0.2546,1,0l0.47-0.41&#xA;&#x9;c0.3163-0.2672,0.7159-0.4157,1.13-0.42l0,0c0.2761,0,0.5,0.2239,0.5,0.5S13.7061,6,13.43,6l0,0&#xA;&#x9;c-0.259,0.0219-0.4994,0.1439-0.67,0.34c-0.2714,0.2887-0.6175,0.4964-1,0.6C11.1485,7.1216,10.4866,6.9824,10,6.57L9.67,6.23&#xA;&#x9;C9.3724,5.9262,8.8849,5.9213,8.5811,6.2189C8.5774,6.2226,8.5737,6.2263,8.57,6.23C8.43,6.35,8.3,6.48,8.15,6.6&#xA;&#x9;C7.4222,7.1784,6.3837,7.1489,5.69,6.53L5.3,6.19c-0.2847-0.2546-0.7153-0.2546-1,0L4.24,6.24L4.93,9&#xA;&#x9;C5.3226,9.029,5.6965,9.1793,6,9.43c0.16,0.13,0.31,0.28,0.47,0.41c0.2847,0.2546,0.7153,0.2546,1,0c0.16-0.13,0.31-0.28,0.47-0.41&#xA;&#x9;c0.7076-0.5968,1.7424-0.5968,2.45,0c0.15,0.13,0.29,0.27,0.44,0.39c0.2847,0.2546,0.7153,0.2546,1,0l0.47-0.41&#xA;&#x9;c0.3177-0.2636,0.7172-0.4085,1.13-0.41l0,0c0.2761-0.0055,0.5044,0.2138,0.5099,0.4899C13.94,9.4933,13.94,9.4966,13.94,9.5z"/>\n</svg>'
  },
  danger: {
    label: 'Danger',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="danger-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.94,14.68c-0.0749,0.194-0.262,0.3215-0.47,0.32c-0.0595,0.0107-0.1205,0.0107-0.18,0L7.5,12.56L1.7,15&#xA;&#x9;c-0.2572,0.1005-0.5472-0.0266-0.6476-0.2838C1.0516,14.7141,1.0508,14.7121,1.05,14.71c-0.1291-0.2441-0.0358-0.5467,0.2084-0.6757&#xA;&#x9;C1.2845,14.0205,1.3118,14.009,1.34,14l4.85-2l-4.85-2C1.0758,9.9197,0.9267,9.6404,1.007,9.3762s0.3596-0.4133,0.6238-0.333&#xA;&#x9;C1.6545,9.0504,1.6776,9.0594,1.7,9.07l5.8,2.41l5.8-2.41c0.2494-0.1185,0.5477-0.0124,0.6662,0.237&#xA;&#x9;c0.1185,0.2494,0.0124,0.5477-0.237,0.6662C13.7068,9.9839,13.6837,9.9928,13.66,10L8.8,12l4.85,2&#xA;&#x9;c0.2607,0.091,0.3983,0.3761,0.3074,0.6368C13.9523,14.6515,13.9465,14.6659,13.94,14.68z M12,4.23v0.45&#xA;&#x9;c-0.0021,0.2129-0.0722,0.4196-0.2,0.59C11.2414,5.8883,10.6399,6.4664,10,7v1.16c0.0015,0.208-0.126,0.3951-0.32,0.47L7.52,9.5&#xA;&#x9;H7.45L5.28,8.63C5.1016,8.5428,4.9917,8.3584,5,8.16V7C4.3528,6.4675,3.7446,5.8893,3.18,5.27C3.0593,5.0972,2.9963,4.8907,3,4.68&#xA;&#x9;V4.23C3.1669,2.0117,4.8974,0.2307,7.11,0h0.36l0,0h0.39C10.0862,0.2131,11.8348,1.9997,12,4.23z M6,4c0-0.5523-0.4477-1-1-1&#xA;&#x9;S4,3.4477,4,4s0.4477,1,1,1S6,4.5523,6,4z M7,7c0-0.2761-0.2239-0.5-0.5-0.5S6,6.7239,6,7v0.5C6,7.7761,6.2239,8,6.5,8&#xA;&#x9;S7,7.7761,7,7.5V7z M9,7c0-0.2761-0.2239-0.5-0.5-0.5S8,6.7239,8,7v0.5C8,7.7761,8.2239,8,8.5,8S9,7.7761,9,7.5V7z M11,4&#xA;&#x9;c0-0.5523-0.4477-1-1-1S9,3.4477,9,4s0.4477,1,1,1S11,4.5523,11,4z"/>\n</svg>'
  },
  defibrillator: {
    label: 'Defibrillator',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" id="defibrillator-15">\n  <path d="M1.55,6.3381C-0.8368,1.7416,5.18-1.3228,7.502,3.2737c2.3215-4.5965,8.3387-1.5322,5.9523,3.0644-0.0869.1671-.2028,0.3456-0.3114,0.5212H11.335L9.5205,4.1377A0.6252,0.6252,0,0,0,8.42,4.2524l-1.6484,4.12-1.33-1.33A0.6254,0.6254,0,0,0,5,6.8594H1.8611C1.7525,6.6837,1.6366,6.5052,1.55,6.3381ZM11,8.1094a0.6263,0.6263,0,0,1-.5205-0.2783L9.1387,5.82,7.58,9.7168a0.6245,0.6245,0,0,1-.4546.38A0.6047,0.6047,0,0,1,7,10.1094a0.6251,0.6251,0,0,1-.4419-0.1826L4.7412,8.1094H2.7358a42.67,42.67,0,0,0,4.46,4.6732,0.4642,0.4642,0,0,0,.6222,0,43.26,43.26,0,0,0,4.4505-4.6732H11Z"/>\n</svg>'
  },
  dentist: {
    label: 'Dentist',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="dentist-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M4.36,14c-1,0-0.56-2.67-0.86-5c-0.1-0.76-1-1.49-1.12-2.06C2,5,1.39,1.44,3.66,1S6,3,7.54,3s1.57-2.36,3.85-2&#xA;&#x9;s1.59,3.9,1.29,5.9c-0.1,0.45-1.1,1.48-1.18,2.06c-0.33,2.4,0.32,5-0.8,5c-0.93,0-1.32-2.72-2-4.5C8.43,8.63,8.06,8,7.54,8&#xA;&#x9;C6,8,5.75,14,4.36,14z"/>\n</svg>'
  },
  doctor: {
    label: 'Doctor',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="doctor-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M5.5,7C4.1193,7,3,5.8807,3,4.5l0,0v-2C3,2.2239,3.2239,2,3.5,2H4c0.2761,0,0.5-0.2239,0.5-0.5S4.2761,1,4,1H3.5&#xA;&#x9;C2.6716,1,2,1.6716,2,2.5v2c0.0013,1.1466,0.5658,2.2195,1.51,2.87l0,0C4.4131,8.1662,4.9514,9.297,5,10.5C5,12.433,6.567,14,8.5,14&#xA;&#x9;s3.5-1.567,3.5-3.5V9.93c1.0695-0.2761,1.7126-1.367,1.4365-2.4365C13.1603,6.424,12.0695,5.7809,11,6.057&#xA;&#x9;C9.9305,6.3332,9.2874,7.424,9.5635,8.4935C9.7454,9.198,10.2955,9.7481,11,9.93v0.57c0,1.3807-1.1193,2.5-2.5,2.5S6,11.8807,6,10.5&#xA;&#x9;c0.0511-1.2045,0.5932-2.3356,1.5-3.13l0,0C8.4404,6.7172,9.001,5.6448,9,4.5v-2C9,1.6716,8.3284,1,7.5,1H7&#xA;&#x9;C6.7239,1,6.5,1.2239,6.5,1.5S6.7239,2,7,2h0.5C7.7761,2,8,2.2239,8,2.5v2l0,0C8,5.8807,6.8807,7,5.5,7 M11.5,9&#xA;&#x9;c-0.5523,0-1-0.4477-1-1s0.4477-1,1-1s1,0.4477,1,1S12.0523,9,11.5,9z"/>\n</svg>'
  },
  'dog-park': {
    label: 'Dog park',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" version="1.1" id="dog-park-15" width="15px" height="15px" viewBox="0 0 15 15">\n  <g id="g3">\n    <path d="M 10.300781 1.2207031 C 9.9144812 1.2207031 9.6 1.2 9.5 2 L 9.0996094 4.5214844 L 11.5 6.5 L 13.5 6.5 C 14.9 6.5 15 5.5410156 15 5.5410156 L 13.099609 3.3222656 C 12.399609 2.6222656 11.7 2.5 11 2.5 L 11 2 C 11 2 11.067481 1.2206031 10.300781 1.2207031 z M 4.75 1.5 C 4.75 1.5 3.7992187 1.5206031 3.1992188 1.7207031 C 2.5992187 1.9207031 2 2.6210938 2 3.6210938 L 2 7.5214844 C 2 9.2214844 1.3 9.5 1 9.5 C 1 9.5 0 9.5214844 0 10.521484 L 0 12.720703 C 0 12.720703 0.00078125 13.521484 0.80078125 13.521484 L 1 13.521484 L 1.5 13.521484 L 2 13.521484 L 2 13.021484 L 2 12.822266 C 2 12.422266 1.8 12.221094 1.5 12.121094 L 1.5 11.021484 C 2.5 11.021484 2.6 10.820703 3 10.720703 L 3.5507812 12.917969 C 3.6507813 13.217969 3.7507813 13.417578 4.0507812 13.517578 L 5.0507812 13.517578 L 6 13.5 L 6 12.699219 C 6 12.022819 5 12 5 12 L 5 9.5 L 8.5 9.5 L 9.1992188 12.121094 C 9.5992188 13.521094 10.5 13.5 10.5 13.5 L 11 13.5 L 12 13.5 L 12 12.699219 C 12 11.987419 11 12 11 12 L 11.099609 7.921875 L 8 5.5 L 3.5 5.5 L 3.5 3.5 C 3.5 3.1 3.7765 3.0053 4 3 C 4.4941 2.9882 4.75 3 4.75 3 C 5.1642 3 5.5 2.6642 5.5 2.25 C 5.5 1.8358 5.1642 1.5 4.75 1.5 z M 11.75 4 C 11.8881 4 12 4.1119 12 4.25 C 12 4.3881 11.8881 4.5 11.75 4.5 C 11.6119 4.5 11.5 4.3881 11.5 4.25 C 11.5 4.1119 11.6119 4 11.75 4 z " id="path5"/>\n  </g>\n</svg>'
  },
  'drinking-water': {
    label: 'Drinking water',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" id="drinking-water-15">\n  <path d="M6,1A2,2,0,0,0,4,3V6.5a0.5,0.5,0,0,0,.5.5h2A0.5,0.5,0,0,0,7,6.5v-2A0.5,0.5,0,0,1,7.5,4H14V1H6Z"/>\n  <path d="M7,15H4a0.5,0.5,0,0,1-.48-0.38L2,8.62A0.5,0.5,0,0,1,2.5,8h6A0.5,0.5,0,0,1,9,8.62l-1.5,6A0.5,0.5,0,0,1,7,15ZM3.65,11l3.71,0L7.86,9H3.14Z"/>\n</svg>'
  },
  embassy: {
    label: 'Embassy',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="embassy-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M6.65,2C5.43,2,4.48,3.38,4.11,3.82C4.0365,3.9102,3.9975,4.0237,4,4.14v4.4C3.9884,8.7827,4.1758,8.9889,4.4185,9.0005&#xA;&#x9;C4.528,9.0057,4.6355,8.9699,4.72,8.9c0.4665-0.6264,1.1589-1.0461,1.93-1.17C8.06,7.73,8.6,9,10.07,9&#xA;&#x9;c0.9948-0.0976,1.9415-0.4756,2.73-1.09c0.1272-0.0934,0.2016-0.2422,0.2-0.4V2.45c0.0275-0.2414-0.1459-0.4595-0.3874-0.487&#xA;&#x9;C12.5332,1.954,12.4527,1.9668,12.38,2c-0.6813,0.5212-1.4706,0.8834-2.31,1.06C8.6,3.08,8.12,2,6.65,2z M2.5,3&#xA;&#x9;c-0.5523,0-1-0.4477-1-1s0.4477-1,1-1s1,0.4477,1,1S3.0523,3,2.5,3z M3,4v9.48c0,0.2761-0.2239,0.5-0.5,0.5S2,13.7561,2,13.48V4&#xA;&#x9;c0-0.2761,0.2239-0.5,0.5-0.5S3,3.7239,3,4z"/>\n</svg>'
  },
  'emergency-phone': {
    label: 'Emergency phone',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="emergency-phone-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M7.875,11.49a.51.51,0,0,0,.72,0l.72-.72,2.18,2.16-.37.37a2.24,2.24,0,0,1-1.44.7H8.24a2.24,2.24,0,0,1-1.45-.7L1.72,8.23A2.24,2.24,0,0,1,1,6.78V5.33a2.24,2.24,0,0,1,.72-1.45l.36-.36L4.26,5.69l-.73.73a.51.51,0,0,0,0,.72Zm4.72.38a1,1,0,0,0,.036-1.414h0l-.036-.036-.72-.72a1,1,0,0,0-1.414-.036h0l-.036.036ZM5.315,4.62a1,1,0,0,0,.036-1.414h0L4.595,2.45a1,1,0,0,0-1.414-.036h0L3.14,2.45ZM10,2V4H8V5h2V7h1V5h2V4H11V2Z"/>\n</svg>'
  },
  entrance: {
    label: 'Entrance',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="entrance-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M7,6.5v-1c0-0.5523-0.4477-1-1-1s-1,0.4477-1,1v3L7,6.5z M4.65,10.56L5,3c0-0.5523,0.4477-1,1-1s1,0.4477,1,1S6.5523,4,6,4&#xA;&#x9;S5,3.5523,5,3L4.65,10.56z"/>\n  <path d="M14,6L14,6c0,0.5523-0.4477,1-1,1h-1.58c-0.2658-0.0015-0.5213,0.1028-0.71,0.29l-5.42,5.42&#xA;&#x9;c-0.1863,0.1847-0.4377,0.2889-0.7,0.29H2c-0.5523,0-1-0.4477-1-1l0,0c0-0.5523,0.4477-1,1-1h1.59&#xA;&#x9;c0.2623-0.0011,0.5137-0.1053,0.7-0.29l5.42-5.42C9.8987,5.1028,10.1542,4.9985,10.42,5H13C13.5523,5,14,5.4477,14,6z"/>\n</svg>'
  },
  'entrance-alt1': {
    label: 'Entrance 2',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="entrance-alt1-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M6.554,9.639a.5.5,0,0,0,.707.707L9.928,7.669a.25.25,0,0,0,0-.354h0L7.261,4.639a.5.5,0,0,0-.707.707L8.2,7H1.5a.5.5,0,0,0,0,1H8.2ZM12,1H5.5a.5.5,0,0,0,0,1h6a.5.5,0,0,1,.5.5v10a.5.5,0,0,1-.5.5H5.25a.5.5,0,0,0,0,1H12a1,1,0,0,0,1-1V2A1,1,0,0,0,12,1Z"/>\n</svg>'
  },
  farm: {
    label: 'Farm',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="farm-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M8,7L5,5,2,7,1,9v4H3V11H7v2H9V9ZM6,9H4V7H6V9Zm8,4H11V3.5a1.5,1.5,0,0,1,3,0V13Z"/>\n</svg>'
  },
  'fast-food': {
    label: 'Fast food',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="fast-food-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,8c0,0.5523-0.4477,1-1,1H2C1.4477,9,1,8.5523,1,8s0.4477-1,1-1h11C13.5523,7,14,7.4477,14,8z M3.5,10H2&#xA;&#x9;c0,1.6569,1.3431,3,3,3h5c1.6569,0,3-1.3431,3-3H3.5z M3,6H2V4c0-1.1046,0.8954-2,2-2h7c1.1046,0,2,0.8954,2,2v2H3z M11,4.5&#xA;&#x9;C11,4.7761,11.2239,5,11.5,5S12,4.7761,12,4.5S11.7761,4,11.5,4S11,4.2239,11,4.5z M9,3.5C9,3.7761,9.2239,4,9.5,4S10,3.7761,10,3.5&#xA;&#x9;S9.7761,3,9.5,3S9,3.2239,9,3.5z M7,4.5C7,4.7761,7.2239,5,7.5,5S8,4.7761,8,4.5S7.7761,4,7.5,4S7,4.2239,7,4.5z M5,3.5&#xA;&#x9;C5,3.7761,5.2239,4,5.5,4S6,3.7761,6,3.5S5.7761,3,5.5,3S5,3.2239,5,3.5z M3,4.5C3,4.7761,3.2239,5,3.5,5S4,4.7761,4,4.5&#xA;&#x9;S3.7761,4,3.5,4S3,4.2239,3,4.5z"/>\n</svg>'
  },
  fence: {
    label: 'Fence',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="fence-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M13.5,10H13V7h.5a.5.5,0,0,0,0-1H13V4l-.286-.573a.249.249,0,0,0-.424-.006L12,4V6H11V4l-.286-.573a.249.249,0,0,0-.424-.006L10,4V6H9V4l-.286-.573a.249.249,0,0,0-.424-.006L8,4V6H7V4l-.286-.573a.249.249,0,0,0-.424-.006L6,4V6H5V4l-.286-.573a.249.249,0,0,0-.424-.006L4,4V6H3V4l-.286-.573a.249.249,0,0,0-.424-.006L2,4V6H1.5a.5.5,0,0,0,0,1H2v3H1.5a.5.5,0,0,0,0,1H2v1.5a.5.5,0,0,0,1,0V11H4v1.5a.5.5,0,0,0,1,0V11H6v1.5a.5.5,0,0,0,1,0V11H8v1.5a.5.5,0,0,0,1,0V11h1v1.5a.5.5,0,0,0,1,0V11h1v1.5a.5.5,0,0,0,1,0V11h.5a.5.5,0,0,0,0-1ZM3,10V7H4v3Zm2,0V7H6v3Zm2,0V7H8v3Zm2,0V7h1v3Zm2,0V7h1v3Z"/>\n</svg>'
  },
  ferry: {
    label: 'Ferry',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="ferry-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M5.33,11c0.6745,0.009,1.3262,0.245,1.85,0.67l0.26,0.23h0.05l0.31-0.28c0.9817-0.8115,2.379-0.8846,3.44-0.18L13.5,7L12,6&#xA;&#x9;V2.45c-0.0466-0.8-0.6989-1.4305-1.5-1.45H10c0.0343-0.518-0.3579-0.9657-0.8759-1C9.0828-0.0027,9.0413-0.0027,9,0H6&#xA;&#x9;C5.482-0.0343,5.0343,0.3579,5,0.8759C4.9973,0.9172,4.9973,0.9587,5,1H4.5C3.6989,1.0195,3.0466,1.65,3,2.45V6L1.5,7l2.25,4.53&#xA;&#x9;C4.2143,11.2041,4.7631,11.02,5.33,11z M4,2.45c0.0105-0.2594,0.2293-0.4611,0.4886-0.4506C4.4924,1.9996,4.4962,1.9998,4.5,2h6&#xA;&#x9;c0.259-0.0171,0.4829,0.1789,0.5,0.4379c0.0014,0.0207,0.0014,0.0414,0,0.0621v3l-3.5-2L4,5.45C4,5.45,4,2.45,4,2.45z M14,13v1&#xA;&#x9;c-0.2626,0.0194-0.5069,0.1416-0.68,0.34c-0.2717,0.2883-0.6178,0.4959-1,0.6c-0.6147,0.1815-1.2795,0.0425-1.77-0.37l-0.39-0.35&#xA;&#x9;c-0.3043-0.3026-0.7957-0.3026-1.1,0c-0.14,0.12-0.27,0.25-0.42,0.37c-0.7328,0.5856-1.7814,0.556-2.48-0.07l-0.39-0.35&#xA;&#x9;c-0.2864-0.2502-0.7136-0.2502-1,0c-0.19,0.15-0.36,0.32-0.55,0.47c-0.7043,0.5215-1.6732,0.4968-2.35-0.06l-0.31-0.27&#xA;&#x9;C1.4153,14.1443,1.2172,14.0346,1,14v-1c0.2585-0.032,0.5205,0.0169,0.75,0.14c0.2782,0.1722,0.5424,0.3661,0.79,0.58&#xA;&#x9;c0.2051,0.2235,0.5147,0.319,0.81,0.25c0.1125-0.0333,0.2177-0.0876,0.31-0.16c0.16-0.12,0.29-0.26,0.45-0.39&#xA;&#x9;c0.7106-0.5888,1.7394-0.5888,2.45,0c0.16,0.13,0.31,0.28,0.47,0.41c0.2864,0.2502,0.7136,0.2502,1,0c0.16-0.13,0.31-0.28,0.47-0.41&#xA;&#x9;c0.7123-0.5943,1.7477-0.5943,2.46,0c0.15,0.13,0.29,0.27,0.44,0.39c0.2864,0.2502,0.7136,0.2502,1,0l0.47-0.41&#xA;&#x9;C13.1895,13.1408,13.5886,12.9995,14,13z"/>\n</svg>'
  },
  'fire-station': {
    label: 'Fire station',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="fire-station-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path10041-3-3" d="M7.5,0.5L5,4.5l-1.5-2&#xA;&#x9;C2.9452,3.4753,0.8036,5.7924,0.8036,8.3036C0.8036,12.002,3.8017,15,7.5,15s6.6964-2.998,6.6964-6.6964&#xA;&#x9;c0-2.5112-2.1416-4.8283-2.6964-5.8036l-1.5,2L7.5,0.5z M7.5,7c0,0,2.5,2.5618,2.5,4.5c0,0.8371-0.8259,2-2.5,2S5,12.3371,5,11.5&#xA;&#x9;C5,9.6283,7.5,7,7.5,7z"/>\n</svg>'
  },
  'fitness-centre': {
    label: 'Fitness centre',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="fitness-centre-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="daec40ff-71f5-4432-9d75-dcba7b9c1b89" d="M14.5,7V8h-1v2h-1v1H11V8H4v3H2.5V10h-1V8H.5V7h1V5h1V4H4V7h7V4h1.5V5h1V7Z"/>\n</svg>'
  },
  florist: {
    label: 'Florist',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="florist-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M1.5,1A2.7,2.7,0,0,1,4,3l.5-3L5,3A2.7,2.7,0,0,1,7.5,1c-.2.03-1,.26-1,2v.083A1.959,1.959,0,0,1,4.5,5H4.417A1.959,1.959,0,0,1,2.5,3C2.5,1.261,1.7,1.03,1.5,1ZM12.012,11l3-.5-3-.5A2.686,2.686,0,0,0,14,7.5c-.03.2-.248,1-1.988,1a2,2,0,0,0,0,4c1.739,0,1.958.8,1.988,1A2.686,2.686,0,0,0,12.012,11ZM9.688,5.548a1,1,0,0,1,0-2,1,1,0,0,1,0-2,.986.986,0,0,1,.852.507l.023-.012a.978.978,0,0,1-.116-.444,1,1,0,1,1,2,0,.978.978,0,0,1-.116.444l.019.01a.986.986,0,0,1,.85-.5,1,1,0,0,1,.025,2,1,1,0,0,1-.025,2,.986.986,0,0,1-.85-.5l-.016.009a.978.978,0,0,1,.113.44,1,1,0,0,1-2,0,.978.978,0,0,1,.113-.44l-.02-.011a.986.986,0,0,1-.852.507Zm.71-1.995A1.051,1.051,0,1,0,11.449,2.5,1.051,1.051,0,0,0,10.4,3.553v0ZM4.946,11.444l-.516-.515L8.892,6.475A1.746,1.746,0,0,1,8.44,6.22L4.076,10.575l-.519-.518A16.051,16.051,0,0,0,4.912,6a3.373,3.373,0,0,1-.412.035c-.041,0-.073-.008-.112-.01A16.953,16.953,0,0,1,3.131,9.631L2.76,9.26a.246.246,0,0,0-.4.079L.231,14.445a.287.287,0,0,0-.016.089.25.25,0,0,0,.25.25.289.289,0,0,0,.1-.019l5.1-2.124a.246.246,0,0,0,.079-.4l-.372-.372a16.874,16.874,0,0,1,3.612-1.256c0-.059-.015-.106-.015-.166A3.349,3.349,0,0,1,9,10.089,16.076,16.076,0,0,0,4.946,11.444Z"/>\n</svg>'
  },
  fuel: {
    label: 'Fuel',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="fuel-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13,6L13,6v5.5c0,0.2761-0.2239,0.5-0.5,0.5S12,11.7761,12,11.5v-2C12,8.6716,11.3284,8,10.5,8H9V2c0-0.5523-0.4477-1-1-1H2&#xA;&#x9;C1.4477,1,1,1.4477,1,2v11c0,0.5523,0.4477,1,1,1h6c0.5523,0,1-0.4477,1-1V9h1.5C10.7761,9,11,9.2239,11,9.5v2&#xA;&#x9;c0,0.8284,0.6716,1.5,1.5,1.5s1.5-0.6716,1.5-1.5V5c0-0.5523-0.4477-1-1-1l0,0V2.49C12.9946,2.2178,12.7723,1.9999,12.5,2&#xA;&#x9;c-0.2816,0.0047-0.5062,0.2367-0.5015,0.5184C11.9987,2.5289,11.9992,2.5395,12,2.55V5C12,5.5523,12.4477,6,13,6s1-0.4477,1-1&#xA;&#x9;s-0.4477-1-1-1 M8,6.5C8,6.7761,7.7761,7,7.5,7h-5C2.2239,7,2,6.7761,2,6.5v-3C2,3.2239,2.2239,3,2.5,3h5C7.7761,3,8,3.2239,8,3.5&#xA;&#x9;V6.5z"/>\n</svg>'
  },
  furniture: {
    label: 'Furniture',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="furniture-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <g>\n    <path d="M9,10.1419V8.5013C9,8.2244,8.7756,8,8.4987,8H7.5013C7.2244,8,7,8.2244,7,8.5013v1.6406&#xA;&#x9;&#x9;c-1.538,0.3984-2.7227,1.6744-2.9573,3.2719C3.9976,13.7202,4.2291,14,4.5389,14h6.9222c0.3098,0,0.5413-0.2798,0.4962-0.5862&#xA;&#x9;&#x9;C11.7227,11.8163,10.538,10.5403,9,10.1419z"/>\n    <path d="M13.6394,6.2788l-2.5016-5.0034C11.0533,1.1066,10.8808,1,10.692,1H5.308C5.1192,1,4.9467,1.1066,4.8622,1.2755&#xA;&#x9;&#x9;L2.3606,6.2788C2.1949,6.6102,2.4359,7,2.8063,7H11v1.5C11,8.7761,11.2239,9,11.5,9S12,8.7761,12,8.5V7h1.1937&#xA;&#x9;&#x9;C13.5641,7,13.8051,6.6102,13.6394,6.2788z"/>\n  </g>\n</svg>'
  },
  gaming: {
    label: 'Gaming',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="gaming-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.1,12.5c-0.6,0.3-1.4,0.1-1.8-0.5l-1.1-1.4H4.8L3.7,12l0,0c-0.5,0.7-1.4,0.8-2.1,0.3c-0.5-0.4-0.7-1-0.6-1.5l0.7-3.7l0,0&#xA;&#x9;C1.9,5.9,3,5,4.2,5v0H7V3.5C7,2.7,7.6,2,8.4,2h3.1C11.8,2,12,2.2,12,2.5S11.8,3,11.5,3h-3C8.2,3,8,3.2,8,3.4c0,0,0,0.1,0,0.1V5h2.8&#xA;&#x9;v0c1.2,0,2.3,0.9,2.5,2.1l0,0l0.7,3.7l0,0C14.1,11.5,13.8,12.2,13.1,12.5z M6,7.5C6,6.7,5.3,6,4.5,6S3,6.7,3,7.5S3.7,9,4.5,9&#xA;&#x9;S6,8.3,6,7.5z M12,7.5C12,7.2,11.8,7,11.5,7H11V6.5C11,6.2,10.8,6,10.5,6S10,6.2,10,6.5V7H9.5C9.2,7,9,7.2,9,7.5S9.2,8,9.5,8H10v0.5&#xA;&#x9;C10,8.8,10.2,9,10.5,9S11,8.8,11,8.5V8h0.5C11.8,8,12,7.8,12,7.5z"/>\n</svg>'
  },
  garden: {
    label: 'Garden',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="garden-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13,8c0,3.31-2.19,6-5.5,6S2,11.31,2,8c2.2643,0.0191,4.2694,1.4667,5,3.61V7H4.5C3.6716,7,3,6.3284,3,5.5v-3&#xA;&#x9;C3,2.2239,3.2239,2,3.5,2c0.1574,0,0.3056,0.0741,0.4,0.2l1.53,2l1.65-3c0.1498-0.232,0.4593-0.2985,0.6913-0.1487&#xA;&#x9;C7.8308,1.0898,7.8815,1.1404,7.92,1.2l1.65,3l1.53-2c0.1657-0.2209,0.4791-0.2657,0.7-0.1C11.9259,2.1944,12,2.3426,12,2.5v3&#xA;&#x9;C12,6.3284,11.3284,7,10.5,7H8v4.61C8.7306,9.4667,10.7357,8.0191,13,8z"/>\n</svg>'
  },
  'garden-centre': {
    label: 'Garden centre',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg width="15px" height="15px" viewBox="0 0 15 15" version="1.1" xmlns="http://www.w3.org/2000/svg" id="garden-centre-15">\n  <path d="M4,5L4,4.5C4,3.12 5.12,2 6.5,2C7.88,2 9,3.12 9,4.5L9,10.293L11.365,7.928L11.018,6.633C11.018,6.631 11.017,6.629 11.017,6.627L11.016,6.627L11.016,6.627C10.973,6.461 11.016,6.276 11.147,6.146C11.342,5.951 11.659,5.951 11.854,6.146L13.854,8.146C14.049,8.341 14.049,8.658 13.854,8.853C13.724,8.983 13.541,9.027 13.375,8.984C13.375,8.984 13.375,8.984 13.375,8.984C13.372,8.983 13.369,8.982 13.365,8.981L12.072,8.635L9,11.707L9,12C9,12.552 8.552,13 8,13L5,13C4.448,13 4,12.552 4,12L4,11.536L1.732,9.268C0.757,8.292 0.757,6.708 1.732,5.732C2.22,5.244 2.86,5 3.5,5L3.5,5L4,5ZM4,6L3.5,6L3.5,6C3.116,6 2.732,6.147 2.439,6.439C1.854,7.025 1.854,7.975 2.439,8.561L4,10.121L4,6ZM8,5L8,4.5C8,3.672 7.328,3 6.5,3C5.672,3 5,3.672 5,4.5L5,5L8,5Z"/>\n</svg>'
  },
  gift: {
    label: 'Gift',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="gift-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M6.5,5v2H0V5H6.5z M8.5,5v2H15V5H8.5z M1,8v4.5C1,13.3284,1.6716,14,2.5,14h4V8H1z M8.5,8v6h4c0.8284,0,1.5-0.6716,1.5-1.5&#xA;&#x9;V8H8.5z M10.5,0c-1.4033-0.0444-2.6497,0.8904-3,2.25C7.1497,0.8904,5.9033-0.0444,4.5,0c-1.0709-0.0337-1.9663,0.8072-2,1.8781&#xA;&#x9;C2.4987,1.9187,2.4987,1.9594,2.5,2C2.3443,2.9427,2.9822,3.8331,3.9249,3.9888C4.0853,4.0153,4.2486,4.0191,4.41,4h6.13&#xA;&#x9;c0.9548,0.1497,1.8503-0.5029,2-1.4577c0.0282-0.1797,0.0282-0.3626,0-0.5423c0.0002-1.1046-0.895-2.0002-1.9996-2.0004&#xA;&#x9;C10.5269-0.0004,10.5135-0.0003,10.5,0z M4.5,3c-0.506,0.0463-0.9537-0.3264-1-0.8323C3.4949,2.1119,3.4949,2.0558,3.5,2&#xA;&#x9;C3.4537,1.494,3.8264,1.0463,4.3323,1C4.3881,0.9949,4.4442,0.9949,4.5,1c1.1046,0,2,0.8954,2,2H4.5z M10.5,3h-2&#xA;&#x9;c0-1.1046,0.8954-2,2-2c0.5523,0,1,0.4477,1,1c0.0463,0.506-0.3264,0.9537-0.8323,1C10.6119,3.0051,10.5558,3.0051,10.5,3z"/>\n</svg>'
  },
  globe: {
    label: 'Globe',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="globe-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <g>\n    <g>\n      <path d="M11.9807,9.4807l-0.7208-0.7208C10.3425,9.8168,9.006,10.5,7.5,10.5c-2.757,0-5-2.243-5-5&#xA;&#x9;&#x9;&#x9;c0-1.506,0.6832-2.8425,1.7401-3.7599L3.5193,1.0193C2.2831,2.1183,1.5,3.7158,1.5,5.5c0,3.1449,2.4208,5.72,5.5,5.9747V13H6.5&#xA;&#x9;&#x9;&#x9;C6.2239,13,6,13.2238,6,13.5C6,13.7761,6.2239,14,6.5,14h2C8.7761,14,9,13.7761,9,13.5C9,13.2238,8.7761,13,8.5,13H8v-1.5273&#xA;&#x9;&#x9;&#x9;C9.5806,11.341,10.9858,10.5997,11.9807,9.4807z"/>\n    </g>\n    <g>\n      <path d="M7.5,9C9.433,9,11,7.433,11,5.5S9.433,2,7.5,2S4,3.567,4,5.5S5.567,9,7.5,9z M8.5,4l0.3638-0.5915&#xA;&#x9;&#x9;&#x9;c0.3463,0.2263,0.6249,0.5394,0.8235,0.9042L9.5,5h-1V4z M6.6563,3.1563L7.5,4v1L8,6h1.5h0.4396&#xA;&#x9;&#x9;&#x9;C9.7708,6.826,9.2026,7.5041,8.4381,7.8144L8,7H6.5L5.0504,5C5.2251,4.1396,5.8452,3.4486,6.6563,3.1563z"/>\n    </g>\n  </g>\n</svg>'
  },
  golf: {
    label: 'Golf',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="golf-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path11758" d="&#xA;&#x9;M3.3999,1.1c0,0.1,0,0.2,0,0.2c0,0.4,0.3,0.7,0.7,0.7c0.3,0,0.5-0.2,0.6-0.5l0,0L4.9,1l5.6,2.3L6.6,6C6.2,6.3,6.2,6.7,6.3,7.1&#xA;&#x9;l0.9,2.1l-1.3,3.9C5.7,13.6,6.1,14,6.5,14c0.3,0,0.5-0.1,0.6-0.5l1.4-4l0.1,0.3v3.5c0,0,0,0.7,0.7,0.7s0.7-0.7,0.7-0.7V10&#xA;&#x9;c0-0.2,0-0.3-0.1-0.5L8.5,6.1l2.7-1.9c0.2-0.2,0.4-0.3,0.4-0.6s-0.2-0.5-0.4-0.6L4,0.1c-0.0878,0-0.118,0.0179-0.2001,0.1&#xA;&#x9;L3.3999,1.1z M5.5,3C4.7,3,4,3.7,4,4.5S4.7,6,5.5,6S7,5.3,7,4.5S6.2999,3,5.5,3z"/>\n</svg>'
  },
  grocery: {
    label: 'Grocery',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" version="1.1" id="grocery-15" width="15px" height="15px" viewBox="0 0 15 15">\n  <g id="g3">\n    <path d="M 13.199219 1.5 C 13.199219 1.5 11.808806 1.4588 11.253906 2 C 10.720406 2.5202 10.5 2.9177 10.5 4 L 1.1992188 4 L 2.59375 8.8144531 C 2.59725 8.8217531 2.6036219 8.8287375 2.6074219 8.8359375 C 2.8418219 9.4932375 3.4545469 9.9666406 4.1855469 9.9941406 C 4.1885469 9.9954406 4.1992187 10 4.1992188 10 L 10.699219 10 L 10.699219 10.199219 C 10.699219 10.199219 10.7 10.500391 10.5 10.900391 C 10.3 11.300391 10.200391 11.5 9.4003906 11.5 L 2.9003906 11.5 C 1.9003906 11.5 1.9003906 13 2.9003906 13 L 4.0996094 13 L 4.1992188 13 L 9.0996094 13 L 9.1992188 13 L 9.3007812 13 C 10.500781 13 11.399219 12.299609 11.699219 11.599609 C 11.999219 10.899609 12 10.300781 12 10.300781 L 12 10 L 12 4 C 12 3.4764 12.228619 3 12.699219 3 L 13.25 3 C 13.6642 3 14 2.6642 14 2.25 C 14 1.8358 13.6642 1.5 13.25 1.5 L 13.199219 1.5 z M 9.1992188 13 C 8.5992188 13 8.1992188 13.4 8.1992188 14 C 8.1992188 14.6 8.5992187 15 9.1992188 15 C 9.7992187 15 10.199219 14.6 10.199219 14 C 10.199219 13.4 9.7992188 13 9.1992188 13 z M 4.1992188 13 C 3.5992188 13 3.1992188 13.4 3.1992188 14 C 3.1992188 14.6 3.5992187 15 4.1992188 15 C 4.7992188 15 5.1992188 14.6 5.1992188 14 C 5.1992188 13.4 4.7992187 13 4.1992188 13 z " id="path5"/>\n  </g>\n</svg>'
  },
  hairdresser: {
    label: 'Hairdresser',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="hairdresser-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M15,3c0,0-2-0.6-3.5,0.5l-4.3,3C6.4,5.9,5.2,5.2,4,4.8V4c0-1.1-0.9-2-2-2C0.9,2,0,2.9,0,4v1.5&#xA;&#x9;C0,6,0.5,6,0.5,6H2h0.5C4.5,6,6,7.5,6,7.5S4.5,9,2.5,9H2H0.5C0.5,9,0,9,0,9.5V11c0,1.1,0.9,2,2,2c1.1,0,2-0.9,2-2v-0.8&#xA;&#x9;c1.2-0.4,2.4-1.1,3.2-1.7l4.3,3C13,12.6,15,12,15,12L8.5,7.5L15,3z M3,5H2H1V4c0-0.6,0.4-1,1-1c0.6,0,1,0.4,1,1V5z M3,11&#xA;&#x9;c0,0.6-0.4,1-1,1c-0.6,0-1-0.4-1-1v-1h1h1V11z M7.25,8c-0.2761,0-0.5-0.2239-0.5-0.5S6.9739,7,7.25,7s0.5,0.2239,0.5,0.5&#xA;&#x9;S7.5261,8,7.25,8z"/>\n</svg>'
  },
  harbor: {
    label: 'Harbor',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="harbor-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path5263" d="M7.5,0C5.5,0,4,1.567,4,3.5c0.0024,1.5629,1.0397,2.902,2.5,3.3379v6.0391&#xA;&#x9;c-0.9305-0.1647-1.8755-0.5496-2.6484-1.2695C2.7992,10.6273,2.002,9.0676,2.002,6.498c0.0077-0.5646-0.4531-1.0236-1.0176-1.0137&#xA;&#x9;C0.4329,5.493-0.0076,5.9465,0,6.498c0,3.0029,1.0119,5.1955,2.4902,6.5723C3.9685,14.4471,5.8379,15,7.5,15&#xA;&#x9;c1.6656,0,3.535-0.5596,5.0117-1.9395S14.998,9.4868,14.998,6.498c0.0648-1.3953-2.0628-1.3953-1.998,0&#xA;&#x9;c0,2.553-0.7997,4.1149-1.8535,5.0996C10.3731,12.3203,9.4288,12.7084,8.5,12.875V6.8418C9.9607,6.4058,10.9986,5.0642,11,3.5&#xA;&#x9;C11,1.567,9.5,0,7.5,0z M7.5,2C8.3284,2,9,2.6716,9,3.5S8.3284,5,7.5,5S6,4.3284,6,3.5S6.6716,2,7.5,2z"/>\n</svg>'
  },
  hardware: {
    label: 'Hardware',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="hardware-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.7919,3.2619c0,0-1.676,1.675-2.1163,2.1208c-0.085,0.0861-0.1688,0.1135-0.282,0.0961&#xA;&#x9;c-0.1481-0.0226-0.2974-0.038-0.4462-0.0558c-0.4072-0.0485-0.8145-0.0966-1.2292-0.1458C9.649,4.6852,9.5787,4.1049,9.5177,3.5236&#xA;&#x9;C9.512,3.4689,9.5509,3.3943,9.5925,3.3522c0.5071-0.5134,1.9261-1.9287,2.134-2.136c-0.4508-0.2129-1.2243-0.2968-1.8007-0.2031&#xA;&#x9;c-2.1801,0.3543-3.5112,2.534-2.8206,4.625C7.1432,5.753,7.1194,5.8201,7.0374,5.902C5.1891,7.7454,3.3436,9.5914,1.498,11.4374&#xA;&#x9;c-0.0616,0.0616-0.1231,0.124-0.1779,0.1913c-0.5264,0.6473-0.3873,1.6264,0.2974,2.102c0.6044,0.4197,1.3658,0.3442,1.9053-0.1948&#xA;&#x9;c1.8534-1.8519,3.7059-3.7047,5.556-5.5598C9.1707,7.884,9.2437,7.8526,9.3779,7.8983c0.6189,0.2109,1.2524,0.2354,1.8884,0.0884&#xA;&#x9;c1.9386-0.4478,3.1251-2.3732,2.6549-4.3034C13.8895,3.5532,13.843,3.4244,13.7919,3.2619z"/>\n</svg>'
  },
  heart: {
    label: 'Heart',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="heart-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.91,6.75c-1.17,2.25-4.3,5.31-6.07,6.94c-0.1903,0.1718-0.4797,0.1718-0.67,0C5.39,12.06,2.26,9,1.09,6.75&#xA;&#x9;C-1.48,1.8,5-1.5,7.5,3.45C10-1.5,16.48,1.8,13.91,6.75z"/>\n</svg>'
  },
  heliport: {
    label: 'Heliport',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="heliport-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path10415" d="M4,2C3,2,3,3,4,3h4v1C7.723,4,7.5,4.223,7.5,4.5V5H5H3.9707H3.9316&#xA;&#x9;C3.7041,4.1201,2.9122,3.5011,2,3.5c-1.1046,0-2,0.8954-2,2s0.8954,2,2,2c0.3722-0.001,0.7368-0.1058,1.0527-0.3027L5.5,10.5&#xA;&#x9;C6.5074,11.9505,8.3182,12,9,12h5c0,0,1,0,1-1v-0.9941C15,9.2734,14.874,8.874,14.5,8.5l-3-3c0,0-0.5916-0.5-1.2734-0.5H9.5V4.5&#xA;&#x9;C9.5,4.223,9.277,4,9,4V3h4c1,0,1-1,0-1C13,2,4,2,4,2z M2,4.5c0.5523,0,1,0.4477,1,1s-0.4477,1-1,1s-1-0.4477-1-1&#xA;&#x9;C1,4.9477,1.4477,4.5,2,4.5z M10,6c0.5,0,0.7896,0.3231,1,0.5L13.5,9H10c0,0-1,0-1-1V7C9,7,9,6,10,6z"/>\n</svg>'
  },
  home: {
    label: 'Home',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15" id="home-15">\n  <path d="M2,13.7478c0,0.13807,0.11193,0.25,0.25,0.25h3.749v-3h3v3h3.749c0.13807,0,0.25-0.11193,0.25-0.25V7.9987H2&#xA;&#x9;C2,7.9987,2,13.7478,2,13.7478z M13.93,6.5778l-0.9319-0.8189V2c0-0.55228-0.44771-1-1-1s-1,0.44772-1,1v2L7.6808,1.09&#xA;&#x9;C7.5863,0.9897,7.42846,0.98478,7.3279,1.079L7.3169,1.09L1.0678,6.553C0.9734,6.65376,0.97856,6.81197,1.07932,6.90637&#xA;&#x9;C1.12478,6.94896,1.18451,6.97304,1.2468,6.9739L3,6.9989h10.7468c0.13807,0.00046,0.25037-0.1111,0.25083-0.24917&#xA;&#x9;C13.99784,6.68592,13.97365,6.62445,13.93,6.5779V6.5778z"/>\n</svg>'
  },
  'horse-riding': {
    label: 'Horse riding',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="horse-riding-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M6,1A1,1,0,1,1,7,2,1,1,0,0,1,6,1ZM8,3.5a.484.484,0,0,0,0-.058A.472.472,0,0,0,7.5,3h-1a.484.484,0,0,0-.058,0A.472.472,0,0,0,6,3.5V7H8Zm6.85,3.644L12.8,4.8l.085-.509a.478.478,0,0,0,.008-.063.25.25,0,0,0-.25-.25.346.346,0,0,0-.158.056L9,7H8L9,8V9.5a.5.5,0,0,1-1,0v-1L6,7H4a1.5,1.5,0,0,0-1.243.661A1.466,1.466,0,0,0,1.563,7H1.5A1.449,1.449,0,0,0,0,8.4v.086A3.781,3.781,0,0,0,.559,10.4a.278.278,0,0,0,.191.1A.25.25,0,0,0,1,10.25V9s-.02-.924.753-1c.5-.048.747.253.747.5V11L2,13v1.75a.25.25,0,0,0,.25.25.254.254,0,0,0,.25-.234V13L4,11v1l.5,2.8a.255.255,0,0,0,.246.2A.25.25,0,0,0,5,14.754H5L4.855,12.3,5.5,11H8v1l.508,2.813A.257.257,0,0,0,8.75,15,.25.25,0,0,0,9,14.75V12l.367-1a1.155,1.155,0,0,0,.543-.6l2.161-3.767a.863.863,0,0,0,1.023.4l1.066.818a.591.591,0,0,0,.35.135.487.487,0,0,0,.475-.4A.552.552,0,0,0,14.85,7.144Z"/>\n</svg>'
  },
  hospital: {
    label: 'Hospital',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="hospital-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect4194" d="M7,1C6.4,1,6,1.4,6,2v4H2C1.4,6,1,6.4,1,7v1&#xA;&#x9;c0,0.6,0.4,1,1,1h4v4c0,0.6,0.4,1,1,1h1c0.6,0,1-0.4,1-1V9h4c0.6,0,1-0.4,1-1V7c0-0.6-0.4-1-1-1H9V2c0-0.6-0.4-1-1-1H7z"/>\n</svg>'
  },
  'ice-cream': {
    label: 'Ice cream',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="ice-cream-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M5.44,8.17c0.7156,0.0006,1.414-0.2194,2-0.63C7.9037,7.8634,8.4391,8.0693,9,8.14h0.44L8,13.7&#xA;&#x9;c-0.1082,0.2541-0.4019,0.3723-0.656,0.264C7.2252,13.9134,7.1306,13.8188,7.08,13.7L5.44,8.17z"/>\n  <path d="M11.44,4.67c0,1.1046-0.8954,2-2,2s-2-0.8954-2-2l0,0l0,0l0,0c0,1.1046-0.8954,2-2,2s-2-0.8954-2-2s0.8954-2,2-2h0.12&#xA;&#x9;C5.1756,1.6345,5.7035,0.4834,6.739,0.099s2.1866,0.1435,2.571,1.179c0.1667,0.449,0.1667,0.9429,0,1.3919h0.13&#xA;&#x9;C10.5446,2.67,11.44,3.5654,11.44,4.67z"/>\n</svg>'
  },
  industry: {
    label: 'Industry',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="industry-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,1v12H1V8.72c0.0016-0.1419,0.0634-0.2764,0.17-0.37l3-3.22c0.2074-0.1823,0.5234-0.1618,0.7056,0.0456&#xA;&#x9;C4.9568,5.268,5.0011,5.387,5,5.51v3l3.16-3.37c0.2025-0.1878,0.5188-0.1759,0.7066,0.0266C8.9532,5.2599,9.0009,5.3827,9,5.51V11h3&#xA;&#x9;V1H14z"/>\n</svg>'
  },
  information: {
    label: 'Information',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="information-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect8399" d="M7.5,1&#xA;&#x9;C6.7,1,6,1.7,6,2.5S6.7,4,7.5,4S9,3.3,9,2.5S8.3,1,7.5,1z M4,5v1c0,0,2,0,2,2v2c0,2-2,2-2,2v1h7v-1c0,0-2,0-2-2V6c0-0.5-0.5-1-1-1H4&#xA;&#x9;z"/>\n</svg>'
  },
  'jewelry-store': {
    label: 'Jewelry store',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="jewelry-store-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12,8.5c0,2.4853-2.0147,4.5-4.5,4.5S3,10.9853,3,8.5c0-1.8483,1.1164-3.4329,2.7099-4.1255l0.1761,0.137l0.7739,0.6019&#xA;&#x9;C5.1366,5.4922,4,6.8611,4,8.5C4,10.4299,5.5701,12,7.5,12S11,10.4299,11,8.5c0-1.6389-1.1366-3.0078-2.6599-3.3866l0.95-0.7388&#xA;&#x9;C10.8836,5.0672,12,6.6517,12,8.5z M7.5,4.5L10,2.5555L9,1H6L5,2.5555l1.5,1.1667L7.5,4.5z"/>\n</svg>'
  },
  karaoke: {
    label: 'Karaoke',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" id="karaoke-15">\n  <g>\n    <path d="M12.1,2.952A2.988,2.988,0,0,0,6.99,4.917l3.142,3.142A2.988,2.988,0,0,0,12.1,2.952Z"/>\n    <path d="M4.672,8.255,2.55,10.377a1,1,0,0,0,0,1.414l.707.707a1,1,0,0,0,1.414,0l2.121-2.121L8.914,8.255,6.793,6.134Zm.741,2.087-.707-.707L6.793,7.548l.707.707Z"/>\n  </g>\n</svg>'
  },
  landmark: {
    label: 'Landmark',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="landmark-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12.5,12H12v-0.5c0-0.3-0.2-0.5-0.5-0.5H11V6h1l1-2c-1,0.1-2,0.1-3,0C9.2,3.4,8.6,2.8,8,2V1.5C8,1.2,7.8,1,7.5,1&#xA;&#x9;S7,1.2,7,1.5V2C6.4,2.8,5.8,3.4,5,4C4,4.1,3,4.1,2,4l1,2h1v5c0,0-0.5,0-0.5,0C3.2,11,3,11.2,3,11.5V12H2.5C2.2,12,2,12.2,2,12.5V13&#xA;&#x9;h11v-0.5C13,12.2,12.8,12,12.5,12z M7,11H5V6h2V11z M10,11H8V6h2V11z"/>\n</svg>'
  },
  landuse: {
    label: 'Landuse',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="landuse-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M8.911,3.854A.248.248,0,0,1,9,4.044V7.75A.25.25,0,0,1,8.75,8H6.25A.25.25,0,0,1,6,7.75V6H5V7.75A.25.25,0,0,1,4.75,8H2.25A.25.25,0,0,1,2,7.75v-3.7a.248.248,0,0,1,.089-.19L5.343,1.132a.245.245,0,0,1,.315,0ZM7.752,9.5a.248.248,0,0,0-.138.042L5,11.5H4v-2a.5.5,0,0,0-1,0v2H2v-2a.5.5,0,0,0-1,0v4.25a.25.25,0,0,0,.25.25h6.5A.25.25,0,0,0,8,13.75v-4A.248.248,0,0,0,7.752,9.5ZM14,6.245v6.5a.253.253,0,0,1-.253.253H10.253A.253.253,0,0,1,10,12.747V6.25A.249.249,0,0,1,10.25,6H11V5.249A.249.249,0,0,1,11.249,5h1.5A.253.253,0,0,1,13,5.253V6h.755A.245.245,0,0,1,14,6.245ZM13,11H11v1h2Zm0-2H11v1h2Zm0-2H11V8h2Z"/>\n</svg>'
  },
  laundry: {
    label: 'Laundry',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="laundry-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path3291-2" d="M8,1L6,3H3c0,0-1,0-1,1v9c0,1,1,1,1,1h9c0,0,1,0,1-1V2c0-1-1-1-1-1&#xA;&#x9;S8,1,8,1z M8.5,2h2C10.777,2,11,2.223,11,2.5S10.777,3,10.5,3h-2C8.223,3,8,2.777,8,2.5S8.223,2,8.5,2z M7.5,6&#xA;&#x9;c1.6569,0,3,1.3431,3,3s-1.3431,3-3,3s-3-1.3431-3-3S5.8431,6,7.5,6z"/>\n</svg>'
  },
  library: {
    label: 'Library',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="library-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M7.47,4.92C7.47,4.92,5.7,3,1,3v8c4.7,0,6.47,2,6.47,2S9.3,11,14,11V3C9.3,3,7.47,4.92,7.47,4.92z M13,10&#xA;&#x9;c-1.9614,0.0492-3.8727,0.6299-5.53,1.68C5.836,10.6273,3.9432,10.0459,2,10V4c3.4,0.26,4.73,1.6,4.75,1.61l0.73,0.74L8.2,5.6&#xA;&#x9;c0,0,1.4-1.34,4.8-1.6V10z M8,10.24l-0.1-0.17c1.3011-0.5931,2.6827-0.9907,4.1-1.18v0.2c-1.3839,0.1953-2.7316,0.5929-4,1.18V10.24&#xA;&#x9;z M8,9.24L7.9,9.07C9.2016,8.4802,10.5832,8.086,12,7.9v0.2c-1.3844,0.1988-2.7321,0.5997-4,1.19V9.24z M8,8.24L7.9,8.07&#xA;&#x9;C9.2015,7.48,10.5831,7.0857,12,6.9v0.2c-1.3845,0.1981-2.7323,0.599-4,1.19V8.24z M8,7.24L7.9,7.07&#xA;&#x9;C9.2013,6.4794,10.583,6.0851,12,5.9v0.2c-1.3844,0.1986-2.7321,0.5996-4,1.19V7.24z M6.9,10.24C5.6639,9.6641,4.3499,9.2733,3,9.08&#xA;&#x9;v-0.2c1.3872,0.2028,2.7358,0.6141,4,1.22L6.9,10.24z M6.9,9.24C5.6629,8.671,4.3488,8.2869,3,8.1V7.9&#xA;&#x9;c1.386,0.2027,2.7341,0.6105,4,1.21L6.9,9.24z M6.9,8.24C5.6631,7.6705,4.3489,7.2863,3,7.1V6.9c1.3868,0.199,2.7354,0.607,4,1.21&#xA;&#x9;L6.9,8.24z M6.9,7.24C5.6629,6.671,4.3488,6.2869,3,6.1V5.9c1.386,0.2024,2.7342,0.6102,4,1.21L6.9,7.24z"/>\n</svg>'
  },
  lighthouse: {
    label: 'Lighthouse',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="lighthouse-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M4.5,6L0,7V6.5l4.5-1V6z M4.5,3.5L0,2.5V3l4.5,1V3.5z M10.5,3.5V4L15,3V2.5L10.5,3.5z M10.5,6L15,7V6.5l-4.5-1V6z M8,7V2&#xA;&#x9;h2.5c0.2761,0.0552,0.5448-0.1239,0.6-0.4c0.0552-0.2761-0.1239-0.5448-0.4-0.6l-3-1C7.5696-0.0586,7.4204-0.0586,7.29,0l-3,1&#xA;&#x9;c-0.2761,0.0552-0.4552,0.3239-0.4,0.6S4.2139,2.0552,4.49,2H7v5H5l-2,7h9l-2-7H8z"/>\n</svg>'
  },
  lodging: {
    label: 'Lodging',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="lodging-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect6507" d="M0.5,2.5C0.2,2.5,0,2.7,0,3v7.5v2C0,12.8,0.2,13,0.5,13S1,12.8,1,12.5V11h13v1.5&#xA;&#x9;c0,0.3,0.2,0.5,0.5,0.5s0.5-0.2,0.5-0.5v-2c0-0.3-0.2-0.5-0.5-0.5H1V3C1,2.7,0.8,2.5,0.5,2.5z M3.5,3C2.7,3,2,3.7,2,4.5l0,0&#xA;&#x9;C2,5.3,2.7,6,3.5,6l0,0C4.3,6,5,5.3,5,4.5l0,0C5,3.7,4.3,3,3.5,3L3.5,3z M7,4C5.5,4,5.5,5.5,5.5,5.5V7h-3C2.2,7,2,7.2,2,7.5v1&#xA;&#x9;C2,8.8,2.2,9,2.5,9H6h9V6.5C15,4,12.5,4,12.5,4H7z"/>\n</svg>'
  },
  logging: {
    label: 'Logging',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="logging-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M13.91,3.41,13.5,3l.2-.28c.02-.03.04-.05.06-.08A.969.969,0,0,0,14,1.99a1,1,0,0,0-1.62-.77c-.03.02-.06.05-.09.07L12,1.5l-.386-.386a.354.354,0,0,0-.525.475l.417.417-.5.5-.392-.392a.354.354,0,0,0-.525.475L10.5,3l-.5.5-.381-.381a.354.354,0,1,0-.528.472h0l.028.028L9.5,4,9,4.5l-.395-.395a.354.354,0,0,0-.517.483L8.5,5,8,5.5l-.365-.365a.354.354,0,0,0-.556.439h0C7.1,5.6,7.508,6,7.508,6L7,6.5l-.394-.392a.392.392,0,0,0-.5-.028.384.384,0,0,0-.028.5L6.1,6.6l.4.4L6,7.5l-.4-.4a.37.37,0,0,0-.5,0L6.248,8.244,12.09,2.41,12.5,2H13v.5l-.41.41L6.751,8.749,7.9,9.9a.355.355,0,0,0,0-.5l-.008-.009L7.5,9,8,8.5l.384.384a.354.354,0,0,0,.528-.472L8.5,8,9,7.5l.38.38a.354.354,0,0,0,.528-.472l-.02-.02L9.5,7l.5-.5.377.377A.35.35,0,0,0,10.64,7a.347.347,0,0,0,.252-.6L10.5,6l.5-.5.38.38a.354.354,0,0,0,.528-.472L11.88,5.38,11.5,5l.5-.5.381.381a.354.354,0,0,0,.528-.472l-.025-.025L12.5,4l.5-.5.382.382a.354.354,0,0,0,.528-.472ZM4.39,7.916C3.893,7.419,3.641,7,3,7H1.5a.5.5,0,0,0-.5.5v3A2.19,2.19,0,0,0,1.5,12l.815.811A2.251,2.251,0,0,0,5.493,13h0L7.5,11ZM3.5,10,2.262,11.238A1.3,1.3,0,0,1,2,10.5V8H3a.545.545,0,0,1,.335.194.455.455,0,0,1,.165.418Z"/>\n</svg>'
  },
  marker: {
    label: 'Marker',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="marker-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path4133" d="M7.5,0C5.0676,0,2.2297,1.4865,2.2297,5.2703&#xA;&#x9;C2.2297,7.8378,6.2838,13.5135,7.5,15c1.0811-1.4865,5.2703-7.027,5.2703-9.7297C12.7703,1.4865,9.9324,0,7.5,0z"/>\n</svg>'
  },
  'marker-stroked': {
    label: 'Marker stroked',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="marker-stroked-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="Layer_7" d="M7.5,14.941l-.4-.495c-.973-1.189-4.9-6.556-4.9-9.16A5.066,5.066,0,0,1,7.036,0q.222-.01.445,0a5.066,5.066,0,0,1,5.286,4.836q.01.225,0,.45c0,2.213-2.669,6.111-4.678,8.851ZM7.481.986a4.077,4.077,0,0,0-4.3,4.3c0,1.832,2.759,6.038,4.286,8.034,1.25-1.71,4.315-5.989,4.315-8.034a4.077,4.077,0,0,0-4.3-4.3Z"/>\n</svg>'
  },
  'mobile-phone': {
    label: 'Mobile phone',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="mobile-phone-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M10,2h0V1.5a.5.5,0,0,0-1,0V2H5A1,1,0,0,0,4,3V13a1,1,0,0,0,1,1h5a1,1,0,0,0,1-1V3A1,1,0,0,0,10,2ZM6,13H5V12H6Zm0-2H5V10H6ZM6,9H5V8H6Zm2,4H7V12H8Zm0-2H7V10H8ZM8,9H7V8H8Zm2,4H9V12h1Zm0-2H9V10h1Zm0-2H9V8h1Zm0-2.5a.5.5,0,0,1-.5.5h-4A.5.5,0,0,1,5,6.5v-3A.5.5,0,0,1,5.5,3h4a.5.5,0,0,1,.5.5Z"/>\n</svg>'
  },
  monument: {
    label: 'Monument',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="monument-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path11719-7" d="M7.5,0L6,2.5v7h3v-7L7.5,0z M3,11.5&#xA;&#x9;L3,15h9v-3.5L10.5,10h-6L3,11.5z"/>\n</svg>'
  },
  mountain: {
    label: 'Mountain',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="mountain-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path5571" d="M7.5,2C7.2,2,7.1,2.2,6.9,2.4&#xA;&#x9;l-5.8,9.5C1,12,1,12.2,1,12.3C1,12.8,1.4,13,1.7,13h11.6c0.4,0,0.7-0.2,0.7-0.7c0-0.2,0-0.2-0.1-0.4L8.2,2.4C8,2.2,7.8,2,7.5,2z&#xA;&#x9; M7.5,3.5L10.8,9H10L8.5,7.5L7.5,9l-1-1.5L5,9H4.1L7.5,3.5z"/>\n</svg>'
  },
  museum: {
    label: 'Museum',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="museum-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path7509" d="M7.5,0L1,3.4453V4h13V3.4453L7.5,0z M2,5v5l-1,1.5547V13h13v-1.4453L13,10&#xA;&#x9;V5H2z M4.6152,6c0.169-0.0023,0.3318,0.0639,0.4512,0.1836L7.5,8.6172l2.4336-2.4336c0.2445-0.2437,0.6402-0.2432,0.884,0.0013&#xA;&#x9;C10.9341,6.3017,10.9997,6.46,11,6.625v4.2422c0.0049,0.3452-0.271,0.629-0.6162,0.6338c-0.3452,0.0049-0.629-0.271-0.6338-0.6162&#xA;&#x9;c-0.0001-0.0059-0.0001-0.0118,0-0.0177V8.1328L7.9414,9.9414c-0.244,0.2433-0.6388,0.2433-0.8828,0L5.25,8.1328v2.7344&#xA;&#x9;c0.0049,0.3452-0.271,0.629-0.6162,0.6338C4.2887,11.5059,4.0049,11.2301,4,10.8849c-0.0001-0.0059-0.0001-0.0118,0-0.0177V6.625&#xA;&#x9;C4,6.2836,4.2739,6.0054,4.6152,6z"/>\n</svg>'
  },
  music: {
    label: 'Music',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="music-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.5,1c-0.0804,0.0008-0.1594,0.0214-0.23,0.06L4.5,3.5C4.2239,3.5,4,3.7239,4,4v6.28C3.6971,10.1002,3.3522,10.0037,3,10&#xA;&#x9;c-1.1046,0-2,0.8954-2,2s0.8954,2,2,2s2-0.8954,2-2V7.36l8-2.22v3.64c-0.3029-0.1798-0.6478-0.2763-1-0.28c-1.1046,0-2,0.8954-2,2&#xA;&#x9;s0.8954,2,2,2s2-0.8954,2-2v-9C14,1.2239,13.7761,1,13.5,1z M13,4.14L5,6.36v-2l8-2.22C13,2.14,13,4.14,13,4.14z"/>\n</svg>'
  },
  natural: {
    label: 'Natural',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="natural-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M8.753,6.278a.5.5,0,0,1-.51,0A4.109,4.109,0,0,1,6.5,3.5a2.779,2.779,0,0,0-.59-1.506l-.019-.027a.257.257,0,0,1-.056-.144.237.237,0,0,1,.25-.25.264.264,0,0,1,.057.011A3.523,3.523,0,0,1,7.5,2.5L8.28.94a.246.246,0,0,1,.44,0L9.5,2.5a3.4,3.4,0,0,1,1.339-.907.283.283,0,0,1,.1-.021c.175.009.212.119.221.249a.35.35,0,0,1-.043.141A5.2,5.2,0,0,0,10.5,3.5,4.113,4.113,0,0,1,8.753,6.278ZM5,8H6.289a.25.25,0,0,0,.25-.25.241.241,0,0,0-.061-.15L4.7,5.235a.255.255,0,0,0-.391,0L2.518,7.589a.274.274,0,0,0-.062.161.25.25,0,0,0,.25.25H4L1.335,10.6a.273.273,0,0,0-.058.152A.25.25,0,0,0,1.529,11H3L1.435,12.565a.255.255,0,0,0,.18.435H4v1H5V13H7.385a.255.255,0,0,0,.18-.435L6,11H7.471a.25.25,0,0,0,.25-.25.233.233,0,0,0-.058-.149Zm9.345,3.748a.252.252,0,0,1-.252.252H8.908a.252.252,0,0,1-.226-.365L11.27,6.451a.252.252,0,0,1,.451,0l2.6,5.184h0A.251.251,0,0,1,14.345,11.748ZM12.75,10,11.5,7.5,10.25,10Z"/>\n</svg>'
  },
  'oil-rig-es': {
    label: 'Oil rig',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="oil-rig-es-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M14,13H12L10,2H9V1H8V0H7V1H6V2H5L3,13H1L0,15H15ZM5.82,3H9.18l.55,3H5.27ZM9,7,7.5,9.25,6,7ZM4,13,5.07,7.11,7,10,5,13Zm2,0,1.5-2.25L9,13Zm4,0L8,10,9.93,7.11,11,13Z"/>\n</svg>'
  },
  optician: {
    label: 'Optician',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="optician-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14.5,6h-0.6766c-0.2828-0.5892-0.8801-1-1.5763-1H9.752C8.9344,5,8.2513,5.5656,8.059,6.3246&#xA;&#x9;C7.8854,6.2835,7.6991,6.25,7.5,6.25S7.1146,6.2834,6.941,6.3245C6.7487,5.5656,6.0654,5,5.2476,5H2.7529&#xA;&#x9;C2.0566,5,1.4592,5.4108,1.1765,6H0.4992C0.2235,6,0,6.2234,0,6.4991v0.0016C0,6.7765,0.2235,7,0.4992,7H1v0.5&#xA;&#x9;C1,9.0889,2.0024,10,3.75,10h0.5C5.9976,10,7,9.0889,7,7.5V7.3413C7.1503,7.2933,7.3307,7.25,7.5,7.25&#xA;&#x9;c0.1693,0,0.3499,0.0433,0.5,0.0913V7.5C8,9.0889,9.002,10,10.75,10h0.5C12.998,10,14,9.0889,14,7.5V7h0.5&#xA;&#x9;C14.7761,7,15,6.7761,15,6.5C15,6.2238,14.7761,6,14.5,6z M6,7.5C6,8.1982,5.8013,9,4.25,9h-0.5C2.1987,9,2,8.1982,2,7.5V6.7524&#xA;&#x9;C2,6.3374,2.3379,6,2.7529,6h2.4946C5.6626,6,6,6.3374,6,6.7524V7.5z M13,7.5C13,8.1982,12.8008,9,11.25,9h-0.5&#xA;&#x9;C9.1992,9,9,8.1982,9,7.5V6.7524C9,6.3374,9.3369,6,9.752,6h2.4951C12.6621,6,13,6.3379,13,6.7529V7.5z"/>\n</svg>'
  },
  paint: {
    label: 'Paint',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="paint-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.5,2.5h-1V1.5027C12.5,1.225,12.2749,1,11.9973,1H1.5027C1.2251,1,1,1.225,1,1.5027v2.9946C1,4.7749,1.2251,5,1.5027,5&#xA;&#x9;h10.4946C12.2749,5,12.5,4.7749,12.5,4.4973V3.5H13v3.1021L6.8877,8.0127C6.6606,8.0654,6.5,8.2676,6.5,8.5v1.5074&#xA;&#x9;c-0.2783,0.02-0.5,0.246-0.5,0.5295v2.9261C6,13.7596,6.2404,14,6.5369,14h0.9261C7.7596,14,8,13.7596,8,13.4631v-2.9261&#xA;&#x9;c0-0.2834-0.2217-0.5095-0.5-0.5295v-1.11l6.1123-1.4102C13.8389,7.4351,14,7.2329,14,7V3C14,2.7236,13.7764,2.5,13.5,2.5z"/>\n</svg>'
  },
  park: {
    label: 'Park',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="park-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,5.75c0.0113-0.6863-0.3798-1.3159-1-1.61C12.9475,3.4906,12.4014,2.9926,11.75,3&#xA;&#x9;c-0.0988,0.0079-0.1962,0.0281-0.29,0.06c-0.0607-0.66-0.6449-1.1458-1.3048-1.0851C9.8965,1.9987,9.6526,2.1058,9.46,2.28l0,0&#xA;&#x9;c0-0.6904-0.5596-1.25-1.25-1.25S6.96,1.5896,6.96,2.28C6.96,2.28,7,2.3,7,2.33C6.4886,1.8913,5.7184,1.9503,5.2797,2.4618&#xA;&#x9;C5.1316,2.6345,5.0347,2.8451,5,3.07C4.8417,3.0195,4.6761,2.9959,4.51,3C3.6816,2.9931,3.0044,3.659,2.9975,4.4874&#xA;&#x9;C2.9958,4.6872,3.0341,4.8852,3.11,5.07C2.3175,5.2915,1.8546,6.1136,2.0761,6.9061C2.2163,7.4078,2.6083,7.7998,3.11,7.94&#xA;&#x9;c0.2533,0.7829,1.0934,1.2123,1.8763,0.959C5.5216,8.7258,5.9137,8.2659,6,7.71C6.183,7.8691,6.4093,7.9701,6.65,8v5L5,14h5l-1.6-1&#xA;&#x9;v-2c0.7381-0.8915,1.6915-1.5799,2.77-2c0.8012,0.1879,1.603-0.3092,1.7909-1.1103C12.9893,7.7686,13.0025,7.6444,13,7.52&#xA;&#x9;c0.0029-0.0533,0.0029-0.1067,0-0.16C13.6202,7.0659,14.0113,6.4363,14,5.75z M8.4,10.26V6.82C8.6703,7.3007,9.1785,7.5987,9.73,7.6&#xA;&#x9;h0.28c0.0156,0.4391,0.2242,0.849,0.57,1.12C9.7643,9.094,9.0251,9.6162,8.4,10.26z"/>\n</svg>'
  },
  'park-alt1': {
    label: 'Park 2',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="park-alt1-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M9.428,10.429a.269.269,0,0,1-.074-.18A.25.25,0,0,1,9.6,10h1.447a.25.25,0,0,0,.25-.25.258.258,0,0,0-.079-.179L9.07,7.419a.3.3,0,0,1-.063-.17A.249.249,0,0,1,9.257,7H10.4a.251.251,0,0,0,.25-.251.247.247,0,0,0-.077-.178L8.432,4.434,8.418,4.42a.262.262,0,0,1-.066-.17A.25.25,0,0,1,8.6,4h.866a.25.25,0,0,0,.25-.25.246.246,0,0,0-.068-.164h.006L7.7,1.238a.253.253,0,0,0-.042-.044A.249.249,0,0,0,7.5,1.139h0a.249.249,0,0,0-.158.055.253.253,0,0,0-.042.044L5.352,3.586a.246.246,0,0,0-.068.164.25.25,0,0,0,.25.25H6.4a.241.241,0,0,1,.184.42l-.014.014L4.431,6.571a.247.247,0,0,0-.077.178A.251.251,0,0,0,4.6,7H5.745a.249.249,0,0,1,.25.249.3.3,0,0,1-.063.17L3.782,9.571A.258.258,0,0,0,3.7,9.75a.25.25,0,0,0,.25.25H5.4a.25.25,0,0,1,.248.249.269.269,0,0,1-.074.18l-2.14,2.132-.009.009a.248.248,0,0,0,0,.351A.256.256,0,0,0,3.605,13H7v1l1-.008V13h3.391a.263.263,0,0,0,.26-.254.248.248,0,0,0-.071-.177Z"/>\n</svg>'
  },
  parking: {
    label: 'Parking',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="parking-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11.85,8.37c-0.9532,0.7086-2.1239,1.0623-3.31,1H5.79V14H3V1h5.72c1.1305-0.0605,2.244,0.2952,3.13,1&#xA;&#x9;c0.8321,0.8147,1.2543,1.9601,1.15,3.12C13.1271,6.3214,12.7045,7.5159,11.85,8.37z M9.75,3.7C9.3254,3.3892,8.8052,3.237,8.28,3.27&#xA;&#x9;H5.79v3.82h2.49c0.5315,0.0326,1.056-0.1351,1.47-0.47c0.3795-0.3947,0.5693-0.9346,0.52-1.48C10.324,4.606,10.1327,4.0763,9.75,3.7&#xA;&#x9;z"/>\n</svg>'
  },
  'parking-garage': {
    label: 'Parking garage',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="parking-garage-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M10.5,10.14c-0.6637,0.4788-1.4732,0.7121-2.29,0.66h-1.9V14h-1.9V5h3.92&#xA;&#x9;c0.7801-0.0414,1.5484,0.2041,2.16,0.69c0.5779,0.5595,0.875,1.3483,0.81,2.15C11.4042,8.6892,11.1088,9.5388,10.5,10.14z M9,6.9&#xA;&#x9;C8.711,6.6881,8.3579,6.5822,8,6.6H6.31v2.65H8c0.3612,0.0191,0.717-0.0947,1-0.32c0.2559-0.2675,0.3867-0.6308,0.36-1&#xA;&#x9;C9.4072,7.5493,9.274,7.1684,9,6.9z M14.41,4.21c0.114-0.2486,0.007-0.5427-0.24-0.66L7.5,0.45l-6.71,3.1&#xA;&#x9;C0.5387,3.666,0.429,3.9637,0.545,4.215C0.661,4.4663,0.9587,4.576,1.21,4.46l0,0L7.5,1.55l6.29,2.9&#xA;&#x9;c0.2486,0.114,0.5427,0.007,0.66-0.24H14.41z"/>\n</svg>'
  },
  pharmacy: {
    label: 'Pharmacy',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="pharmacy-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M9.5,4l1.07-1.54c0.0599,0.0046,0.1201,0.0046,0.18,0c0.6904-0.0004,1.2497-0.5603,1.2494-1.2506&#xA;&#x9;C11.999,0.519,11.4391-0.0404,10.7487-0.04C10.0584-0.0396,9.499,0.5203,9.4994,1.2106c0,0.0131,0.0002,0.0262,0.0006,0.0394&#xA;&#x9;c0,0,0,0.07,0,0.1L7,4H9.5z M12,6V5H3v1l1.5,3.5L3,13v1h9v-1l-1-3.5L12,6z M10,10H8v2H7v-2H5V9h2V7h1v2h2V10z"/>\n</svg>'
  },
  'picnic-site': {
    label: 'Picnic site',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="picnic-site-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect4760" d="M4,3C3.446,3,3,3.446,3,4s0.446,1,1,1h1.2969&#xA;&#x9;L4.6523,7H2.5c-0.554,0-1,0.446-1,1s0.446,1,1,1h1.5098L3.041,12.0098c-0.1284,0.3939,0.0868,0.8173,0.4807,0.9457&#xA;&#x9;s0.8173-0.0868,0.9457-0.4807c0.0005-0.0013,0.0009-0.0027,0.0013-0.004L5.5859,9h3.8281l1.1172,3.4707&#xA;&#x9;c0.1273,0.3943,0.5501,0.6107,0.9443,0.4834s0.6107-0.5501,0.4834-0.9443l0,0L10.9902,9H12.5c0.554,0,1-0.446,1-1s-0.446-1-1-1&#xA;&#x9;h-2.1523L9.7031,5H11c0.554,0,1-0.446,1-1s-0.446-1-1-1H4z M6.873,5H8.127l0.6445,2h-2.543L6.873,5z"/>\n</svg>'
  },
  pitch: {
    label: 'Pitch',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="pitch-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M5,3C4.4477,3,4,2.5523,4,2s0.4477-1,1-1s1,0.4477,1,1S5.5523,3,5,3z M12.5,10H10L9,7L8,5.25L9,5l2.3,1l0,0&#xA;&#x9;c0.2761,0.1105,0.5895-0.0239,0.7-0.3S11.9761,5.1105,11.7,5l0,0L9,4H7L5,5L4,6H2.5C2.2239,6,2,6.2239,2,6.5S2.2239,7,2.5,7H5l1-1&#xA;&#x9;l1,2l-2,2v3.5C5,13.7761,5.2239,14,5.5,14S6,13.7761,6,13.5v-3.11L8,9l1,2h3.5c0.2761,0,0.5-0.2239,0.5-0.5S12.7761,10,12.5,10z"/>\n</svg>'
  },
  'place-of-worship': {
    label: 'Place of worship',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="place-of-worship-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path9064" d="M7.5,0l-2,2v2h4V2&#xA;&#x9;L7.5,0z M5.5,4.5L4,6h7L9.5,4.5H5.5z M2,6.5c-0.5523,0-1,0.4477-1,1V13h2V7.5C3,6.9477,2.5523,6.5,2,6.5z M4,6.5V13h7V6.5H4z&#xA;&#x9; M13,6.5c-0.5523,0-1,0.4477-1,1V13h2V7.5C14,6.9477,13.5523,6.5,13,6.5z"/>\n</svg>'
  },
  playground: {
    label: 'Playground',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="playground-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M2,1.15c0.2091-0.8016,1.0284-1.2819,1.83-1.0729s1.2819,1.0284,1.0729,1.83C4.7026,2.6752,3.9386,3.1542,3.16,3&#xA;&#x9;C2.3474,2.839,1.8191,2.0498,1.98,1.2371C1.9858,1.2079,1.9925,1.1788,2,1.15z M13,12.32c0.1032,0.5426-0.2531,1.066-0.7956,1.1692&#xA;&#x9;c-0.0015,0.0003-0.0029,0.0006-0.0044,0.0008c-0.4252,0.086-0.8574-0.1119-1.07-0.49l0,0L9.45,9.63L8,9.92L7.78,10H7.72v2.15&#xA;&#x9;L8.34,12h0.14c0.2871,0.0054,0.5155,0.2425,0.5101,0.5297C8.9862,12.7361,8.8606,12.9207,8.67,13l-5,1l0,0&#xA;&#x9;c-0.0563,0.0095-0.1137,0.0095-0.17,0c-0.2872,0-0.52-0.2328-0.52-0.52c0-0.2099,0.1262-0.3993,0.32-0.48l0,0l4.15-0.83V10&#xA;&#x9;l-3.22,0.58l0,0c-0.164,0.0423-0.336,0.0423-0.5,0c-0.3394-0.0867-0.6088-0.3446-0.71-0.68H3L2,5.83l0,0&#xA;&#x9;C1.9688,5.6884,1.9688,5.5416,2,5.4c0.0936-0.387,0.4078-0.6815,0.8-0.75l0,0l4.7-0.52V0h0.22v4.1h0.06L8,4.08L8.4,4h0.21&#xA;&#x9;c0.2673,0.0643,0.4326,0.3323,0.37,0.6C8.9361,4.835,8.729,5.0041,8.49,5L8,5.08H7.78H7.72v2.86h0.06L8,7.88l1.81-0.36l0,0l0,0&#xA;&#x9;c0.4275-0.0352,0.8299,0.2062,1,0.6l0,0l2,3.94l0,0C12.887,12.1358,12.9511,12.2236,13,12.32z M7.5,5.13L5,5.4l0.74,2.94L7.5,8V5.13&#xA;&#x9;z"/>\n</svg>'
  },
  police: {
    label: 'Police',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="police-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect4718" d="M5.5,1L6,2h5l0.5-1H5.5z M6,2.5v1.25c0,0,0,2.75,2.5,2.75S11,3.75,11,3.75V2.5H6z M1.9844,3.9863&#xA;&#x9;C1.4329,3.9949,0.9924,4.4485,1,5v4c-0.0001,0.6398,0.5922,1.1152,1.2168,0.9766L5,9.3574V14l5.8789-6.9297&#xA;&#x9;C10.7391,7.0294,10.5947,7,10.4414,7H6.5L3,7.7539V5C3.0077,4.4362,2.5481,3.9775,1.9844,3.9863z M11.748,7.7109L6.4121,14H12&#xA;&#x9;V8.5586C12,8.2451,11.9061,7.9548,11.748,7.7109z"/>\n</svg>'
  },
  post: {
    label: 'Post',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="post-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M14,6.5V12c0,0.5523-0.4477,1-1,1H2c-0.5523,0-1-0.4477-1-1V6.5C1,6.2239,1.2239,6,1.5,6&#xA;&#x9;c0.0692-0.0152,0.1408-0.0152,0.21,0l0,0l5.79,4l5.8-4l0,0c0.066-0.0138,0.134-0.0138,0.2,0C13.7761,6,14,6.2239,14,6.5z M1.25,3.92&#xA;&#x9;L1.25,3.92L1.33,4L7.5,8l6.19-4l0,0h0.06l0,0c0.1796-0.0981,0.2792-0.2975,0.25-0.5C14,3.2239,13.7761,3,13.5,3h-12&#xA;&#x9;C1.2239,3,1,3.2239,1,3.5C1.0026,3.6745,1.0978,3.8345,1.25,3.92z"/>\n</svg>'
  },
  prison: {
    label: 'Prison',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="prison-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect3607" d="M3.5,1v13H12V1H3.5z M9.5,2H11v3.5H9.5V2z M4.5,2.0547H6V7H4.5V2.0547z M7,2.0547h1.5V7H7V2.0547z M10.25,6.5&#xA;&#x9;C10.6642,6.5,11,6.8358,11,7.25S10.6642,8,10.25,8l0,0C9.8358,8,9.5,7.6642,9.5,7.25l0,0C9.5,6.8358,9.8358,6.5,10.25,6.5z M7,8&#xA;&#x9;h1.4727L8.5,13H7.0273L7,8z M4.5,8.166H6V13H4.5V8.166z M9.5,9H11v4H9.5V9z"/>\n</svg>'
  },
  rail: {
    label: 'Rail',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" version="1.1" id="rail-15" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M 3 1 C 2.4477 1 2 1.4477 2 2 L 2 10 C 2 10.5523 2.4477 11 3 11 L 12 11 C 12.5523 11 13 10.5523 13 10 L 13 2 C 13 1.4477 12.5523 1 12 1 L 3 1 z M 5.75 1.5 L 5.7597656 1.5 L 9.2597656 1.5 C 9.3978656 1.5 9.5097656 1.6119 9.5097656 1.75 C 9.5097656 1.8881 9.3978656 2 9.2597656 2 L 5.75 2 C 5.6119 2 5.5 1.8881 5.5 1.75 C 5.5 1.6119 5.6119 1.5 5.75 1.5 z M 3.5 3 L 7 3 L 7 7 L 3.5 7 C 3.2239 7 3 6.7761 3 6.5 L 3 3.5 C 3 3.2239 3.2239 3 3.5 3 z M 8 3 L 11.5 3 C 11.7761 3 12 3.2239 12 3.5 L 12 6.5 C 12 6.7761 11.7761 7 11.5 7 L 8 7 L 8 3 z M 5 8 C 5.5523 8 6 8.4477 6 9 C 6 9.5523 5.5523 10 5 10 C 4.4477 10 4 9.5523 4 9 C 4 8.4477 4.4477 8 5 8 z M 10 8 C 10.5523 8 11 8.4477 11 9 C 11 9.5523 10.5523 10 10 10 C 9.4477 10 9 9.5523 9 9 C 9 8.4477 9.4477 8 10 8 z M 10.445312 11.994141 C 10.380597 11.999652 10.314981 12.018581 10.253906 12.050781 C 10.030606 12.168381 9.9302313 12.433922 10.019531 12.669922 L 10.189453 13 L 4.8105469 13 L 4.9394531 12.730469 C 5.0371531 12.472169 4.9067375 12.183637 4.6484375 12.085938 C 4.4124375 11.996738 4.1468969 12.097113 4.0292969 12.320312 L 3.0292969 14.320312 C 3.0080969 14.377912 2.9986 14.4387 3 14.5 C 3 14.7761 3.2239 15 3.5 15 C 3.6802 14.999 3.8450875 14.899434 3.9296875 14.740234 L 3.9296875 14.689453 L 4 14.689453 L 4.3105469 14 L 10.689453 14 L 11 14.689453 L 11 14.740234 C 11.0846 14.899434 11.249488 14.999 11.429688 15 C 11.705787 15 11.929688 14.7761 11.929688 14.5 C 11.949587 14.4212 11.949587 14.338566 11.929688 14.259766 L 10.929688 12.259766 C 10.833163 12.076541 10.639459 11.977608 10.445312 11.994141 z " id="path3"/>\n</svg>'
  },
  'rail-light': {
    label: 'Rail light',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="rail-light-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path14245" d="M5.5,0C5,0,5,0.5,5,0.5v1C5,1.777,5.223,2,5.5,2S6,1.777,6,1.5V1h1v2H6c0,0-2,0-2,2v3c0,3,3,3,3,3h1&#xA;&#x9;c0,0,3,0,3-3V5c0-2-2-2-2-2H8V1h1v0.5C9,1.777,9.223,2,9.5,2S10,1.777,10,1.5v-1C10,0,9.5,0,9.5,0H5.5z M7.5,4l2.0449,0.7734L10,6.5&#xA;&#x9;C10.1316,7,9.5,7,9.5,7h-4c0,0-0.6316,0-0.5-0.5l0.4551-1.7266L7.5,4z M7.5,8C7.7761,8,8,8.2239,8,8.5S7.7761,9,7.5,9&#xA;&#x9;S7,8.7761,7,8.5S7.2239,8,7.5,8z M4.125,12L3,15h1.5l0.375-1h5.25l0.375,1H12l-1.125-3h-1.5l0.375,1h-4.5l0.375-1H4.125z"/>\n</svg>'
  },
  'rail-metro': {
    label: 'Rail metro',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="rail-metro-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path5258" d="M5.5,0c0,0-0.75,0-1,1L3,6.5V10c0,1,1,1,1,1h7c0,0,1,0,1-1V6.5L10.5,1c-0.2727-1-1-1-1-1H5.5z M6.5,1.5h2&#xA;&#x9;c0,0,0.5357,0,0.75,1L10,6c0.2146,1.0017-1,1-1,1H6c0,0-1.2146,0.0017-1-1l0.75-3.5C5.9643,1.5,6.5,1.5,6.5,1.5z M5,8&#xA;&#x9;c0.5523,0,1,0.4477,1,1s-0.4477,1-1,1S4,9.5523,4,9S4.4477,8,5,8z M6.75,8h1.5C8.3885,8,8.5,8.1115,8.5,8.25S8.3885,8.5,8.25,8.5&#xA;&#x9;h-1.5C6.6115,8.5,6.5,8.3885,6.5,8.25S6.6115,8,6.75,8z M10,8c0.5523,0,1,0.4477,1,1s-0.4477,1-1,1S9,9.5523,9,9S9.4477,8,10,8z&#xA;&#x9; M4.125,12L3,15h1.5l0.375-1h5.25l0.375,1H12l-1.125-3h-1.5l0.375,1h-4.5l0.375-1H4.125z"/>\n</svg>'
  },
  'ranger-station': {
    label: 'Ranger station',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="ranger-station-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect4911" d="M9,0.5l-2,1v3.7734L2,8v6h4v-4h3&#xA;&#x9;v4h4V8L8,5.2734V4l1-0.5l2,1l2-1v-3l-2,1L9,0.5z"/>\n</svg>'
  },
  recycling: {
    label: 'Recycling',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="recycling-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M2.4556,8.6134C2.118,9.2112,1.501,10.3021,2.593,11.0312c0.3432,0.2268,0.7275,0.3836,1.131,0.4614&#xA;&#x9;C4.0314,11.5382,4.0466,12.0111,3.6855,12c-0.3849-0.0193-2.2596-0.1934-2.5606-1.5995c-0.1556-0.8213,0.0204-1.5571,0.504-2.3556&#xA;&#x9;L2.3263,6.812L1.0196,6.0688L4.5,4v4L3.1941,7.3057L2.4556,8.6134z M6.7,2.034c1.155-0.628,1.823,0.43,2.191,1.007l0.8059,1.2631&#xA;&#x9;L8.431,5.112L12,6.986L11.803,2.96l-1.2639,0.8066L9.779,2.578C9.2572,1.8321,8.875,1.2812,7.944,1.033&#xA;&#x9;C6.307,0.7203,5.3007,2.6194,5.311,2.607c-0.1639,0.2871,0.2156,0.5399,0.451,0.21C6.0202,2.4969,6.339,2.2309,6.7,2.034z&#xA;&#x9; M13.294,8.221c-0.0877-0.1897-0.5487-0.1413-0.419,0.267c0.1312,0.3892,0.1845,0.8003,0.157,1.21C12.939,11.01,11.684,11,11,11H9.5&#xA;&#x9;V9.5l-3.5,2l3.488,2.025L9.4926,12H11c0.8906,0.0153,1.5999-0.1759,2.2-0.713C14.4,10.226,13.294,8.221,13.294,8.221z"/>\n</svg>'
  },
  'religious-buddhist': {
    label: 'Religious buddhist',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15" id="religious-buddhist-15">\n  <path d="M13.4978,6.9989h-0.5329c-0.09997-1.10708-0.53528-2.15731-1.2478-3.0105l0.378-0.3784&#xA;&#x9;c0.19605-0.19447,0.19733-0.51105,0.00286-0.7071C11.90698,2.71037,11.59733,2.70518,11.4,2.8912l0,0l-0.0123,0.0123L11.01,3.2815&#xA;&#x9;c-0.85331-0.71298-1.90385-1.14864-3.0113-1.2488V1.5c0-0.27614-0.22386-0.5-0.5-0.5s-0.5,0.22386-0.5,0.5v0.5327&#xA;&#x9;C5.8916,2.13306,4.84144,2.56871,3.9884,3.2815L3.61,2.9C3.41007,2.70952,3.09358,2.71717,2.9031,2.9171&#xA;&#x9;c-0.184,0.19312-0.184,0.49668,0,0.6898l0.3784,0.3775C2.56787,4.83856,2.13216,5.89031,2.0327,6.9989H1.5&#xA;&#x9;c-0.27614,0-0.5,0.22386-0.5,0.5s0.22386,0.5,0.5,0.5h0.5327c0.09987,1.10695,0.535,2.15711,1.2473,3.0103l-0.3779,0.3779&#xA;&#x9;c-0.19538,0.19514-0.19557,0.51173-0.00043,0.70711c0.19053,0.19076,0.49798,0.19611,0.69503,0.01209L3.609,12.094l0.3779-0.3779&#xA;&#x9;c0.8533,0.71312,1.90395,1.1488,3.0115,1.2488v0.5329c0,0.27614,0.22386,0.5,0.5,0.5s0.5-0.22386,0.5-0.5v-0.5329&#xA;&#x9;c1.10719-0.10026,2.15744-0.53592,3.0105-1.2488l0.3779,0.3779c0.19514,0.19538,0.51173,0.19557,0.70711,0.00043&#xA;&#x9;c0.19076-0.19053,0.19611-0.49798,0.01209-0.69503l-0.0123-0.0123l0,0l-0.3779-0.3779c0.71283-0.8531,1.14848-1.90333,1.2488-3.0105&#xA;&#x9;h0.5329c0.27609-0.00544,0.49549-0.23366,0.49006-0.50975C13.98227,7.22064,13.76611,7.00435,13.4978,6.9989z M7.9987,3.0505&#xA;&#x9;c0.83871,0.09248,1.63383,0.42154,2.2926,0.9488l-2.15,2.15c-0.04663-0.0218-0.09436-0.04116-0.143-0.058V3.0505H7.9987z&#xA;&#x9; M6.9987,3.0505V6.091c-0.04864,0.01684-0.09637,0.0362-0.143,0.058l-2.15-2.15c0.65897-0.52726,1.45431-0.85622,2.2932-0.9485&#xA;&#x9;H6.9987z M3.9987,4.7062l2.15,2.15c-0.0218,0.04663-0.04116,0.09436-0.058,0.143H3.0505&#xA;&#x9;c0.09243-0.83886,0.42154-1.63413,0.9489-2.293L3.9987,4.7062z M3.0505,7.9987H6.091c0.01687,0.04863,0.03623,0.09636,0.058,0.143&#xA;&#x9;l-2.15,2.15C3.47173,9.63281,3.14276,8.83753,3.0505,7.9987z M6.9989,11.9471c-0.83871-0.09248-1.63383-0.42154-2.2926-0.9488&#xA;&#x9;l2.15-2.15c0.04663,0.0218,0.09436,0.04116,0.143,0.058v3.0405L6.9989,11.9471z M7.9989,11.9471V8.9066&#xA;&#x9;c0.04864-0.01683,0.09638-0.03619,0.143-0.058l2.15,2.15c-0.65895,0.5273-1.4543,0.85627-2.2932,0.9485H7.9989z M10.9989,10.2914&#xA;&#x9;l-2.15-2.15c0.02177-0.04664,0.04113-0.09437,0.058-0.143h3.0415c-0.09276,0.83901-0.42232,1.6343-0.9502,2.293H10.9989z&#xA;&#x9; M8.9066,6.9989c-0.01684-0.04864-0.0362-0.09637-0.058-0.143l2.15-2.15c0.52726,0.65877,0.85632,1.45389,0.9488,2.2926H8.9066&#xA;&#x9;V6.9989z"/>\n</svg>'
  },
  'religious-christian': {
    label: 'Religious christian',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="religious-christian-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect3338" d="M6,0.9552V4H3v3h3v8h3V7h3V4H9V1&#xA;&#x9;c0-1-0.9776-1-0.9776-1H6.9887C6.9887,0,6,0,6,0.9552z"/>\n</svg>'
  },
  'religious-jewish': {
    label: 'Religious jewish',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="religious-jewish-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M15,12H9.78L7.5,15l-2.26-3H0l2.7-4L0,4h5.3l2.2-4l2.34,4H15l-2.56,4L15,12z"/>\n</svg>'
  },
  'religious-muslim': {
    label: 'Religious muslim',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="religious-muslim-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path7552-2-1" d="M6.7941,0C3,0,0,3,0,6.7941&#xA;&#x9;s3,6.7941,6.7941,6.7941c2.1176,0,4.4118-0.7059,5.6471-2.2941C11.6471,11.8235,10.1471,12.4412,9,12.4412&#xA;&#x9;c-2.9118,0-5.1176-2.9118-5.1176-5.8235S6.0882,1.1471,9,1.1471c1.0588,0,2.5588,0.6176,3.4412,1.1471&#xA;&#x9;C11.2059,0.7059,8.9118,0,6.7941,0z M11,3l-1,2.5H7L9.5,7l-1,3L11,8.5l2.5,1.5l-1-3L15,5.5h-3L11,3z"/>\n</svg>'
  },
  'residential-community': {
    label: 'Residential community',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="residential-community-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11.8,13.5V11c0.7-0.1,1.2-0.7,1.2-1.5S12.3,8,11.5,8S10,8.7,10,9.5c0,0.7,0.5,1.4,1.2,1.5v2.5H7V2H2v11.5H1V14h13v-0.5&#xA;&#x9;H11.8z M6,11H3v-1h3V11z M6,9H3V8h3V9z M6,7H3V6h3V7z M6,5H3V4h3V5z"/>\n</svg>'
  },
  restaurant: {
    label: 'Restaurant',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="restaurant-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path11774" d="M3.5,0l-1,5.5c-0.1464,0.805,1.7815,1.181,1.75,2L4,14c-0.0384,0.9993,1,1,1,1s1.0384-0.0007,1-1L5.75,7.5&#xA;&#x9;c-0.0314-0.8176,1.7334-1.1808,1.75-2L6.5,0H6l0.25,4L5.5,4.5L5.25,0h-0.5L4.5,4.5L3.75,4L4,0H3.5z M12,0&#xA;&#x9;c-0.7364,0-1.9642,0.6549-2.4551,1.6367C9.1358,2.3731,9,4.0182,9,5v2.5c0,0.8182,1.0909,1,1.5,1L10,14c-0.0905,0.9959,1,1,1,1&#xA;&#x9;s1,0,1-1V0z"/>\n</svg>'
  },
  'restaurant-noodle': {
    label: 'Restaurant noodle',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="restaurant-noodle-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <g id="restaurant-noodle-15">\n    <path d="M4.457,11.9892,1,8V7H14V8l-3.4961,3.9891ZM3.9882,2.5a.5.5,0,0,0-1,0v.5671l-1.7969.3675a.25.25,0,1,0,.094.4911l1.7029-.2776v.5662l-1.75.0357a.25.25,0,0,0,0,.5l1.75.0357V5.998h1Zm9.5,1.5-7.5.2625V2.9951l7.594-1.0737a.5.5,0,0,0-.1881-.9822L5.9792,2.4555a.4963.4963,0,0,0-.991.0445v.2276l-.493.1009V3.18l.493-.08V4.2974l-.493.01v.4608L13.4882,5a.5.5,0,0,0,0-1ZM10,13H5v.5757h5Z"/>\n  </g>\n</svg>'
  },
  'restaurant-pizza': {
    label: 'Restaurant pizza',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="restaurant-pizza-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <g id="restaurant-pizza-15">\n    <path d="M2.3926,8.9315,1.0245,8.3148A14.0478,14.0478,0,0,1,8.7637.9994l.027.07L9.3022,2.4l-.0037.0013a12.6131,12.6131,0,0,0-6.9057,6.53Zm10.9631,4.96L3.42,9.413a11.6038,11.6038,0,0,1,6.354-6.0088l.0033-.0013.8163,2.1222c-.0281-.0022-.0521-.0162-.0808-.0162a1.062,1.062,0,1,0,.7642,1.7932L13.69,13.575A.2487.2487,0,0,1,13.3557,13.891Zm-4.93-5.3727a.9245.9245,0,1,0-.9245.9244A.9245.9245,0,0,0,8.4255,8.5183Zm3.0169,2.03a.9252.9252,0,1,0-.9252.9252A.9252.9252,0,0,0,11.4424,10.5478Z"/>\n  </g>\n</svg>'
  },
  'restaurant-seafood': {
    label: 'Restaurant seafood',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="restaurant-seafood-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <g id="restaurant-seafood-15">\n    <path d="M11.433,10.0889h2.49v.75H11.8525A4.81,4.81,0,0,1,13.4751,13.14l-.71.2422a4.01,4.01,0,0,0-1.74-2.1971,1.7775,1.7775,0,0,1-1.0352.4538L8.4374,12.9852H6.5188L4.9839,11.623a2.0222,2.0222,0,0,1-1.0929-.44,4.0093,4.0093,0,0,0-1.7426,2.1988l-.71-.2422a4.8146,4.8146,0,0,1,1.622-2.3007H.99v-.75H3.4839l.8633-.6764L3.3329,7.7567a2.2738,2.2738,0,0,1-.269.0293,2.0192,2.0192,0,0,1-2.0532-2.08c0-2.08,1.979-4.16,1.979-4.16L2.2531,5.9931l1.7255-.0012L4.9913,2.9852l0,2.9956a2.0936,2.0936,0,0,1-.6993,1.4121l.8536,1.3936L5.23,8.7208a3.8669,3.8669,0,0,1,4.4784,0l.0605.0474.869-1.4152a2.1177,2.1177,0,0,1-.6433-1.3722l0-2.9956.9836,3.0067,1.7547.0012-.7367-4.4466s1.982,2.08,1.982,4.16a2.0211,2.0211,0,0,1-2.0562,2.08,2.3125,2.3125,0,0,1-.3441-.0376L10.5676,9.3945l.8407.6593C11.4212,10.0638,11.4218,10.0782,11.433,10.0889Z"/>\n  </g>\n</svg>'
  },
  roadblock: {
    label: 'Roadblock',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="roadblock-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="roadblock-24" d="M7.5,0C3.3579,0,0,3.3579,0,7.5S3.3579,15,7.5,15S15,11.6421,15,7.5S11.6421,0,7.5,0z M3,6h9v3H3V6z"/>\n</svg>'
  },
  rocket: {
    label: 'Rocket',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="rocket-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path7143" d="M12.5547,1c-2.1441,0-5.0211,1.471-6.9531,4H4&#xA;&#x9;C2.8427,5,2.1794,5.8638,1.7227,6.7773L1.1113,8h1.4434H4l1.5,1.5L7,11v1.4453v1.4434l1.2227-0.6113&#xA;&#x9;C9.1362,12.8206,10,12.1573,10,11V9.3984c2.529-1.932,4-4.809,4-6.9531V1H12.5547z M10,4c0.5523,0,1,0.4477,1,1l0,0&#xA;&#x9;c0,0.5523-0.4477,1-1,1l0,0C9.4477,6,9,5.5523,9,5v0C9,4.4477,9.4477,4,10,4L10,4z M3.5,10L3,10.5C2.2778,11.2222,2,13,2,13&#xA;&#x9;s1.698-0.198,2.5-1L5,11.5L3.5,10z"/>\n</svg>'
  },
  school: {
    label: 'School',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="school-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11,13v-1h2v-1H9.5v-1H13V9h-2V8h2V7h-2V6h2V5H9.5V4H13V3h-2V2h2V1H8v13h5v-1H11z M6,11H2V1h4V11z M6,12l-2,2l-2-2H6z"/>\n</svg>'
  },
  scooter: {
    label: 'Scooter',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="scooter-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M4.908,12a1.5,1.5,0,1,1-2.816,0Zm8.65-6C13.539,6,13,6,13,6V3h.351a.282.282,0,0,0,.223-.148l.268-.536a.334.334,0,0,0,.009-.066A.25.25,0,0,0,13.6,2H13V1.7a.215.215,0,0,0-.2-.2H9.25a.25.25,0,0,0,0,.5H12V6.6L7.6,10H6V7.5A.5.5,0,0,0,5.5,7H5V5H6.75a.25.25,0,0,0,0-.5L2.266,4.034c-.006,0-.01-.007-.016-.007a.25.25,0,0,0-.25.25V4.75A.25.25,0,0,0,2.25,5H3V7H2.5A1.538,1.538,0,0,0,1,8.5v2a.472.472,0,0,0,.442.5C1.461,11,7.5,11,7.5,11L10,10h3.5a.472.472,0,0,0,.5-.442C14,9.539,14,6.5,14,6.5A.472.472,0,0,0,13.558,6ZM12.5,11A1.5,1.5,0,1,0,14,12.5,1.538,1.538,0,0,0,12.5,11Z"/>\n</svg>'
  },
  shelter: {
    label: 'Shelter',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="shelter-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M4,7v5h9.5v2H2l0,0l0,0V7.78L1,8.16V6l13-5v2.14L4,7z"/>\n</svg>'
  },
  shoe: {
    label: 'Shoe',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="shoe-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <g>\n    <path d="M9.5,7C9.086,6.7652,8.6109,6.4041,8.1848,6.0524l-2.1743-2.831C5.8204,2.9729,5.4644,2.927,5.2227,3.1172&#xA;&#x9;&#x9;C5.0977,3.214,5.0262,3.3536,5.0097,3.5H5V5H3.2087C3.0751,5,2.9469,4.9469,2.8524,4.8524C2.8524,4.8524,2.5,4,2,4&#xA;&#x9;&#x9;S1.4997,4,1.4997,4C1.2238,4,1,4.2237,1,4.4997V6.25v0.634V9h5.5c1.5,0,2,1,3.5,1s4,0,4,0V9.5C14,8,10.5469,7.5938,9.5,7z"/>\n    <path d="M9.5,11c-0.6318,0-1.0469-0.207-1.5264-0.4473C7.4556,10.2939,6.8682,10,6,10H1.5004H1v1.4996&#xA;&#x9;&#x9;C1,11.7759,1.224,12,1.5004,12h3.9993C5.776,12,6,11.7759,6,11.4996V11c0.6318,0,1.0464,0.207,1.5264,0.4473&#xA;&#x9;&#x9;C8.0449,11.7061,8.6318,12,9.5,12h4c0.2764,0,0.5-0.2236,0.5-0.5V11H9.5z"/>\n  </g>\n</svg>'
  },
  shop: {
    label: 'Shop',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="shop-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.33,6H11.5l-0.39-2.33c-0.1601-0.7182-0.7017-1.2905-1.41-1.49C9.3507,2.0676,8.9869,2.007,8.62,2H6.38&#xA;&#x9;C6.0131,2.007,5.6493,2.0676,5.3,2.18C4.5917,2.3795,4.0501,2.9518,3.89,3.67L3.5,6H1.67C1.3939,5.9983,1.1687,6.2208,1.167,6.497&#xA;&#x9;C1.1667,6.5489,1.1744,6.6005,1.19,6.65l1.88,6.3l0,0C3.2664,13.5746,3.8453,13.9996,4.5,14h6c0.651-0.0047,1.2247-0.4289,1.42-1.05&#xA;&#x9;l0,0l1.88-6.3c0.0829-0.2634-0.0635-0.5441-0.3269-0.627C13.4268,6.0084,13.3786,6.0007,13.33,6z M4.52,6l0.36-2.17&#xA;&#x9;c0.0807-0.3625,0.3736-0.6395,0.74-0.7C5.8663,3.0524,6.1219,3.0087,6.38,3h2.24c0.2614,0.0078,0.5205,0.0515,0.77,0.13&#xA;&#x9;c0.3664,0.0605,0.6593,0.3375,0.74,0.7L10.48,6h-6H4.52z"/>\n</svg>'
  },
  skateboard: {
    label: 'Skateboard',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="skateboard-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="icon_concepts:_sports_leisure" d="M11,8H4A2.0024,2.0024,0,0,1,2,6H3A1.001,1.001,0,0,0,4,7h7a1.001,1.001,0,0,0,1-1h1A2.0024,2.0024,0,0,1,11,8Zm0,1a1,1,0,1,0,1,1A1,1,0,0,0,11,9ZM4,9a1,1,0,1,0,1,1A1,1,0,0,0,4,9Z"/>\n</svg>'
  },
  skiing: {
    label: 'Skiing',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="skiing-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M15,4.5C15,5.3284,14.3284,6,13.5,6S12,5.3284,12,4.5S12.6716,3,13.5,3S15,3.6716,15,4.5z M13.72,11.89&#xA;&#x9;c-0.0623-0.1197-0.2083-0.1684-0.33-0.11c-0.6846,0.4194-1.5208,0.5111-2.28,0.25L4.78,8.86L7.5,7.5v-3L9,5.25v3L10.5,9L12,8.25&#xA;&#x9;L10.5,7.5V3l-3-1.5L6,2.25v4.5L3.28,8.11L0.61,6.78C0.4857,6.7192,0.3358,6.7707,0.275,6.895C0.2142,7.0193,0.2657,7.1692,0.39,7.23&#xA;&#x9;l10.5,5.25c0.3156,0.135,0.6568,0.1998,1,0.19c0.5998-0.0103,1.1889-0.161,1.72-0.44c0.1236-0.0615,0.174-0.2116,0.1125-0.3352&#xA;&#x9;C13.7217,11.8932,13.7208,11.8916,13.72,11.89z"/>\n</svg>'
  },
  slaughterhouse: {
    label: 'Slaughterhouse',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="slaughterhouse-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M15,8.1c0,1.376-1.363.694-1.363.694L12.5,9H11a5.309,5.309,0,0,1-1.5,2,3.272,3.272,0,0,1-.523,1.125c-.077.091-.061.2-.068.33L9,14.755a.264.264,0,0,1-.266.25A.242.242,0,0,1,8.5,14.8L8,11.5H4v3.253A.247.247,0,0,1,3.753,15h0a.25.25,0,0,1-.241-.2L3,12v-.5a8.2,8.2,0,0,1-1.426-.1A1.886,1.886,0,0,1,.9,12.826c-.128.083-.148.211-.133.386,0,0,.19,1.532.19,1.538a.25.25,0,0,1-.25.25.238.238,0,0,1-.23-.174l-.427-1.7a.35.35,0,0,1,.055-.3c.437-.68-.049-2.55-.049-2.55A1.354,1.354,0,0,1,0,9.922V7.5A2.027,2.027,0,0,1,2.736,5.586s.1.03.142.049a15.15,15.15,0,0,0,3.814.038l.179-.062a1.842,1.842,0,0,1,1.26,0,.972.972,0,0,1,.227.089,1.994,1.994,0,0,1,.287.171A1.8,1.8,0,0,0,9.5,6h1V5l.5.5c.5-1.5,2.5-1,2.5-1a1.687,1.687,0,0,0-1.5,1l2.5,2a.613.613,0,0,1,.186-.069A.318.318,0,0,1,15,7.752V8.1Z"/>\n</svg>'
  },
  slipway: {
    label: 'Slipway',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="slipway-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <g id="slipway-final">\n    <path d="M1.0417,11l12,1.495V13h-12Zm12-4-1,1v.5833L4.2381,5.3318l.0624-.1248L5.652,3.8447h.8311a.35.35,0,0,0,0-.6992H5.5065a.3518.3518,0,0,0-.248.1025L3.7643,4.7529a.3714.3714,0,0,0-.0654.0909l-.109.218L1.0417,4c0,2-.0293,3.9578,2.8595,4.4994C5.321,8.7656,12.0417,10,12.0417,10l2-2Z"/>\n  </g>\n</svg>'
  },
  snowmobile: {
    label: 'Snowmobile',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" id="snowmobile-15">\n  <path d="M15,11a1,1,0,0,1-1,1l0,0v0H9.4142a1,1,0,0,1-.7071-.2929L7.146,10.146A.4984.4984,0,0,0,6.7935,10H3.3343a1.0023,1.0023,0,0,1-.6015-.2006L1.3857,8.7888A1.0134,1.0134,0,0,1,1,8a.9953.9953,0,0,1,.4719-.8444L5,5,6.0385,3.3076h0A.5.5,0,0,1,7,3.5V7L8,8H9l5.4115-.9922a.5.5,0,0,1,.3555.915L13,9l1.6313,1.2243A.99.99,0,0,1,15,11ZM5.5,11H3.2247a3.0035,3.0035,0,0,1-1.44-.3679L.74,10.0612a.5.5,0,0,0-.48.8775l1.2687.6934A3.0032,3.0032,0,0,0,2.969,12H5.5a.5.5,0,0,0,0-1Z"/>\n</svg>'
  },
  soccer: {
    label: 'Soccer',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="soccer-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11,1.5C11,2.3284,10.3284,3,9.5,3S8,2.3284,8,1.5S8.6716,0,9.5,0S11,0.6716,11,1.5z M11,11c-0.5523,0-1,0.4477-1,1&#xA;&#x9;s0.4477,1,1,1s1-0.4477,1-1S11.5523,11,11,11z M12.84,6.09l-1.91-1.91l0,0C10.8399,4.0675,10.7041,4.0014,10.56,4H3.5&#xA;&#x9;C3.2239,4,3,4.2239,3,4.5S3.2239,5,3.5,5h2.7L3,11.3l0,0c-0.0138,0.066-0.0138,0.134,0,0.2c-0.058,0.2761,0.1189,0.547,0.395,0.605&#xA;&#x9;C3.6711,12.163,3.942,11.9861,4,11.71l0,0L5,10h2l-1.93,4.24l0,0C5.0228,14.3184,4.9986,14.4085,5,14.5&#xA;&#x9;c-0.0552,0.2761,0.1239,0.5448,0.4,0.6c0.2761,0.0552,0.5448-0.1239,0.6-0.4l0,0l4.7-9.38l1.44,1.48&#xA;&#x9;c0.211,0.1782,0.5264,0.1516,0.7046-0.0593C13.0037,6.5523,13.0018,6.2761,12.84,6.09z"/>\n</svg>'
  },
  square: {
    label: 'Square',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="square-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13,14H2c-0.5523,0-1-0.4477-1-1V2c0-0.5523,0.4477-1,1-1h11c0.5523,0,1,0.4477,1,1v11C14,13.5523,13.5523,14,13,14z"/>\n</svg>'
  },
  'square-stroked': {
    label: 'Square stroked',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="square-stroked-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12.7,2.3v10.4H2.3V2.3H12.7 M13,1H2C1.4477,1,1,1.4477,1,2v11c0,0.5523,0.4477,1,1,1h11c0.5523,0,1-0.4477,1-1V2&#xA;&#x9;C14,1.4477,13.5523,1,13,1L13,1z"/>\n</svg>'
  },
  stadium: {
    label: 'Stadium',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="stadium-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path4177" d="M7,1v2v1.5v0.5098C4.1695,5.1037,2.0021,5.9665,2,7v4.5c0,1.1046,2.4624,2,5.5,2s5.5-0.8954,5.5-2V7&#xA;&#x9;c-0.0021-1.0335-2.1695-1.8963-5-1.9902V4.0625L11,2.75L7,1z M3,8.1465c0.5148,0.2671,1.2014,0.4843,2,0.6328v2.9668&#xA;&#x9;C3.7948,11.477,3,11.0199,3,10.5V8.1465z M12,8.1484V10.5c0,0.5199-0.7948,0.977-2,1.2461V8.7812&#xA;&#x9;C10.7986,8.6328,11.4852,8.4155,12,8.1484z M6,8.9219C6.4877,8.973,6.9925,8.9992,7.5,9C8.0073,8.9999,8.5121,8.9743,9,8.9238&#xA;&#x9;v2.9844C8.5287,11.964,8.0288,12,7.5,12S6.4713,11.964,6,11.9082V8.9219z"/>\n</svg>'
  },
  star: {
    label: 'Star',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="star-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path4749-2-8-2" d="M7.5,0l-2,5h-5l4,3.5l-2,6l5-3.5&#xA;&#x9;l5,3.5l-2-6l4-3.5h-5L7.5,0z"/>\n</svg>'
  },
  'star-stroked': {
    label: 'Star stroked',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="star-stroked-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path4749-2-8-2" d="M7.5,3.19l1.07,2.68L8.82,6.5h3l-2,1.75l-0.5,0.44l0.23,0.63l1,3.13l-2.48-1.77&#xA;&#x9;l-0.57-0.4l-0.57,0.4l-2.52,1.77l1-3.13l0.21-0.63l-0.5-0.44l-2-1.75h3l0.25-0.63L7.5,3.19 M7.5,0.5l-2,5h-5l4,3.5l-2,6l5-3.5l5,3.5&#xA;&#x9;l-2-6l4-3.5h-5L7.5,0.5L7.5,0.5z"/>\n</svg>'
  },
  suitcase: {
    label: 'Suitcase',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="suitcase-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path17" d="M11,4V2c0-1-1-1-1-1H5.0497&#xA;&#x9;c0,0-1.1039,0.0015-1.0497,1v2H2c0,0-1,0-1,1v7c0,1,1,1,1,1h11c0,0,1,0,1-1V5c0-1-1-1-1-1H11z M5.5,2.5h4V4h-4V2.5z"/>\n</svg>'
  },
  sushi: {
    label: 'Sushi',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="sushi-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path4999" d="M5.5,3C5.2239,3,5,3.2239,5,3.5H2.75C1.2265,3.5,0,4.7265,0,6.25c0,0.8274,0.3687,1.5592,0.9434,2.0625&#xA;&#x9;C0.3803,8.6675,0,9.2893,0,10c0,1.0994,0.9006,2,2,2h3.5h2H10c1.0994,0,2-0.9006,2-2c0-0.4883-0.1863-0.9294-0.4805-1.2773&#xA;&#x9;l2.1777,0.9629c0.3716,0.1831,0.8213,0.0303,1.0044-0.3413c0.1831-0.3716,0.0303-0.8213-0.3413-1.0044&#xA;&#x9;c-0.0188-0.0093-0.038-0.0178-0.0576-0.0254l-1.8105-0.8027l1.6309-0.2715c0.4099-0.0599,0.6936-0.4408,0.6337-0.8507&#xA;&#x9;c-0.0544-0.3724-0.3765-0.6469-0.7528-0.6415c-0.0426,0.0003-0.085,0.0042-0.127,0.0117l-2.1309,0.3555&#xA;&#x9;C11.2595,4.9521,10.0387,3.7837,8,3.5488V3.5C8,3.2239,7.7761,3,7.5,3H5.5z M6,4h1v5v2H6V9V4z M9.5,8&#xA;&#x9;c0.259,0,0.4638,0.1974,0.4902,0.4492l0.0762-0.1328c0.1385-0.2399,0.4437-0.3201,0.6836-0.1816s0.3201,0.4418,0.1816,0.6816&#xA;&#x9;l-0.2578,0.4473C10.8727,9.445,11,9.7021,11,10c0,0.5626-0.4374,1-1,1H8V9h1V8.5C9,8.223,9.223,8,9.5,8z M2.4395,8.0703&#xA;&#x9;c0.1934-0.0242,0.3903,0.0662,0.4941,0.2461l0.2012,0.3477C3.226,8.5647,3.3538,8.5,3.5,8.5C3.777,8.5,4,8.723,4,9h1v2H2&#xA;&#x9;c-0.5626,0-1-0.4374-1-1s0.4374-1,1-1h0.1738L2.0684,8.8164C1.9299,8.5765,2.0101,8.2733,2.25,8.1348&#xA;&#x9;C2.31,8.1001,2.375,8.0784,2.4395,8.0703z"/>\n</svg>'
  },
  swimming: {
    label: 'Swimming',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="swimming-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path16388" d="M10.1113,2C9.9989,2,9.6758,2.1465,9.6758,2.1465L6.3535,3.8262&#xA;&#x9;C5.9111,4.0024,5.7358,4.7081,6.002,5.0605l0.9707,1.4082L3.002,8.498L5,9.998l2.502-1.5l2.5,1.5l1.002-1.002l-3-4l2.5566-1.5293&#xA;&#x9;c0.5286-0.2662,0.4434-0.7045,0.4434-0.9707C10.9999,2.2861,10.6437,2,10.1113,2z M12.252,5C11.2847,5,10.5,5.7827,10.5,6.75&#xA;&#x9;s0.7847,1.752,1.752,1.752s1.75-0.7847,1.75-1.752S13.2192,5,12.252,5z M2.5,10L0,11.5V13l2.5-1.5L5,13l2.502-1.5l2.5,1.5L12,11.5&#xA;&#x9;l3,1.5v-1.5L12,10l-1.998,1.5l-2.5-1.5L5,11.5L2.5,10z"/>\n</svg>'
  },
  'table-tennis': {
    label: 'Table tennis',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="table-tennis-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="icon_concepts:_sports_leisure" d="M11.9676,10.2275a3.8116,3.8116,0,0,1-1.9122.9831L3.7678,4.9338A4.0283,4.0283,0,0,1,4.7725,3.0324C7.03.7745,9.98.2235,12.3781,2.6219S14.2255,7.97,11.9676,10.2275Zm-6.987,1.6093A3.8422,3.8422,0,0,1,6.149,11.278,4.5328,4.5328,0,0,1,8,11.4452L3.5456,7a4.4126,4.4126,0,0,1,.1572,1.9223,3.6639,3.6639,0,0,1-.5208,1.1159c-1.072,1.263-2.132,1.727-2.132,2.1879A1.8378,1.8378,0,0,0,2.7739,13.95C3.2348,13.95,3.6917,12.9368,4.9806,11.8368Z"/>\n</svg>'
  },
  teahouse: {
    label: 'Teahouse',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="teahouse-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M11,7c-0.2,1.4-0.5,2.7-1,4c-0.3,0.4-0.6,0.7-1,1v2H6v-2c-0.4-0.3-0.7-0.6-1-1C4.5,9.7,4.2,8.4,4,7H11z M8.1,5.7&#xA;&#x9;c1.2-0.3,1.7-0.3,1.8-1.5c0-0.6-0.4-0.8-1.5-1.4C7.5,2.4,7.1,1.8,7.2,1C6.8,1.9,7,3,8,3.5C10,4.5,8.1,5.7,8.1,5.7z M5.8,6&#xA;&#x9;c0.7-0.2,1.1-0.2,1.1-0.9c0-0.4-0.3-0.5-0.9-0.9C5.4,4,5.1,3.5,5.2,3C4.9,3.6,5.1,4.3,5.7,4.6C6.9,5.2,5.8,6,5.8,6z"/>\n</svg>'
  },
  telephone: {
    label: 'Telephone',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" id="telephone-15">\n  <path d="M4.51,8.88a0.51,0.51,0,0,0,0,.72l0.72,0.72L3.07,12.5,2.7,12.13A2.24,2.24,0,0,1,2,10.69V9.24a2.24,2.24,0,0,1,.7-1.45L7.77,2.72A2.24,2.24,0,0,1,9.22,2h1.45a2.24,2.24,0,0,1,1.45.72l0.36,0.36L10.31,5.26,9.58,4.53a0.51,0.51,0,0,0-.72,0ZM4.13,13.6a1,1,0,0,0,1.4137.0363Q5.5623,13.6186,5.58,13.6l0.72-.72a1,1,0,0,0,.0363-1.4137Q6.3186,11.4477,6.3,11.43Zm7.25-7.28a1,1,0,0,0,1.4137.0363C12.8061,6.3445,13.55,5.6,13.55,5.6a1,1,0,0,0,.0363-1.4137Q13.5686,4.1677,13.55,4.15Z"/>\n</svg>'
  },
  tennis: {
    label: 'Tennis',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="tennis-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.1284,1.87c-1.5418-1.5406-4.5535-.7759-6.28,1.05a6.8282,6.8282,0,0,0-1.88,4.4,5.7275,5.7275,0,0,1-.57,2.72.6814.6814,0,0,0-.67.17l-2.49,2.5a.6941.6941,0,0,0,0,.98l.07.07a.7051.7051,0,0,0,.98,0l2.5-2.49a.683.683,0,0,0,.18-.66,8.5694,8.5694,0,0,1,3.12-.58,6.5487,6.5487,0,0,0,3.99-1.87C14.1084,6.13,14.579,3.3194,13.1284,1.87Zm-2.2-.04a2.3071,2.3071,0,0,1,1.64.61,2.548,2.548,0,0,1,.5,2.44l-2.95-2.96A3.8648,3.8648,0,0,1,10.9284,1.83Zm-4.57,6.81a2.6485,2.6485,0,0,1-.48-2.55l3.04,3.04A2.8522,2.8522,0,0,1,6.3584,8.64Zm2.88.39-3.26-3.27a5.1623,5.1623,0,0,1,.49-1.08l3.85,3.85A5.5093,5.5093,0,0,1,9.2384,9.03Zm1.34-.66-3.94-3.95a5.2032,5.2032,0,0,1,.74-.9l4.1,4.1A5.6869,5.6869,0,0,1,10.5784,8.37Zm1.11-.96-4.1-4.1a5.5714,5.5714,0,0,1,.84-.65l3.92,3.92A5.7187,5.7187,0,0,1,11.6884,7.41Zm.82-1.09L8.6984,2.5a4.1707,4.1707,0,0,1,1.09-.48l3.2,3.2A5.5656,5.5656,0,0,1,12.5084,6.32Z"/>\n</svg>'
  },
  theatre: {
    label: 'Theatre',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="theatre-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path6342-3" d="M2,1c0,0-1,0-1,1v5.1582C1,8.8885,1.354,11,4.5,11H5V8L2.5,9c0,0,0-2.5,2.5-2.5V5&#xA;&#x9;c0-0.7078,0.0868-1.3209,0.5-1.7754C5.8815,2.805,6.5046,1.9674,8.1562,2.7539L9,3.3027V2c0,0,0-1-1-1C7.2922,1,6.0224,2,5,2&#xA;&#x9;S2.7865,1,2,1z M3,3c0.5523,0,1,0.4477,1,1S3.5523,5,3,5S2,4.5523,2,4S2.4477,3,3,3z M7,4c0,0-1,0-1,1v5c0,2,1,4,4,4s4-2,4-4V5&#xA;&#x9;c0-1-1-1-1-1c-0.7078,0-1.9776,1-3,1S7.7865,4,7,4z M8,6c0.5523,0,1,0.4477,1,1S8.5523,8,8,8S7,7.5523,7,7S7.4477,6,8,6z M12,6&#xA;&#x9;c0.5523,0,1,0.4477,1,1s-0.4477,1-1,1s-1-0.4477-1-1S11.4477,6,12,6z M7.5,10H10h2.5c0,0,0,2.5-2.5,2.5S7.5,10,7.5,10z"/>\n</svg>'
  },
  toilet: {
    label: 'Toilet',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="toilet-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M4.5,3C3.6716,3,3,2.3284,3,1.5S3.6716,0,4.5,0S6,0.6716,6,1.5S5.3284,3,4.5,3z M14,1.5C14,0.6716,13.3284,0,12.5,0&#xA;&#x9;S11,0.6716,11,1.5S11.6716,3,12.5,3S14,2.3284,14,1.5z M8.86,6.64L8.86,6.64L6.38,4.15l0,0C6.2798,4.0492,6.142,3.9949,6,4H3&#xA;&#x9;C2.8697,4.0003,2.7445,4.0503,2.65,4.14l0,0L0.14,6.63c-0.2261,0.177-0.2659,0.5039-0.0889,0.73s0.5039,0.2659,0.73,0.0889&#xA;&#x9;C0.8142,7.423,0.8441,7.3931,0.87,7.36L3,5.2L1,11h2v3.33c-0.0075,0.0497-0.0075,0.1003,0,0.15&#xA;&#x9;c0.0555,0.2761,0.3244,0.455,0.6005,0.3995C3.802,14.839,3.9595,14.6815,4,14.48l0,0V11h1v3.5l0,0&#xA;&#x9;c0.0555,0.2761,0.3244,0.455,0.6005,0.3995C5.802,14.859,5.9595,14.7015,6,14.5c0.0075-0.0497,0.0075-0.1003,0-0.15V11h2L6,5.2&#xA;&#x9;l2.14,2.16l0,0c0.0967,0.1081,0.2349,0.17,0.38,0.17C8.7954,7.5088,9.0061,7.2761,9,7C9.0023,6.8663,8.9521,6.737,8.86,6.64z&#xA;&#x9; M14.5,4h-4C10.2239,4,10,4.2239,10,4.5v5c0,0.2761,0.2239,0.5,0.5,0.5S11,9.7761,11,9.5v5c0,0.2761,0.2239,0.5,0.5,0.5&#xA;&#x9;s0.5-0.2239,0.5-0.5v-5h1v5c0,0.2761,0.2239,0.5,0.5,0.5s0.5-0.2239,0.5-0.5v-5c0,0.2761,0.2239,0.5,0.5,0.5S15,9.7761,15,9.5v-5&#xA;&#x9;C15,4.2239,14.7761,4,14.5,4z"/>\n</svg>'
  },
  town: {
    label: 'Town',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="town-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M10.651,7.121a.251.251,0,0,0-.314,0L8.092,8.929A.247.247,0,0,0,8,9.122v4.625A.253.253,0,0,0,8.253,14H9.747A.253.253,0,0,0,10,13.747h0V12h1v1.747a.253.253,0,0,0,.253.253h1.494A.253.253,0,0,0,13,13.747h0V9.12a.25.25,0,0,0-.094-.2ZM10,11H9V10h1Zm2,0H11V10h1ZM5.71,1.815a.252.252,0,0,0-.42,0L2.042,5.936A.252.252,0,0,0,2,6.076v7.671A.252.252,0,0,0,2.251,14h2.5A.252.252,0,0,0,5,13.748V12H6v1.748A.252.252,0,0,0,6.252,14H7V8a.5.5,0,0,1,.188-.391L9,6C9,5.95,5.71,1.815,5.71,1.815ZM4,10H3V9H4ZM4,7H3V6H4Zm2,3H5V9H6ZM6,7H5V6H6Z"/>\n</svg>'
  },
  'town-hall': {
    label: 'Town hall',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="town-hall-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path7509" d="M7.5,0L1,3.4453V4h13V3.4453L7.5,0z M2,5v5l-1,1.5547V13h13v-1.4453L13,10V5H2z M4,6h1v5.5H4V6z M7,6h1v5.5H7&#xA;&#x9;V6z M10,6h1v5.5h-1V6z"/>\n</svg>'
  },
  triangle: {
    label: 'Triangle',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="triangle-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path21090-9" d="M7.5385,2&#xA;&#x9;C7.2437,2,7.0502,2.1772,6.9231,2.3846l-5.8462,9.5385C1,12,1,12.1538,1,12.3077C1,12.8462,1.3846,13,1.6923,13h11.6154&#xA;&#x9;C13.6923,13,14,12.8462,14,12.3077c0-0.1538,0-0.2308-0.0769-0.3846L8.1538,2.3846C8.028,2.1765,7.7882,2,7.5385,2z"/>\n</svg>'
  },
  'triangle-stroked': {
    label: 'Triangle stroked',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="triangle-stroked-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="rect3338" d="M7.5243,1.5004&#xA;&#x9;C7.2429,1.4913,6.9787,1.6423,6.8336,1.8952l-5.5,9.8692C1.0218,12.3078,1.395,12.9999,2,13h11&#xA;&#x9;c0.605-0.0001,0.9782-0.6922,0.6664-1.2355l-5.5-9.8692C8.0302,1.6579,7.7884,1.5092,7.5243,1.5004z M7.5,3.8993l4.1267,7.4704&#xA;&#x9;H3.3733L7.5,3.8993z"/>\n</svg>'
  },
  veterinary: {
    label: 'Veterinary',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="veterinary-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path3340" d="M7.5,6c-2.5,0-3,2.28-3,3.47l0,0c-0.6097,0.2059-1.1834,0.5062-1.7,0.89&#xA;&#x9;c-0.871,0.6614-1.0492,1.8998-0.4,2.78c0.6799,0.8542,1.9081,1.0297,2.8,0.4c0.6779-0.4601,1.4808-0.701,2.3-0.69&#xA;&#x9;c0.8192-0.011,1.6221,0.2299,2.3,0.69c0.8575,0.6854,2.1072,0.5515,2.8-0.3c0.6888-0.8134,0.5878-2.0313-0.2256-2.7201&#xA;&#x9;c-0.0243-0.0206-0.0491-0.0406-0.0744-0.0599l-0.1-0.1c-0.5333-0.3564-1.1032-0.6548-1.7-0.89l0,0C10.5,8.29,10,6,7.5,6z"/>\n  <path id="ellipse4153" d="M2.08,4.3c-0.7348,0.3676-1.0652,1.2371-0.76,2c0.064,0.8282,0.7809,1.4517,1.61,1.4&#xA;&#x9;c0.7348-0.3676,1.0652-1.2371,0.76-2C3.626,4.8718,2.9091,4.2483,2.08,4.3z"/>\n  <path id="ellipse4163" d="M12.93,4.3c0.7348,0.3676,1.0653,1.2371,0.76,2c-0.064,0.8282-0.7809,1.4517-1.61,1.4&#xA;&#x9;c-0.7348-0.3676-1.0653-1.2371-0.76-2C11.384,4.8718,12.1009,4.2483,12.93,4.3z"/>\n  <path id="ellipse4165" d="M5.08,1.3c-0.68,0.09-1,0.94-0.76,1.87C4.4301,3.9951,5.1003,4.6321,5.93,4.7c0.68-0.09,1-0.94,0.76-1.87&#xA;&#x9;C6.5799,2.0049,5.9097,1.3679,5.08,1.3z"/>\n  <path id="ellipse4167" d="M9.93,1.3c0.68,0.09,1,0.94,0.76,1.87C10.5791,3.9986,9.9036,4.6365,9.07,4.7c-0.68-0.08-1-0.94-0.76-1.87&#xA;&#x9;C8.4209,2.0014,9.0964,1.3634,9.93,1.3z"/>\n</svg>'
  },
  viewpoint: {
    label: 'Viewpoint',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="viewpoint-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="cf3b542b-d2af-4732-9b92-9e3dc05e460f" d="M6.02,8.425a2.3859,2.3859,0,0,0-.46.44l-4.55-3.5a7.9976,7.9976,0,0,1,1.51-1.51Zm6.46-4.56-3.5,4.55a2.3971,2.3971,0,0,1,.45.45l4.56-3.5A7.945,7.945,0,0,0,12.48,3.865ZM7.3042,10.0129a1.5,1.5,0,1,0,1.6829,1.2914h0A1.5,1.5,0,0,0,7.3042,10.0129ZM6.43,2.235a7.9329,7.9329,0,0,0-2.06.55l2.2,5.32a2.0438,2.0438,0,0,1,.61-.17Zm2.14.01-.75,5.69a2.49,2.49,0,0,1,.61.16l2.2-5.3A7.2129,7.2129,0,0,0,8.57,2.245Z"/>\n</svg>'
  },
  village: {
    label: 'Village',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="village-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M6.176,4.176a.249.249,0,0,0-.352,0l-4.4,4.4A.25.25,0,0,0,1.6,9H3v4.751A.249.249,0,0,0,3.249,14h3.5A.249.249,0,0,0,7,13.753H7V8.323a.249.249,0,0,1,.073-.176L8.5,6.5ZM6,12H5V11H6Zm0-2H5V9H6Zm6.75-4h-.5a.25.25,0,0,0-.25.25V8L10.676,6.176a.249.249,0,0,0-.352,0L8.056,8.932A.246.246,0,0,0,8,9.088v4.66A.249.249,0,0,0,8.246,14h1.5A.253.253,0,0,0,10,13.748h0V12h1v1.747a.253.253,0,0,0,.253.253h1.5A.25.25,0,0,0,13,13.751V6.25A.25.25,0,0,0,12.75,6ZM10,11H9V10h1Zm2,0H11V10h1Z"/>\n</svg>'
  },
  volcano: {
    label: 'Volcano',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="volcano-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path6447" d="M8.4844,1.0002&#xA;&#x9;c-0.1464,0.005-0.2835,0.0731-0.375,0.1875L6.4492,3.2619L4.8438,1.7385C4.4079,1.3374,3.7599,1.893,4.0899,2.385l1.666,2.4004&#xA;&#x9;C5.9472,5.061,6.3503,5.0737,6.5586,4.8108C6.7249,4.6009,7,4.133,7.5,4.133s0.7929,0.4907,0.9414,0.6777&#xA;&#x9;c0.175,0.2204,0.4973,0.2531,0.7129,0.0723l1.668-1.4004c0.4408-0.3741,0.0006-1.0735-0.5273-0.8379L9,3.2268V1.5002&#xA;&#x9;C9.0002,1.2179,8.7666,0.9915,8.4844,1.0002L8.4844,1.0002z M5,6.0002L2.0762,11.924C1.9993,12.0009,2,12.155,2,12.3088&#xA;&#x9;c0,0.5385,0.3837,0.6914,0.6914,0.6914h9.6172c0.3846,0,0.6914-0.153,0.6914-0.6914c0-0.1538,0.0008-0.2309-0.0762-0.3848L10,6.0002&#xA;&#x9;c-0.5,0-1,0.5-1,1v0.5c0,0.277-0.223,0.5-0.5,0.5S8,7.7772,8,7.5002v-0.5c0-0.2761-0.2238-0.5-0.5-0.5S7,6.7241,7,7.0002v2&#xA;&#x9;c0,0.277-0.223,0.5-0.5,0.5S6,9.2772,6,9.0002v-2C6,6.5002,5.5,6.0002,5,6.0002z"/>\n</svg>'
  },
  volleyball: {
    label: 'Volleyball',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="volleyball-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path id="e086ca83-8703-4df5-a97c-5939eb32113a" d="M13.91,7.94a5.9086,5.9086,0,0,1-.13.94,8.8218,8.8218,0,0,0-2.17-1.49,8.89,8.89,0,0,0-1.4-.56,8.6142,8.6142,0,0,0-1.82-.35.221.221,0,0,0-.08-.01A7.32,7.32,0,0,1,7.5,4.59c-.01-.01-.01-.01,0-.02a7.7573,7.7573,0,0,1,1.52.15,7.0987,7.0987,0,0,1,1.56.5,6.8585,6.8585,0,0,1,1.4.78A7.4165,7.4165,0,0,1,13.91,7.94Zm-1.87-5a6.2232,6.2232,0,0,0-1.85-1.27,4.2725,4.2725,0,0,0-.98-.36,5.6412,5.6412,0,0,0-1.55-.23,1.2882,1.2882,0,0,0-.32,0A7.4263,7.4263,0,0,0,7.21,2.5c0,.2.01.39.02.58a2.28,2.28,0,0,1,.26-.01,2.6438,2.6438,0,0,1,.28.01,8.2865,8.2865,0,0,1,1.49.16,8.9879,8.9879,0,0,1,1.35.37,8.7922,8.7922,0,0,1,1.53.7,10.18,10.18,0,0,1,1.39.97A6.4588,6.4588,0,0,0,12.04,2.94ZM4.01,8.76a9.4084,9.4084,0,0,1-.62-1.37,9.1038,9.1038,0,0,1-.37-1.41,9.1748,9.1748,0,0,1-.16-1.67V4.28a8.455,8.455,0,0,1,.1-1.34A6.28,6.28,0,0,0,1.47,5.3a6.2222,6.2222,0,0,0-.4,2.2c0,.15.01.3.02.44a5.9086,5.9086,0,0,0,.13.94,5.7343,5.7343,0,0,0,.41,1.23c.22-.05.44-.11.65-.17a8.0188,8.0188,0,0,0,1.9-.88C4.12,8.96,4.06,8.86,4.01,8.76Zm2.6-2.28a9,9,0,0,1-.63-1.76,9.135,9.135,0,0,1-.24-1.48c-.02-.25-.03-.49-.03-.74a9.3777,9.3777,0,0,1,.08-1.19,4.2725,4.2725,0,0,0-.98.36,7.7038,7.7038,0,0,0-.42,1.94c-.02.22-.03.44-.03.67a7.2659,7.2659,0,0,0,.06.93,7.4258,7.4258,0,0,0,.37,1.63,6.4705,6.4705,0,0,0,.59,1.28A8.0174,8.0174,0,0,0,6.65,6.55.2522.2522,0,0,1,6.61,6.48ZM12.7,9.93s0-.01-.01,0a7.0128,7.0128,0,0,0-1.7-1.16c-.06.1-.11.19-.17.29a8.783,8.783,0,0,1-.88,1.22,8.9125,8.9125,0,0,1-1.06,1.07,10.4181,10.4181,0,0,1-1.38.98,8.9933,8.9933,0,0,1-2.64,1.02,6.2985,6.2985,0,0,0,5.28,0,5.9674,5.9674,0,0,0,2.42-1.89,4.8258,4.8258,0,0,0,.65-1.03A6.0315,6.0315,0,0,0,12.7,9.93Zm-5.17-2c-.01.01-.02.03-.03.04a9.26,9.26,0,0,1-1.25,1.4,9.5925,9.5925,0,0,1-1.19.91,9.2683,9.2683,0,0,1-2.62,1.18,6.0989,6.0989,0,0,0,.53.61,7.7353,7.7353,0,0,0,3.15-.72,7.3839,7.3839,0,0,0,1.38-.82A7.6429,7.6429,0,0,0,8.75,9.37a7.7441,7.7441,0,0,0,.82-1.15A7.3414,7.3414,0,0,0,7.53,7.93Z"/>\n</svg>'
  },
  warehouse: {
    label: 'Warehouse',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="warehouse-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M13.5,5c-0.0762,0.0003-0.1514-0.0168-0.22-0.05L7.5,2L1.72,4.93C1.4632,5.0515,1.1565,4.9418,1.035,4.685&#xA;&#x9;S1.0232,4.1215,1.28,4L7.5,0.92L13.72,4c0.2761,0.0608,0.4508,0.3339,0.39,0.61C14.0492,4.8861,13.7761,5.0608,13.5,5z M5,10H2v3h3&#xA;&#x9;V10z M9,10H6v3h3V10z M13,10h-3v3h3V10z M11,6H8v3h3V6z M7,6H4v3h3V6z"/>\n</svg>'
  },
  'waste-basket': {
    label: 'Waste basket',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="waste-basket-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12.41,5.58l-1.34,8c-0.0433,0.2368-0.2493,0.4091-0.49,0.41H4.42c-0.2407-0.0009-0.4467-0.1732-0.49-0.41l-1.34-8&#xA;&#x9;C2.5458,5.3074,2.731,5.0506,3.0035,5.0064C3.0288,5.0023,3.0544,5.0002,3.08,5h8.83c0.2761-0.0036,0.5028,0.2174,0.5064,0.4935&#xA;&#x9;C12.4168,5.5225,12.4146,5.5514,12.41,5.58z M13,3.5C13,3.7761,12.7761,4,12.5,4h-10C2.2239,4,2,3.7761,2,3.5S2.2239,3,2.5,3H5V1.5&#xA;&#x9;C5,1.2239,5.2239,1,5.5,1h4C9.7761,1,10,1.2239,10,1.5V3h2.5C12.7761,3,13,3.2239,13,3.5z M9,3V2H6v1H9z"/>\n</svg>'
  },
  watch: {
    label: 'Watch',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="watch-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12.5,7H12c-0.0175,0-0.0323,0.0082-0.0494,0.0099C11.8021,5.6575,11.0757,4.4804,10,3.7599V1.4977&#xA;&#x9;&#x9;C10,1.2228,9.7772,1,9.5023,1H5.4977C5.2228,1,5,1.2228,5,1.4977v2.2621C3.7946,4.5673,3,5.9402,3,7.5s0.7946,2.9327,2,3.7401&#xA;&#x9;&#x9;v2.2621C5,13.7771,5.2228,14,5.4977,14h4.0045C9.7772,14,10,13.7771,10,13.5022v-2.2621c1.0757-0.7205,1.8021-1.8976,1.9506-3.2501&#xA;&#x9;&#x9;C11.9677,7.9918,11.9825,8,12,8h0.5C12.7761,8,13,7.7761,13,7.5C13,7.2238,12.7761,7,12.5,7z M7.5,11C5.567,11,4,9.433,4,7.5&#xA;&#x9;&#x9;S5.567,4,7.5,4S11,5.567,11,7.5S9.433,11,7.5,11z"/>\n  <path d="M9,7H8V5.5C8,5.2238,7.7761,5,7.5,5S7,5.2238,7,5.5v2C7,7.7761,7.2239,8,7.5,8H9c0.2761,0,0.5-0.2239,0.5-0.5&#xA;&#x9;&#x9;C9.5,7.2238,9.2761,7,9,7z"/>\n</svg>'
  },
  water: {
    label: 'Water',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="water-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M7.49,15C4.5288,14.827,2.1676,12.4615,2,9.5C2,6.6,6.25,1.66,7.49,0c1.24,1.66,5,6.59,5,9.49S10.17,15,7.49,15z"/>\n</svg>'
  },
  waterfall: {
    label: 'Waterfall',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg id="waterfall-15" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15">\n  <path d="M12.9,3H15V1H5c0,0-4,0-4,4v5.5h0c-1.1,0.8-1.3,2.4-0.5,3.5s2.4,1.3,3.5,0.5c1,0.8,2.5,0.6,3.4-0.4C8,14.7,8.9,15,9.8,15&#xA;&#x9;c2.1,0,3.7-1.6,3.8-3.7c0-1.6-1-3-2.5-3.5V5C11,3.9,11.8,3,12.9,3z M10,8v0.5c1.5,0.1,2.6,1.5,2.5,3c-0.1,1.4-1.3,2.5-2.7,2.5&#xA;&#x9;c-1.1,0.1-1.8-0.6-2.1-1H6.9c-0.1,0.2-0.4,1-1.4,1s-1.3-0.6-1.4-1H3.9c-0.2,0.4-0.5,0.8-0.9,0.9c-0.9,0.3-1.7-0.2-1.9-1&#xA;&#x9;c-0.2-0.8,0.2-1.6,0.9-1.8V6c0-0.5,0.4-1,1-1c0,0,0,0,0,0h0c0.5,0,1,0.4,1,1c0,0,0,0,0,0c0,0,0,0,0,0v4.5C4,10.8,4.2,11,4.5,11&#xA;&#x9;S5,10.8,5,10.5V7c0-0.6,0.4-1,1-1s1,0.4,1,1v3.5C7,10.8,7.2,11,7.5,11S8,10.8,8,10.5V6c0-0.6,0.4-1,1-1s1,0.4,1,1V8z"/>\n</svg>'
  },
  watermill: {
    label: 'Watermill',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="watermill-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M2,10.2L4,9l2.5,1.5l1.4659-0.8788C7.6592,9.4698,7.3716,9.285,7.1231,9.0536l1.4131-1.4131&#xA;&#x9;C8.7672,7.836,9.0557,7.9606,9.375,7.9874V9.224l0.25,0.1501V7.9874c0.3193-0.0268,0.6078-0.1514,0.8388-0.3469l1.4131,1.4131&#xA;&#x9;c-0.4059,0.3781-0.9044,0.6492-1.4528,0.8003L11.5,10.5l0.6984-0.4191C13.2863,9.2595,14,7.9682,14,6.5C14,4.0147,11.9853,2,9.5,2&#xA;&#x9;C8.1917,2,7.0241,2.5674,6.2018,3.4587L4.5,2L1,5h1V10.2z M12.0536,8.8769l-1.4131-1.4131c0.1954-0.231,0.3201-0.5196,0.3469-0.8388&#xA;&#x9;h1.9999C12.956,7.4946,12.6089,8.2806,12.0536,8.8769z M12.9874,6.375h-1.9999c-0.0268-0.3193-0.1514-0.6078-0.3469-0.8388&#xA;&#x9;l1.4131-1.4131C12.6089,4.7193,12.956,5.5054,12.9874,6.375z M9.625,3.0126c0.8696,0.0314,1.6557,0.3784,2.2519,0.9337&#xA;&#x9;l-1.4131,1.4131c-0.231-0.1954-0.5196-0.32-0.8388-0.3468C9.625,5.0126,9.625,3.0126,9.625,3.0126z M9.375,3.0126v1.9999&#xA;&#x9;C9.0558,5.0394,8.7672,5.164,8.5362,5.3594L7.1231,3.9463C7.7193,3.3911,8.5054,3.044,9.375,3.0126z M6.9464,4.1231l1.4131,1.4131&#xA;&#x9;C8.164,5.7672,8.0394,6.0557,8.0126,6.375h-2C6.044,5.5054,6.3911,4.7193,6.9464,4.1231z M8.0126,6.625&#xA;&#x9;c0.0268,0.3192,0.1515,0.6078,0.3469,0.8388L6.9464,8.8769C6.3911,8.2807,6.044,7.4946,6.0126,6.625H8.0126z M9.002,10L6.5,11.5&#xA;&#x9;L4,10l-2.5,1.5V13L4,11.5L6.5,13l2.502-1.5L11.5,13l2.5-1.5V10l-2.5,1.5L9.002,10z"/>\n</svg>'
  },
  wetland: {
    label: 'Wetland',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="wetland-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M1.48,4.5C1.905,4.1467,2.4483,3.968,3,4c1.2273-0.0869,2.3154,0.7836,2.5,2l0.78,4.68c-0.6394-0.2893-1.3759-0.2709-2,0.05&#xA;&#x9;L3.48,6C3.1874,5.1347,2.3926,4.5387,1.48,4.5z M7.48,11.24c0.3816-0.3076,0.825-0.5293,1.3-0.65L10,3&#xA;&#x9;c0.2926-0.8653,1.0874-1.4613,2-1.5c-0.4198-0.3485-0.955-0.5269-1.5-0.5C9.2727,0.9131,8.1846,1.7836,8,3l-1.3,7.79&#xA;&#x9;C6.9786,10.9052,7.2408,11.0565,7.48,11.24z M11.8,10.74L11.8,10.74c0.1565-0.1277,0.3238-0.2414,0.5-0.34L13,6&#xA;&#x9;c0.2926-0.8653,1.0874-1.4613,2-1.5c-0.4198-0.3485-0.955-0.5269-1.5-0.5c-1.2273-0.0869-2.3154,0.7836-2.5,2l-0.67,4&#xA;&#x9;C10.8731,10.123,11.3778,10.377,11.8,10.74z M14,12L14,12c-0.4346-0.01-0.8579,0.1394-1.19,0.42l-0.47,0.41&#xA;&#x9;c-0.2847,0.2546-0.7153,0.2546-1,0c-0.15-0.12-0.29-0.26-0.44-0.39c-0.7076-0.5968-1.7424-0.5968-2.45,0&#xA;&#x9;c-0.16,0.13-0.31,0.28-0.47,0.41c-0.2847,0.2546-0.7153,0.2546-1,0c-0.16-0.13-0.31-0.28-0.47-0.41&#xA;&#x9;c-0.7059-0.5912-1.7341-0.5912-2.44,0c-0.15,0.13-0.29,0.27-0.44,0.39c-0.0892,0.0715-0.1909,0.1258-0.3,0.16&#xA;&#x9;c-0.2922,0.0652-0.5969-0.0301-0.8-0.25c-0.2475-0.214-0.5117-0.4079-0.79-0.58C1.5336,12.0421,1.2974,11.9865,1.06,12H1&#xA;&#x9;c-0.2761,0-0.5,0.2239-0.5,0.5S0.7239,13,1,13l0,0c0.246,0.0145,0.4762,0.126,0.64,0.31L2,13.57&#xA;&#x9;c0.6717,0.55,1.6308,0.5747,2.33,0.06c0.19-0.14,0.36-0.32,0.55-0.47c0.2847-0.2546,0.7153-0.2546,1,0l0.39,0.35&#xA;&#x9;c0.6937,0.6189,1.7322,0.6484,2.46,0.07c0.15-0.11,0.27-0.25,0.42-0.37c0.2976-0.3038,0.7851-0.3087,1.0889-0.0111&#xA;&#x9;c0.0037,0.0037,0.0074,0.0074,0.0111,0.0111l0.39,0.35c0.4866,0.4124,1.1485,0.5516,1.76,0.37c0.3825-0.1036,0.7286-0.3113,1-0.6&#xA;&#x9;c0.1549-0.1772,0.3674-0.294,0.6-0.33l0,0c0.2761,0,0.5-0.2239,0.5-0.5S14.2761,12,14,12z"/>\n</svg>'
  },
  wheelchair: {
    label: 'Wheelchair',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="wheelchair-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M12,1.5C12,2.3284,11.3284,3,10.5,3S9,2.3284,9,1.5S9.6716,0,10.5,0S12,0.6716,12,1.5z M2.82,4.87l1.74-1.71l1.85,1.29&#xA;&#x9;L5.67,5.7c1.0747,0.3341,2.0207,0.9904,2.71,1.88l0.88-1.5c0.2295-0.4158,0.0785-0.939-0.3373-1.1685&#xA;&#x9;C8.9218,4.911,8.9209,4.9105,8.92,4.91L8.3,4.54L4.79,2.1C4.5927,1.9594,4.3231,1.9805,4.15,2.15l-2,2&#xA;&#x9;C1.9852,4.3716,2.0312,4.6848,2.2528,4.8496C2.4193,4.9735,2.645,4.9816,2.82,4.87z M8.13,10.94&#xA;&#x9;c-0.0143,1.2308-0.5794,2.3904-1.54,3.16c-0.7118,0.5804-1.6016,0.8982-2.52,0.9C1.8261,15,0.0055,13.1839,0,10.94&#xA;&#x9;c0.0023-0.9231,0.3238-1.8169,0.91-2.53c0.1868-0.232,0.398-0.4432,0.63-0.63c0.7131-0.5862,1.6069-0.9077,2.53-0.91&#xA;&#x9;C6.3139,6.8755,8.13,8.6961,8.13,10.94z M6,12.21C6.7679,11.2051,6.5758,9.7679,5.5709,9C4.7501,8.3727,3.6109,8.3727,2.79,9&#xA;&#x9;C2.5283,9.151,2.311,9.3683,2.16,9.63c-0.6923,1.0584-0.3956,2.4777,0.6628,3.17c0.7615,0.4981,1.7457,0.4981,2.5072,0&#xA;&#x9;C5.5805,12.6365,5.8061,12.4378,6,12.21z M14.2,13.21l-2.49-5C11.5906,7.9251,11.3088,7.7425,11,7.75H8.51&#xA;&#x9;c0.3293,0.4578,0.5856,0.9638,0.76,1.5h1.26l2.29,4.58c0.185,0.3728,0.6372,0.525,1.01,0.34c0.3728-0.185,0.525-0.6372,0.34-1.01&#xA;&#x9;L14.2,13.21z"/>\n</svg>'
  },
  windmill: {
    label: 'Windmill',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="windmill-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path d="M6,5L3.5,7.5l1,1L7,6V5.5L7.5,5L8,5.5V6l2.5,2.5l1-1L9,5H8.5L8,4.5L8.5,4H9l2.5-2.5l-1-1L8,3v0.5L7.5,4L7,3.5V3L4.5,0.5&#xA;&#x9;l-1,1L6,4h0.5L7,4.5L6.5,5H6z M11.5,13h-1l-1-4l-2-2l-2,2l-1,4h-1C3.2239,13,3,13.2238,3,13.5C3,13.7761,3.2239,14,3.5,14h8&#xA;&#x9;c0.2761,0,0.5-0.2239,0.5-0.5C12,13.2238,11.7761,13,11.5,13z M8,13H7v-1.5024C7,11.2228,7.2228,11,7.4976,11&#xA;&#x9;C7.7751,11,8,11.2249,8,11.5024V13z"/>\n</svg>'
  },
  zoo: {
    label: 'Zoo',
    svg: '<?xml version="1.0" encoding="UTF-8"?>\n<svg version="1.1" id="zoo-15" xmlns="http://www.w3.org/2000/svg" width="15px" height="15px" viewBox="0 0 15 15">\n  <path id="path17499" d="&#xA;&#x9;M8.3879,3.8928C8.3879,3.8928,7.6818,5,7,5H4.5C3.8182,5,3.2016,5.4086,2.7273,5.8636L0.5,8C0.231,8.258,0.0072,8.7681,0,9&#xA;&#x9;c-0.0156,0.5,0,1,0,1s1,0,1-1V8.5l1-1h0.5l0.158,0.2892c0,0-0.9535,1.8244-0.9535,3.5289C1.7046,12,2.3864,12,2.3864,12h0.6818&#xA;&#x9;c0,0,0.3409,0,0-0.3409l-0.3409-0.3409C2.7273,10.6364,3.5002,9.6667,4,9c0,0,0.0168,1.1579,0,2c-0.008,0.4096,0.2721,1,0.6818,1&#xA;&#x9;h0.6818c0,0,0.3409,0,0-0.3409l-0.3409-0.3409C4.7105,10.7495,5.5,8.5,5.5,8.5C6.7716,8.5,7,9,8.5,9l0.3636,2.3182&#xA;&#x9;C8.975,12.0282,9.5,12,9.5,12H11c0.3409,0,0.9611-0.3115,0.3409-0.7736L11,11V9c1.2142-0.1722,2-1,2-2h1c0.3214,0,1,0,1-0.5v-1&#xA;&#x9;l-1.7045-1.6818C12.5444,3.0772,12,2.5,11,2.5C9.5469,2.5,8.8636,3.0688,8.3879,3.8928z"/>\n</svg>'
  }
};
exports.MAKI_ICONS = MAKI_ICONS;