"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StopInput extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onFocus", () => {
      if (!this.state.hasPrevFocus) {
        this.setState({
          hasPrevFocus: true
        });
        this._onSearchChange('');
      }
    });
    (0, _defineProperty2.default)(this, "_onChange", selectedOptions => {
      this.props.onChange(_lodash.default.get(selectedOptions, '[0].label', ''));
    });
    (0, _defineProperty2.default)(this, "_onCreateOption", newValue => {
      this.props.onChange(newValue);
    });
    (0, _defineProperty2.default)(this, "_onSearchChange", async searchValue => {
      this.setState({
        isLoadingSuggestions: true,
        searchValue
      }, () => {
        this._loadSuggestions(searchValue);
      });
    });
    (0, _defineProperty2.default)(this, "_loadSuggestions", _lodash.default.debounce(async searchValue => {
      let suggestions = [];
      try {
        suggestions = await this.props.getValueSuggestions(searchValue);
      } catch (error) {
        // ignore suggestions error
      }
      if (this._isMounted && searchValue === this.state.searchValue) {
        this.setState({
          isLoadingSuggestions: false,
          suggestions
        });
      }
    }, 300));
    (0, _defineProperty2.default)(this, "_onFieldTextChange", event => {
      this.setState({
        localFieldTextValue: event.target.value
      });
      // onChange can cause UI lag, ensure smooth input typing by debouncing onChange
      this._debouncedOnFieldTextChange();
    });
    (0, _defineProperty2.default)(this, "_debouncedOnFieldTextChange", _lodash.default.debounce(() => {
      this.props.onChange(this.state.localFieldTextValue);
    }, 500));
    this.state = {
      suggestions: [],
      isLoadingSuggestions: false,
      hasPrevFocus: false,
      fieldDataType: null,
      localFieldTextValue: props.value
    };
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFieldDataType();
  }
  componentWillUnmount() {
    this._isMounted = false;
    this._loadSuggestions.cancel();
  }
  async _loadFieldDataType() {
    const fieldDataType = await this.props.field.getDataType();
    if (this._isMounted) {
      this.setState({
        fieldDataType
      });
    }
  }
  _renderSuggestionInput() {
    const suggestionOptions = this.state.suggestions.map(suggestion => {
      return {
        label: `${suggestion}`
      };
    });
    const selectedOptions = [];
    if (this.props.value) {
      let option = suggestionOptions.find(({
        label
      }) => {
        return label === this.props.value;
      });
      if (!option) {
        option = {
          label: this.props.value
        };
        suggestionOptions.unshift(option);
      }
      selectedOptions.push(option);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: suggestionOptions,
      selectedOptions: selectedOptions,
      singleSelection: _constants.SINGLE_SELECTION_AS_TEXT_PROPS,
      onChange: this._onChange,
      onSearchChange: this._onSearchChange,
      onCreateOption: this._onCreateOption,
      isClearable: false,
      isLoading: this.state.isLoadingSuggestions,
      onFocus: this._onFocus,
      "data-test-subj": this.props.dataTestSubj,
      compressed: true
    });
  }
  _renderTextInput() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.localFieldTextValue,
      onChange: this._onFieldTextChange,
      compressed: true
    });
  }
  render() {
    if (!this.state.fieldDataType) {
      return null;
    }

    // autocomplete service can not provide suggestions for non string fields (and boolean) because it uses
    // term aggregation include parameter. Include paramerter uses a regular expressions that only supports string type
    return this.state.fieldDataType === 'string' || this.state.fieldDataType === 'boolean' ? this._renderSuggestionInput() : this._renderTextInput();
  }
}
exports.StopInput = StopInput;