"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorStyleLegend = VectorStyleLegend;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("../../../../../../common/constants");
var _mask_legend = require("./mask_legend");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function VectorStyleLegend({
  isLinesOnly,
  isPointsOnly,
  masks,
  styles,
  symbolId,
  svg
}) {
  const legendRows = [];
  for (let i = 0; i < styles.length; i++) {
    const row = styles[i].renderLegendDetailRow({
      isLinesOnly,
      isPointsOnly,
      symbolId,
      svg
    });
    legendRows.push( /*#__PURE__*/_react.default.createElement("div", {
      key: i,
      className: "vectorStyleLegendSpacer"
    }, row));
  }
  function renderMasksByFieldOrigin(fieldOrigin) {
    const masksByFieldOrigin = masks.filter(mask => mask.getEsAggField().getOrigin() === fieldOrigin);
    if (masksByFieldOrigin.length === 0) {
      return null;
    }
    if (masksByFieldOrigin.length === 1) {
      const mask = masksByFieldOrigin[0];
      return /*#__PURE__*/_react.default.createElement(_mask_legend.MaskLegend, {
        key: mask.getEsAggField().getMbFieldName(),
        esAggField: mask.getEsAggField(),
        operator: mask.getOperator(),
        value: mask.getValue()
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "left",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("small", null, masksByFieldOrigin[0].getFieldOriginListLabel())), /*#__PURE__*/_react.default.createElement("ul", null, masksByFieldOrigin.map(mask => /*#__PURE__*/_react.default.createElement("li", {
      key: mask.getEsAggField().getMbFieldName(),
      style: {
        marginLeft: _uiTheme.euiThemeVars.euiSizeS
      }
    }, /*#__PURE__*/_react.default.createElement(_mask_legend.MaskLegend, {
      esAggField: mask.getEsAggField(),
      onlyShowLabelAndValue: true,
      operator: mask.getOperator(),
      value: mask.getValue()
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderMasksByFieldOrigin(_constants.FIELD_ORIGIN.SOURCE), renderMasksByFieldOrigin(_constants.FIELD_ORIGIN.JOIN), legendRows);
}