"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkerSizeLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _right_aligned_text = require("../right_aligned_text");
var _get_ordinal_label = require("./get_ordinal_label");
var _marker_list = require("./marker_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FONT_SIZE = 10;
const HALF_FONT_SIZE = FONT_SIZE / 2;
const EMPTY_VALUE = '';
class MarkerSizeLegend extends _react.Component {
  static getDerivedStateFromProps(nextProps, prevState) {
    const nextFieldMeta = nextProps.style.getRangeFieldMeta();
    return !_lodash.default.isEqual(nextFieldMeta, prevState.fieldMeta) ? {
      maxLabelWidth: 0,
      fieldMeta: nextFieldMeta
    } : null;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onRightAlignedWidthChange", width => {
      if (width > this.state.maxLabelWidth) {
        this.setState({
          maxLabelWidth: width
        });
      }
    });
    this.state = {
      label: EMPTY_VALUE,
      maxLabelWidth: 0,
      fieldMeta: this.props.style.getRangeFieldMeta()
    };
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLabel();
  }
  componentDidUpdate() {
    this._loadLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLabel() {
    const field = this.props.style.getField();
    if (!field) {
      return;
    }
    const label = await field.getLabel();
    if (this._isMounted && this.state.label !== label) {
      this.setState({
        label
      });
    }
  }
  _formatValue(value) {
    return value === EMPTY_VALUE ? value : this.props.style.formatField(value);
  }
  _renderMarkers() {
    const fieldMeta = this.state.fieldMeta;
    const options = this.props.style.getOptions();
    if (!fieldMeta || !options) {
      return null;
    }
    const invert = options.invert === undefined ? false : options.invert;
    const circleStyle = {
      fillOpacity: 0,
      stroke: _uiTheme.euiThemeVars.euiTextColor,
      strokeWidth: 1
    };
    const svgHeight = options.maxSize * 2 + HALF_FONT_SIZE + circleStyle.strokeWidth * 2;
    const circleCenterX = options.maxSize + circleStyle.strokeWidth;
    const circleBottomY = svgHeight - circleStyle.strokeWidth;
    const makeMarker = (radius, formattedValue) => {
      const circleCenterY = circleBottomY - radius;
      const circleTopY = circleCenterY - radius;
      const textOffset = this.state.maxLabelWidth + HALF_FONT_SIZE;
      const rawTextY = circleTopY + HALF_FONT_SIZE;
      const textY = rawTextY > svgHeight ? svgHeight : rawTextY;
      return {
        svg: /*#__PURE__*/_react.default.createElement("g", {
          key: radius
        }, /*#__PURE__*/_react.default.createElement("line", {
          style: {
            stroke: _uiTheme.euiThemeVars.euiBorderColor
          },
          x1: circleCenterX,
          y1: circleTopY,
          x2: circleCenterX * 2.25,
          y2: circleTopY
        }), /*#__PURE__*/_react.default.createElement(_right_aligned_text.RightAlignedText, {
          setWidth: this._onRightAlignedWidthChange,
          style: {
            fontSize: FONT_SIZE,
            fill: _uiTheme.euiThemeVars.euiTextColor
          },
          x: circleCenterX * 2.25 + textOffset,
          y: textY,
          value: formattedValue
        }), /*#__PURE__*/_react.default.createElement("circle", {
          style: circleStyle,
          cx: circleCenterX,
          cy: circleCenterY,
          r: radius
        })),
        textY
      };
    };
    function getMarkerRadius(percentage) {
      const delta = options.maxSize - options.minSize;
      return percentage * delta + options.minSize;
    }
    function getValue(percentage) {
      // Markers interpolated by area instead of radius to be more consistent with how the human eye+brain perceive shapes
      // and their visual relevance
      // This function mirrors output of maplibre expression created from DynamicSizeProperty.getMbSizeExpression
      const scaledWidth = Math.pow(percentage * Math.sqrt(fieldMeta.delta), 2);
      const value = invert ? fieldMeta.max - scaledWidth : scaledWidth + fieldMeta.min;
      return fieldMeta.delta > 3 ? Math.round(value) : value;
    }
    const maxLabel = (0, _get_ordinal_label.getMaxLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMaxOutsideStdRange), this._formatValue(fieldMeta.max));
    const minLabel = (0, _get_ordinal_label.getMinLabel)(this.props.style.isFieldMetaEnabled(), Boolean(fieldMeta.isMinOutsideStdRange), this._formatValue(fieldMeta.min));
    const markerList = new _marker_list.MarkerList(FONT_SIZE, makeMarker(options.maxSize, invert ? minLabel : maxLabel));
    if (fieldMeta.delta > 0) {
      markerList.push(makeMarker(options.minSize, invert ? maxLabel : minLabel));
      markerList.push(makeMarker(getMarkerRadius(0.25), this._formatValue(getValue(0.25))));
      markerList.push(makeMarker(getMarkerRadius(0.5), this._formatValue(getValue(0.5))));
      markerList.push(makeMarker(getMarkerRadius(0.75), this._formatValue(getValue(0.75))));
    }
    return /*#__PURE__*/_react.default.createElement("svg", {
      height: svgHeight,
      xmlns: "http://www.w3.org/2000/svg"
    }, markerList.getMarkers());
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      title: this.props.style.getDisplayStyleName(),
      content: this.state.label
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "eui-textTruncate",
      size: "xs",
      style: {
        maxWidth: '180px'
      }
    }, /*#__PURE__*/_react.default.createElement("small", null, /*#__PURE__*/_react.default.createElement("strong", null, this.state.label)))))), this._renderMarkers());
  }
}
exports.MarkerSizeLegend = MarkerSizeLegend;