"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _tooltip_selector = require("../../../components/tooltip_selector");
var _mvt_single_layer_source_settings = require("./mvt_single_layer_source_settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class UpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_onTooltipPropertiesSelect", propertyNames => {
      this.props.onChange({
        propName: 'tooltipProperties',
        value: propertyNames
      });
    });
    (0, _defineProperty2.default)(this, "_handleChange", settings => {
      const changes = [];
      if (settings.layerName !== this.props.source.getTileSourceLayer()) {
        changes.push({
          propName: 'layerName',
          value: settings.layerName
        });
      }
      if (settings.minSourceZoom !== this.props.source.getMinZoom()) {
        changes.push({
          propName: 'minSourceZoom',
          value: settings.minSourceZoom
        });
      }
      if (settings.maxSourceZoom !== this.props.source.getMaxZoom()) {
        changes.push({
          propName: 'maxSourceZoom',
          value: settings.maxSourceZoom
        });
      }
      if (!_lodash.default.isEqual(settings.fields, this._getFieldDescriptors())) {
        changes.push({
          propName: 'fields',
          value: settings.fields
        });

        // Remove dangling tooltips.
        // This behaves similar to how stale styling properties are removed (e.g. on metric-change in agg sources)
        const sanitizedTooltips = [];
        for (let i = 0; i < this.props.tooltipFields.length; i++) {
          const tooltipName = this.props.tooltipFields[i].getName();
          for (let j = 0; j < settings.fields.length; j++) {
            if (settings.fields[j].name === tooltipName) {
              sanitizedTooltips.push(tooltipName);
              break;
            }
          }
        }
        if (!_lodash.default.isEqual(sanitizedTooltips, this.props.tooltipFields)) {
          changes.push({
            propName: 'tooltipProperties',
            value: sanitizedTooltips
          });
        }
      }
      this.props.onChange(...changes);
    });
  }
  _getFieldDescriptors() {
    return this.props.source.getMVTFields().map(field => {
      return field.getMVTFieldDescriptor();
    });
  }
  _renderSourceSettingsCard() {
    const fieldDescriptors = this._getFieldDescriptors();
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.mvtSource.sourceSettings",
      defaultMessage: "Source settings"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_mvt_single_layer_source_settings.MVTSingleLayerSourceSettings, {
      handleChange: this._handleChange,
      layerName: this.props.source.getTileSourceLayer() || '',
      fields: fieldDescriptors,
      minSourceZoom: this.props.source.getMinZoom(),
      maxSourceZoom: this.props.source.getMaxZoom(),
      showFields: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  _renderTooltipSelectionCard() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.mvtSource.tooltipsTitle",
      defaultMessage: "Tooltip fields"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_tooltip_selector.TooltipSelector, {
      tooltipFields: this.props.tooltipFields // selected fields in the tooltip
      ,
      onChange: this._onTooltipPropertiesSelect,
      fields: this.props.source.getMVTFields() // all the fields in the source
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this._renderSourceSettingsCard(), this._renderTooltipSelectionCard());
  }
}
exports.UpdateSourceEditor = UpdateSourceEditor;