"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _constants = require("../../../../../common/constants");
var _geo_field_select = require("../../../../components/geo_field_select");
var _geo_index_pattern_select = require("../../../../components/geo_index_pattern_select");
var _index_pattern_util = require("../../../../index_pattern_util");
var _top_hits_form = require("./top_hits_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      indexPattern: null,
      isTimeseries: false,
      geoFields: [],
      geoFieldName: null,
      sortField: null,
      sortFields: [],
      sortOrder: _public.SortDirection.desc,
      termFields: [],
      topHitsGroupByTimeseries: false,
      topHitsSplitField: null,
      topHitsSize: 1
    });
    (0, _defineProperty2.default)(this, "_onIndexPatternSelect", indexPattern => {
      const geoFields = (0, _index_pattern_util.getGeoFields)(indexPattern.fields);
      const isTimeseries = (0, _index_pattern_util.getIsTimeseries)(indexPattern);
      this.setState({
        indexPattern,
        isTimeseries,
        geoFields,
        geoFieldName: geoFields.length ? geoFields[0].name : null,
        sortField: indexPattern.timeFieldName ? indexPattern.timeFieldName : null,
        sortFields: (0, _index_pattern_util.getSortFields)(indexPattern.fields),
        termFields: (0, _index_pattern_util.getTermsFields)(indexPattern.fields),
        topHitsGroupByTimeseries: isTimeseries,
        topHitsSplitField: null
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldSelect", geoFieldName => {
      this.setState({
        geoFieldName: geoFieldName ? geoFieldName : null
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onTopHitsPropChange", ({
      propName,
      value
    }) => {
      this.setState(
      // @ts-expect-error
      {
        [propName]: value
      }, this._previewLayer);
    });
    (0, _defineProperty2.default)(this, "_previewLayer", () => {
      const {
        indexPattern,
        geoFieldName,
        sortField,
        sortOrder,
        topHitsGroupByTimeseries,
        topHitsSplitField,
        topHitsSize
      } = this.state;
      const tooltipProperties = [];
      if (topHitsGroupByTimeseries) {
        var _indexPattern$fields;
        const timeSeriesDimensionFieldNames = ((_indexPattern$fields = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.fields) !== null && _indexPattern$fields !== void 0 ? _indexPattern$fields : []).filter(field => {
          return field.timeSeriesDimension;
        }).map(field => {
          return field.name;
        });
        tooltipProperties.push(...timeSeriesDimensionFieldNames);
      } else if (topHitsSplitField) {
        tooltipProperties.push(topHitsSplitField);
      }
      if (indexPattern && indexPattern.timeFieldName) {
        tooltipProperties.push(indexPattern.timeFieldName);
      }
      const field = geoFieldName && (indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getFieldByName(geoFieldName));
      const sourceConfig = indexPattern && geoFieldName && sortField && (topHitsGroupByTimeseries || topHitsSplitField) ? {
        indexPatternId: indexPattern.id,
        geoField: geoFieldName,
        scalingType: _constants.SCALING_TYPES.TOP_HITS,
        sortField,
        sortOrder,
        tooltipProperties,
        topHitsGroupByTimeseries,
        topHitsSplitField: topHitsSplitField ? topHitsSplitField : undefined,
        topHitsSize
      } : null;
      const isPointsOnly = field ? field.type === 'geo_point' : false;
      this.props.onSourceConfigChange(sourceConfig, isPointsOnly);
    });
  }
  _renderGeoSelect() {
    return this.state.indexPattern ? /*#__PURE__*/_react.default.createElement(_geo_field_select.GeoFieldSelect, {
      value: this.state.geoFieldName ? this.state.geoFieldName : '',
      onChange: this._onGeoFieldSelect,
      geoFields: this.state.geoFields
    }) : null;
  }
  _renderTopHitsPanel() {
    if (!this.state.indexPattern || !this.state.indexPattern.id || !this.state.geoFieldName) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_top_hits_form.TopHitsForm, {
      indexPatternId: this.state.indexPattern.id,
      isColumnCompressed: false,
      isTimeseries: this.state.isTimeseries,
      onChange: this._onTopHitsPropChange,
      sortField: this.state.sortField ? this.state.sortField : '',
      sortFields: this.state.sortFields,
      sortOrder: this.state.sortOrder,
      termFields: this.state.termFields,
      topHitsGroupByTimeseries: this.state.topHitsGroupByTimeseries,
      topHitsSplitField: this.state.topHitsSplitField,
      topHitsSize: this.state.topHitsSize
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
      dataView: this.state.indexPattern,
      onChange: this._onIndexPatternSelect
    }), this._renderGeoSelect(), this._renderTopHitsPanel());
  }
}
exports.CreateSourceEditor = CreateSourceEditor;