"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_METRIC = exports.AbstractESAggSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _es_source = require("../es_source");
var _agg = require("../../fields/agg");
var _constants = require("../../../../common/constants");
var _get_agg_key = require("../../../../common/get_agg_key");
var _get_agg_display_name = require("./get_agg_display_name");
var _mask = require("../../layers/vector_layer/mask");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_METRIC = {
  type: _constants.AGG_TYPE.COUNT
};
exports.DEFAULT_METRIC = DEFAULT_METRIC;
class AbstractESAggSource extends _es_source.AbstractESSource {
  static createDescriptor(descriptor) {
    const normalizedDescriptor = _es_source.AbstractESSource.createDescriptor(descriptor);
    return {
      ...normalizedDescriptor,
      type: descriptor.type ? descriptor.type : '',
      metrics: descriptor.metrics && descriptor.metrics.length > 0 ? descriptor.metrics : [DEFAULT_METRIC]
    };
  }
  constructor(descriptor) {
    super(descriptor);
    (0, _defineProperty2.default)(this, "_metricFields", void 0);
    this._metricFields = [];
    if (descriptor.metrics) {
      descriptor.metrics.forEach(aggDescriptor => {
        this._metricFields.push(...(0, _agg.esAggFieldsFactory)(aggDescriptor, this, this.getOriginForField()));
      });
    }
  }
  getBucketsName() {
    return _mask.BUCKETS;
  }
  getFieldByName(fieldName) {
    return this.getMetricFieldForName(fieldName);
  }
  createField({
    fieldName
  }) {
    throw new Error('Cannot create a new field from just a fieldname for an es_agg_source.');
  }
  getMetricFieldForName(fieldName) {
    const targetMetricField = this.getMetricFields().find(metricField => {
      return metricField.getName() === fieldName;
    });
    return targetMetricField ? targetMetricField : null;
  }
  getOriginForField() {
    return _constants.FIELD_ORIGIN.SOURCE;
  }
  getMetricFields() {
    const metrics = this._metricFields.filter(esAggField => esAggField.isValid());
    // Handle case where metrics is empty because older saved object state is empty array or there are no valid aggs.
    return metrics.length === 0 ? (0, _agg.esAggFieldsFactory)({
      type: _constants.AGG_TYPE.COUNT
    }, this, this.getOriginForField()) : metrics;
  }
  getAggKey(aggType, fieldName) {
    return (0, _get_agg_key.getSourceAggKey)({
      aggType,
      aggFieldName: fieldName
    });
  }
  async getAggLabel(aggType, fieldLabel) {
    switch (aggType) {
      case _constants.AGG_TYPE.COUNT:
        return (0, _get_agg_display_name.getAggDisplayName)(aggType);
      case _constants.AGG_TYPE.TERMS:
        return _i18n.i18n.translate('xpack.maps.source.esAggSource.topTermLabel', {
          defaultMessage: `top {fieldLabel}`,
          values: {
            fieldLabel
          }
        });
      default:
        return `${(0, _get_agg_display_name.getAggDisplayName)(aggType)} ${fieldLabel}`;
    }
  }
  async getFields() {
    return this.getMetricFields();
  }
  getValueAggsDsl(indexPattern, metricsFilter) {
    const valueAggsDsl = {};
    this.getMetricFields().filter(esAggMetric => {
      return metricsFilter ? metricsFilter(esAggMetric) : true;
    }).forEach(esAggMetric => {
      const aggDsl = esAggMetric.getValueAggDsl(indexPattern);
      if (aggDsl) {
        valueAggsDsl[esAggMetric.getName()] = esAggMetric.getValueAggDsl(indexPattern);
      }
    });
    return valueAggsDsl;
  }
  async getTooltipProperties(mbProperties) {
    const metricFields = await this.getFields();
    const promises = [];
    metricFields.forEach(metricField => {
      let value;
      for (const key in mbProperties) {
        if (mbProperties.hasOwnProperty(key) && metricField.getMbFieldName() === key) {
          value = mbProperties[key];
          break;
        }
      }
      const tooltipPromise = metricField.createTooltipProperty(value);
      promises.push(tooltipPromise);
    });
    return await Promise.all(promises);
  }
  isGeoGridPrecisionAware() {
    return false;
  }

  /*
   * Changes in requestMeta.fieldNames does not require re-fetch.
   * It is not possible to filter metrics from responses so all metrics are always returned in all responses.
   */
  isFieldAware() {
    return false;
  }

  /*
   * Force re-fetch when requested metrics change.
   */
  getSyncMeta(dataFilters) {
    return {
      metrics: this.getMetricFields().map(esAggMetricField => esAggMetricField.getName())
    };
  }
  getGeoGridPrecision(zoom) {
    return 0;
  }
}
exports.AbstractESAggSource = AbstractESAggSource;