"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNewIndexAndPattern = void 0;
var _kibana_services = require("../../../../kibana_services");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNewIndexAndPattern = async ({
  indexName,
  defaultMappings = {}
}) => {
  return await (0, _kibana_services.getHttp)().fetch({
    path: _constants.INDEX_SOURCE_API_PATH,
    method: 'POST',
    version: '1',
    body: JSON.stringify({
      index: indexName,
      mappings: {
        properties: {
          coordinates: {
            type: 'geo_shape'
          },
          ...defaultMappings
        }
      }
    })
  });
};
exports.createNewIndexAndPattern = createNewIndexAndPattern;