"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEmsChoroplethLayerDescriptor = createEmsChoroplethLayerDescriptor;
exports.createEsChoroplethLayerDescriptor = createEsChoroplethLayerDescriptor;
var _uuid = require("uuid");
var _constants = require("../../../../../common/constants");
var _get_agg_key = require("../../../../../common/get_agg_key");
var _vector_style = require("../../../styles/vector/vector_style");
var _vector_layer = require("../../vector_layer");
var _ems_file_source = require("../../../sources/ems_file_source");
var _es_search_source = require("../../../sources/es_search_source");
var _vector_style_defaults = require("../../../styles/vector/vector_style_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultDynamicProperties = (0, _vector_style_defaults.getDefaultDynamicProperties)();
function createChoroplethLayerDescriptor({
  sourceDescriptor,
  leftField,
  rightIndexPatternId,
  rightTermField,
  layerType
}) {
  const metricsDescriptor = {
    type: _constants.AGG_TYPE.COUNT
  };
  const joinId = (0, _uuid.v4)();
  const joinKey = (0, _get_agg_key.getJoinAggKey)({
    aggType: metricsDescriptor.type,
    aggFieldName: '',
    rightSourceId: joinId
  });
  const styleProperties = {
    [_constants.VECTOR_STYLES.FILL_COLOR]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        ...defaultDynamicProperties[_constants.VECTOR_STYLES.FILL_COLOR].options,
        field: {
          name: joinKey,
          origin: _constants.FIELD_ORIGIN.JOIN
        },
        color: 'Yellow to Red',
        type: _constants.COLOR_MAP_TYPE.ORDINAL
      }
    },
    [_constants.VECTOR_STYLES.LINE_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: '#3d3d3d'
      }
    }
  };
  // Styling label by join metric with MVT is not supported
  if (layerType === _constants.LAYER_TYPE.GEOJSON_VECTOR) {
    styleProperties[_constants.VECTOR_STYLES.LABEL_TEXT] = {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        ...defaultDynamicProperties[_constants.VECTOR_STYLES.LABEL_TEXT].options,
        field: {
          name: joinKey,
          origin: _constants.FIELD_ORIGIN.JOIN
        }
      }
    };
  }
  const joins = [{
    leftField,
    right: {
      type: _constants.SOURCE_TYPES.ES_TERM_SOURCE,
      id: joinId,
      indexPatternId: rightIndexPatternId,
      term: rightTermField,
      metrics: [metricsDescriptor],
      applyGlobalQuery: true,
      applyGlobalTime: true,
      applyForceRefresh: true
    }
  }];
  return layerType === _constants.LAYER_TYPE.MVT_VECTOR ? _vector_layer.MvtVectorLayer.createDescriptor({
    joins,
    sourceDescriptor,
    style: _vector_style.VectorStyle.createDescriptor(styleProperties)
  }) : _vector_layer.GeoJsonVectorLayer.createDescriptor({
    joins,
    sourceDescriptor,
    style: _vector_style.VectorStyle.createDescriptor(styleProperties)
  });
}
function createEmsChoroplethLayerDescriptor({
  leftEmsFileId,
  leftEmsField,
  rightIndexPatternId,
  rightTermField
}) {
  return createChoroplethLayerDescriptor({
    sourceDescriptor: _ems_file_source.EMSFileSource.createDescriptor({
      id: leftEmsFileId,
      tooltipProperties: [leftEmsField]
    }),
    leftField: leftEmsField,
    rightIndexPatternId,
    rightTermField,
    layerType: _constants.LAYER_TYPE.GEOJSON_VECTOR
  });
}
function createEsChoroplethLayerDescriptor({
  leftIndexPatternId,
  leftGeoField,
  leftJoinField,
  rightIndexPatternId,
  rightTermField
}) {
  return createChoroplethLayerDescriptor({
    sourceDescriptor: _es_search_source.ESSearchSource.createDescriptor({
      indexPatternId: leftIndexPatternId,
      geoField: leftGeoField,
      scalingType: _constants.SCALING_TYPES.MVT,
      tooltipProperties: [leftJoinField],
      applyGlobalQuery: false,
      applyGlobalTime: false,
      applyForceRefresh: false
    }),
    leftField: leftJoinField,
    rightIndexPatternId,
    rightTermField,
    layerType: _constants.LAYER_TYPE.MVT_VECTOR
  });
}