"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initGetLogViewRoute = void 0;
var _http_api = require("../../../common/http_api");
var _log_views = require("../../../common/http_api/log_views");
var _runtime_types = require("../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initGetLogViewRoute = ({
  config,
  framework,
  getStartServices
}) => {
  framework.registerVersionedRoute({
    access: 'internal',
    method: 'get',
    path: _log_views.LOG_VIEW_URL
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _runtime_types.createValidationFunction)(_http_api.logViewsV1.getLogViewRequestParamsRT)
      }
    }
  }, async (_requestContext, request, response) => {
    const {
      logViewId
    } = request.params;
    const {
      logViews
    } = (await getStartServices())[2];
    const logViewsClient = logViews.getScopedClient(request);
    try {
      /**
       * Two possible paths for retrieving the log view
       * - if the log view saved object is correctly registered, perform a lookup for retrieving it
       * - else, skip the saved object lookup and immediately get the internal log view if exists.
       */
      const logView = config.savedObjects.logView.enabled ? await logViewsClient.getLogView(logViewId) : await logViewsClient.getInternalLogView(logViewId);
      return response.ok({
        body: _http_api.logViewsV1.getLogViewResponsePayloadRT.encode({
          data: logView
        })
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initGetLogViewRoute = initGetLogViewRoute;