"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initLogEntriesSummaryHighlightsRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _configSchema = require("@kbn/config-schema");
var _http_api = require("../../../common/http_api");
var _runtime_types = require("../../../common/runtime_types");
var _serialized_query = require("../../utils/serialized_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const escapeHatch = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const initLogEntriesSummaryHighlightsRoute = ({
  framework,
  logEntries
}) => {
  framework.registerVersionedRoute({
    access: 'internal',
    method: 'post',
    path: _http_api.logEntriesV1.LOG_ENTRIES_SUMMARY_HIGHLIGHTS_PATH
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: escapeHatch
      }
    }
  }, async (requestContext, request, response) => {
    const payload = (0, _pipeable.pipe)(_http_api.logEntriesV1.logEntriesSummaryHighlightsRequestRT.decode(request.body), (0, _Either.fold)((0, _runtime_types.throwErrors)(_boom.default.badRequest), _function.identity));
    const {
      logView,
      startTimestamp,
      endTimestamp,
      bucketSize,
      query,
      highlightTerms
    } = payload;
    const bucketsPerHighlightTerm = await logEntries.getLogSummaryHighlightBucketsBetween(requestContext, logView, startTimestamp, endTimestamp, bucketSize, highlightTerms, (0, _serialized_query.parseFilterQuery)(query));
    return response.ok({
      body: _http_api.logEntriesV1.logEntriesSummaryHighlightsResponseRT.encode({
        data: bucketsPerHighlightTerm.map(buckets => ({
          start: startTimestamp,
          end: endTimestamp,
          buckets
        }))
      })
    });
  });
};
exports.initLogEntriesSummaryHighlightsRoute = initLogEntriesSummaryHighlightsRoute;