"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSharedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _log_ai_assistant = require("./components/log_ai_assistant");
var _log_views = require("./services/log_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogsSharedPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "logViews", void 0);
    this.logViews = new _log_views.LogViewsService();
  }
  setup() {
    const logViews = this.logViews.setup();
    return {
      logViews
    };
  }
  start(core, plugins) {
    const {
      http
    } = core;
    const {
      data,
      dataViews,
      observabilityAIAssistant
    } = plugins;
    const logViews = this.logViews.start({
      http,
      dataViews,
      search: data.search
    });
    const LogAIAssistant = (0, _log_ai_assistant.createLogAIAssistant)({
      observabilityAIAssistant
    });
    return {
      logViews,
      LogAIAssistant
    };
  }
  stop() {}
}
exports.LogsSharedPlugin = LogsSharedPlugin;