"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchLogEntriesAround = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _utils = require("../../../../common/utils");
var _data_search = require("../../../utils/data_search");
var _use_observable = require("../../../utils/use_observable");
var _use_fetch_log_entries_after = require("./use_fetch_log_entries_after");
var _use_fetch_log_entries_before = require("./use_fetch_log_entries_before");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchLogEntriesAround = ({
  columnOverrides,
  endTimestamp,
  highlightPhrase,
  query,
  logViewReference,
  startTimestamp
}) => {
  var _latestCombinedRespon, _latestCombinedRespon2;
  const {
    fetchLogEntriesBefore
  } = (0, _use_fetch_log_entries_before.useLogEntriesBeforeRequest)({
    columnOverrides,
    endTimestamp,
    highlightPhrase,
    query,
    logViewReference,
    startTimestamp
  });
  const {
    fetchLogEntriesAfter
  } = (0, _use_fetch_log_entries_after.useLogEntriesAfterRequest)({
    columnOverrides,
    endTimestamp,
    highlightPhrase,
    query,
    logViewReference,
    startTimestamp
  });
  const logEntriesAroundSearchRequests$ = (0, _use_observable.useObservable)(() => new _rxjs.ReplaySubject(), []);
  const fetchLogEntriesAround = (0, _react.useCallback)((cursor, size) => {
    const logEntriesBeforeSearchRequest = fetchLogEntriesBefore(cursor, {
      size: Math.floor(size / 2)
    });
    if (logEntriesBeforeSearchRequest == null) {
      return;
    }
    const logEntriesAfterSearchRequest$ = (0, _data_search.flattenDataSearchResponseDescriptor)(logEntriesBeforeSearchRequest).pipe((0, _operators.last)(),
    // in the future we could start earlier if we receive partial results already
    (0, _operators.map)(lastBeforeSearchResponse => {
      var _lastBeforeSearchResp, _lastBeforeSearchResp2;
      const cursorAfter = (_lastBeforeSearchResp = (_lastBeforeSearchResp2 = lastBeforeSearchResponse.response.data) === null || _lastBeforeSearchResp2 === void 0 ? void 0 : _lastBeforeSearchResp2.bottomCursor) !== null && _lastBeforeSearchResp !== void 0 ? _lastBeforeSearchResp : {
        time: (0, _utils.subtractMillisecondsFromDate)(cursor.time, 1),
        tiebreaker: 0
      };
      const logEntriesAfterSearchRequest = fetchLogEntriesAfter(cursorAfter, {
        size: Math.ceil(size / 2)
      });
      if (logEntriesAfterSearchRequest == null) {
        throw new Error('Failed to create request: no request args given');
      }
      return logEntriesAfterSearchRequest;
    }));
    logEntriesAroundSearchRequests$.next([logEntriesBeforeSearchRequest, logEntriesAfterSearchRequest$]);
  }, [fetchLogEntriesAfter, fetchLogEntriesBefore, logEntriesAroundSearchRequests$]);
  const logEntriesAroundSearchResponses$ = (0, _use_observable.useObservable)(inputs$ => inputs$.pipe((0, _operators.switchMap)(([currentSearchRequests$]) => currentSearchRequests$.pipe((0, _operators.switchMap)(([beforeRequest, afterRequest$]) => {
    const beforeResponse$ = (0, _data_search.flattenDataSearchResponseDescriptor)(beforeRequest);
    const afterResponse$ = afterRequest$.pipe((0, _operators.switchMap)(_data_search.flattenDataSearchResponseDescriptor), (0, _operators.startWith)(undefined) // emit "before" response even if "after" hasn't started yet
    );

    return (0, _rxjs.combineLatest)([beforeResponse$, afterResponse$]);
  }), (0, _operators.map)(([beforeResponse, afterResponse]) => {
    var _ref, _ref2, _beforeResponse$respo, _beforeResponse$respo2, _afterResponse$respon, _afterResponse$respon2, _beforeResponse$respo3, _afterResponse$respon3, _beforeResponse$respo4, _afterResponse$respon4, _beforeResponse$respo5, _afterResponse$respon5;
    const loadedBefore = beforeResponse.response.loaded;
    const loadedAfter = afterResponse === null || afterResponse === void 0 ? void 0 : afterResponse.response.loaded;
    const totalBefore = beforeResponse.response.total;
    const totalAfter = afterResponse === null || afterResponse === void 0 ? void 0 : afterResponse.response.total;
    return {
      before: beforeResponse,
      after: afterResponse,
      combined: {
        isRunning: (_ref = beforeResponse.response.isRunning || (afterResponse === null || afterResponse === void 0 ? void 0 : afterResponse.response.isRunning)) !== null && _ref !== void 0 ? _ref : false,
        isPartial: (_ref2 = beforeResponse.response.isPartial || (afterResponse === null || afterResponse === void 0 ? void 0 : afterResponse.response.isPartial)) !== null && _ref2 !== void 0 ? _ref2 : false,
        loaded: loadedBefore != null || loadedAfter != null ? (loadedBefore !== null && loadedBefore !== void 0 ? loadedBefore : 0) + (loadedAfter !== null && loadedAfter !== void 0 ? loadedAfter : 0) : undefined,
        total: totalBefore != null || totalAfter != null ? (totalBefore !== null && totalBefore !== void 0 ? totalBefore : 0) + (totalAfter !== null && totalAfter !== void 0 ? totalAfter : 0) : undefined,
        entries: [...((_beforeResponse$respo = (_beforeResponse$respo2 = beforeResponse.response.data) === null || _beforeResponse$respo2 === void 0 ? void 0 : _beforeResponse$respo2.entries) !== null && _beforeResponse$respo !== void 0 ? _beforeResponse$respo : []), ...((_afterResponse$respon = afterResponse === null || afterResponse === void 0 ? void 0 : (_afterResponse$respon2 = afterResponse.response.data) === null || _afterResponse$respon2 === void 0 ? void 0 : _afterResponse$respon2.entries) !== null && _afterResponse$respon !== void 0 ? _afterResponse$respon : [])],
        errors: [...((_beforeResponse$respo3 = beforeResponse.response.errors) !== null && _beforeResponse$respo3 !== void 0 ? _beforeResponse$respo3 : []), ...((_afterResponse$respon3 = afterResponse === null || afterResponse === void 0 ? void 0 : afterResponse.response.errors) !== null && _afterResponse$respon3 !== void 0 ? _afterResponse$respon3 : [])],
        hasMoreBefore: (_beforeResponse$respo4 = beforeResponse.response.data) === null || _beforeResponse$respo4 === void 0 ? void 0 : _beforeResponse$respo4.hasMoreBefore,
        hasMoreAfter: afterResponse === null || afterResponse === void 0 ? void 0 : (_afterResponse$respon4 = afterResponse.response.data) === null || _afterResponse$respon4 === void 0 ? void 0 : _afterResponse$respon4.hasMoreAfter,
        topCursor: (_beforeResponse$respo5 = beforeResponse.response.data) === null || _beforeResponse$respo5 === void 0 ? void 0 : _beforeResponse$respo5.topCursor,
        bottomCursor: afterResponse === null || afterResponse === void 0 ? void 0 : (_afterResponse$respon5 = afterResponse.response.data) === null || _afterResponse$respon5 === void 0 ? void 0 : _afterResponse$respon5.bottomCursor
      }
    };
  })))), [logEntriesAroundSearchRequests$]);
  const {
    latestValue: {
      before: latestBeforeResponse,
      after: latestAfterResponse,
      combined: latestCombinedResponse
    }
  } = (0, _use_observable.useObservableState)(logEntriesAroundSearchResponses$, initialCombinedResponse);
  const cancelRequest = (0, _react.useCallback)(() => {
    latestBeforeResponse === null || latestBeforeResponse === void 0 ? void 0 : latestBeforeResponse.abortController.abort();
    latestAfterResponse === null || latestAfterResponse === void 0 ? void 0 : latestAfterResponse.abortController.abort();
  }, [latestBeforeResponse, latestAfterResponse]);
  return {
    cancelRequest,
    fetchLogEntriesAround,
    isRequestRunning: (_latestCombinedRespon = latestCombinedResponse === null || latestCombinedResponse === void 0 ? void 0 : latestCombinedResponse.isRunning) !== null && _latestCombinedRespon !== void 0 ? _latestCombinedRespon : false,
    isResponsePartial: (_latestCombinedRespon2 = latestCombinedResponse === null || latestCombinedResponse === void 0 ? void 0 : latestCombinedResponse.isPartial) !== null && _latestCombinedRespon2 !== void 0 ? _latestCombinedRespon2 : false,
    loaded: latestCombinedResponse === null || latestCombinedResponse === void 0 ? void 0 : latestCombinedResponse.loaded,
    logEntriesAroundSearchResponses$,
    total: latestCombinedResponse === null || latestCombinedResponse === void 0 ? void 0 : latestCombinedResponse.total
  };
};
exports.useFetchLogEntriesAround = useFetchLogEntriesAround;
const initialCombinedResponse = {
  before: undefined,
  after: undefined,
  combined: undefined
};