"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValue = void 0;
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _highlighting = require("./highlighting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldValue = /*#__PURE__*/_react.default.memo(({
  highlightTerms,
  isActiveHighlight,
  value,
  render
}) => {
  if (render) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render(value.length === 1 ? value[0] : value));
  }
  if (value.length === 1) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _highlighting.highlightFieldValue)(formatValue(value[0]), highlightTerms, isActiveHighlight ? _highlighting.ActiveHighlightMarker : _highlighting.HighlightMarker));
  } else if (value.length > 1) {
    return /*#__PURE__*/_react.default.createElement("ul", {
      "data-test-subj": "LogEntryFieldValues"
    }, value.map((entry, i) => /*#__PURE__*/_react.default.createElement(CommaSeparatedLi, {
      key: `LogEntryFieldValue-${i}`,
      "data-test-subj": `LogEntryFieldValue-${i}`
    }, (0, _highlighting.highlightFieldValue)(formatValue(entry), highlightTerms, isActiveHighlight ? _highlighting.ActiveHighlightMarker : _highlighting.HighlightMarker))));
  }
  return null;
});
exports.FieldValue = FieldValue;
const formatValue = value => {
  if (typeof value === 'string') {
    return value;
  }
  return (0, _jsonStableStringify.default)(value);
};
const CommaSeparatedLi = _common.euiStyled.li`
  display: inline;
  &:not(:last-child) {
    margin-right: 1ex;
    &::after {
      content: ',';
    }
  }
`;