"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryActionsMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_visibility_state = require("../../../utils/use_visibility_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPTIME_FIELDS = ['container.id', 'host.ip', 'kubernetes.pod.uid'];
const LogEntryActionsMenu = ({
  logEntry
}) => {
  const {
    hide,
    isVisible,
    toggle
  } = (0, _use_visibility_state.useVisibilityState)(false);
  const apmLinkDescriptor = (0, _react.useMemo)(() => getAPMLink(logEntry), [logEntry]);
  const uptimeLinkDescriptor = (0, _react.useMemo)(() => getUptimeLink(logEntry), [logEntry]);
  const uptimeLinkProps = (0, _public.useLinkProps)({
    app: 'uptime',
    ...(uptimeLinkDescriptor ? uptimeLinkDescriptor : {})
  });
  const apmLinkProps = (0, _public.useLinkProps)({
    app: 'apm',
    ...(apmLinkDescriptor ? apmLinkDescriptor : {})
  });
  const menuItems = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    "data-test-subj": "logEntryActionsMenuItem uptimeLogEntryActionsMenuItem",
    disabled: !uptimeLinkDescriptor,
    icon: "uptimeApp",
    key: "uptimeLink"
  }, uptimeLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logEntryActionsMenu.uptimeActionLabel",
    defaultMessage: "View status in Uptime"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    "data-test-subj": "logEntryActionsMenuItem apmLogEntryActionsMenuItem",
    disabled: !apmLinkDescriptor,
    icon: "apmApp",
    key: "apmLink"
  }, apmLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logsShared.logEntryActionsMenu.apmActionLabel",
    defaultMessage: "View in APM"
  }))], [uptimeLinkDescriptor, apmLinkDescriptor, apmLinkProps, uptimeLinkProps]);
  const hasMenuItems = (0, _react.useMemo)(() => menuItems.length > 0, [menuItems]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "logEntryActionsMenuButton",
      disabled: !hasMenuItems,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: toggle
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsShared.logEntryActionsMenu.buttonLabel",
      defaultMessage: "Investigate"
    })),
    closePopover: hide,
    id: "logEntryActionsMenu",
    isOpen: isVisible,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems
  }));
};
exports.LogEntryActionsMenu = LogEntryActionsMenu;
const getUptimeLink = logEntry => {
  const searchExpressions = logEntry.fields.filter(({
    field,
    value
  }) => value != null && UPTIME_FIELDS.includes(field)).reduce((acc, fieldItem) => {
    const {
      field,
      value
    } = fieldItem;
    return acc.concat(value.map(val => `${field}:${val}`));
  }, []);
  if (searchExpressions.length === 0) {
    return undefined;
  }
  return {
    app: 'uptime',
    hash: '/',
    search: {
      search: `${searchExpressions.join(' or ')}`
    }
  };
};
const getAPMLink = logEntry => {
  var _logEntry$fields$find, _logEntry$fields$find2;
  const traceId = (_logEntry$fields$find = logEntry.fields.find(({
    field,
    value
  }) => typeof value[0] === 'string' && field === 'trace.id')) === null || _logEntry$fields$find === void 0 ? void 0 : (_logEntry$fields$find2 = _logEntry$fields$find.value) === null || _logEntry$fields$find2 === void 0 ? void 0 : _logEntry$fields$find2[0];
  if (typeof traceId !== 'string') {
    return undefined;
  }
  const timestampField = logEntry.fields.find(({
    field
  }) => field === '@timestamp');
  const timestamp = timestampField ? timestampField.value[0] : null;
  const {
    rangeFrom,
    rangeTo
  } = typeof timestamp === 'number' ? (() => {
    const from = new Date(timestamp);
    const to = new Date(timestamp);
    from.setMinutes(from.getMinutes() - 10);
    to.setMinutes(to.getMinutes() + 10);
    return {
      rangeFrom: from.toISOString(),
      rangeTo: to.toISOString()
    };
  })() : {
    rangeFrom: 'now-1y',
    rangeTo: 'now'
  };
  return {
    app: 'apm',
    pathname: getApmTraceUrl({
      traceId,
      rangeFrom,
      rangeTo
    })
  };
};
function getApmTraceUrl({
  traceId,
  rangeFrom,
  rangeTo
}) {
  return `/link-to/trace/${traceId}?` + new URLSearchParams({
    rangeFrom,
    rangeTo
  }).toString();
}