"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamErrorBoundary = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _esQuery = require("@kbn/es-query");
var _resettable_error_boundary = require("../resettable_error_boundary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogStreamErrorBoundary = ({
  children,
  resetOnChange = null
}) => {
  return /*#__PURE__*/_react.default.createElement(_resettable_error_boundary.ResettableErrorBoundary, {
    renderError: renderLogStreamErrorContent,
    resetOnChange: resetOnChange
  }, children);
};
exports.LogStreamErrorBoundary = LogStreamErrorBoundary;
const LogStreamErrorContent = ({
  error
}) => {
  if (error instanceof _esQuery.KQLSyntaxError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logStream.kqlErrorTitle",
        defaultMessage: "Invalid KQL expression",
        tagName: "h2"
      }),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        className: "eui-textLeft"
      }, error.message)
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsShared.logStream.unknownErrorTitle",
        defaultMessage: "An error occurred",
        tagName: "h2"
      }),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        className: "eui-textLeft"
      }, error.message)
    });
  }
};
const renderLogStreamErrorContent = ({
  latestError
}) => /*#__PURE__*/_react.default.createElement(LogStreamErrorContent, {
  error: latestError
});