"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormattedTime = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = require("react");
var _use_kibana_ui_setting = require("../utils/use_kibana_ui_setting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormattedTime = (time, userFormat, fallbackFormat = 'Y-MM-DD HH:mm:ss.SSS') => {
  return userFormat ? (0, _moment.default)(time).format(userFormat) : (0, _moment.default)(time).format(fallbackFormat);
};
const useFormattedTime = (time, {
  format = 'dateTime',
  fallbackFormat
} = {}) => {
  // `dateFormat:scaled` is an array of `[key, format]` tuples.
  // The hook might return `undefined`, so use a sane default for the `find` later.
  const scaledTuples = (0, _use_kibana_ui_setting.useKibanaUiSetting)('dateFormat:scaled')[0] || [['', undefined]];
  const formatMap = {
    dateTime: (0, _use_kibana_ui_setting.useKibanaUiSetting)('dateFormat')[0],
    time: scaledTuples.find(([key]) => key === '')[1]
  };
  const dateFormat = formatMap[format];
  const formattedTime = (0, _react.useMemo)(() => getFormattedTime(time, dateFormat, fallbackFormat), [time, dateFormat, fallbackFormat]);
  return formattedTime;
};
exports.useFormattedTime = useFormattedTime;