"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDatasetSelectionRestoreFailedNotifier = exports.createCreateDataViewFailedNotifier = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDatasetSelectionRestoreFailedNotifier = toasts => () => toasts.addWarning({
  title: _i18n.i18n.translate('xpack.logExplorer.datasetSelection.restoreDatasetSelectionFailedToastTitle', {
    defaultMessage: "We couldn't restore your datasets selection."
  }),
  text: _i18n.i18n.translate('xpack.logExplorer.datasetSelection.restoreDatasetSelectionFailedToastMessage', {
    defaultMessage: 'We switched to "All log datasets" as the default selection.'
  })
});
exports.createDatasetSelectionRestoreFailedNotifier = createDatasetSelectionRestoreFailedNotifier;
const createCreateDataViewFailedNotifier = toasts => () => toasts.addWarning({
  title: _i18n.i18n.translate('xpack.logExplorer.datasetSelection.createDataViewFailedToastTitle', {
    defaultMessage: "We couldn't create a data view for your selection."
  }),
  text: _i18n.i18n.translate('xpack.logExplorer.datasetSelection.createDataViewFailedToastMessage', {
    defaultMessage: 'We switched to "All log datasets" as the default selection.'
  })
});
exports.createCreateDataViewFailedNotifier = createCreateDataViewFailedNotifier;