"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetSelection = void 0;
var _react = require("@xstate/react");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetSelection = logExplorerProfileStateService => {
  const datasetSelection = (0, _react.useSelector)(logExplorerProfileStateService, state => {
    return state.context.datasetSelection;
  });
  const handleDatasetSelectionChange = (0, _react2.useCallback)(data => {
    logExplorerProfileStateService.send({
      type: 'UPDATE_DATASET_SELECTION',
      data
    });
  }, [logExplorerProfileStateService]);
  return {
    datasetSelection,
    handleDatasetSelectionChange
  };
};
exports.useDatasetSelection = useDatasetSelection;