"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLogExplorerProfileCustomizations = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _use_log_explorer_customizations = require("../hooks/use_log_explorer_customizations");
var _dynamic = require("../utils/dynamic");
var _use_kibana = require("../utils/use_kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const LazyCustomDatasetFilters = (0, _dynamic.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./custom_dataset_filters'))));
const LazyCustomDatasetSelector = (0, _dynamic.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./custom_dataset_selector'))));
const LazyCustomFlyoutContent = (0, _dynamic.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./custom_flyout_content'))));
const createLogExplorerProfileCustomizations = ({
  core,
  customizations: logExplorerCustomizations,
  plugins,
  state$
}) => async ({
  customizations,
  stateContainer
}) => {
  const {
    data,
    dataViews,
    discover
  } = plugins;
  // Lazy load dependencies
  const datasetServiceModuleLoadable = Promise.resolve().then(() => _interopRequireWildcard(require('../services/datasets')));
  const logExplorerMachineModuleLoadable = Promise.resolve().then(() => _interopRequireWildcard(require('../state_machines/log_explorer_profile')));
  const [{
    DatasetsService
  }, {
    initializeLogExplorerProfileStateService,
    waitForState
  }] = await Promise.all([datasetServiceModuleLoadable, logExplorerMachineModuleLoadable]);
  const datasetsClient = new DatasetsService().start({
    http: core.http
  }).client;
  const logExplorerProfileStateService = initializeLogExplorerProfileStateService({
    datasetsClient,
    stateContainer,
    toasts: core.notifications.toasts
  });

  /**
   * Wait for the machine to be fully initialized to set the restored selection
   * create the DataView and set it in the stateContainer from Discover
   */
  await waitForState(logExplorerProfileStateService, 'initialized');

  /**
   * Subscribe the state$ BehaviorSubject when the consumer app wants to react to state changes.
   * It emits a combined state of:
   * - log explorer state machine context
   * - appState from the discover stateContainer
   */
  let stateSubscription;
  if (state$) {
    stateSubscription = createStateUpdater({
      logExplorerProfileStateService,
      stateContainer
    }).subscribe(state$);
  }

  /**
   * Replace the DataViewPicker with a custom `DatasetSelector` to pick integrations streams
   * Prepend the search bar with custom filter control groups depending on the selected dataset
   */
  customizations.set({
    id: 'search_bar',
    CustomDataViewPicker: () => {
      const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins);
      return /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, null, /*#__PURE__*/_react.default.createElement(LazyCustomDatasetSelector, {
        datasetsClient: datasetsClient,
        dataViews: dataViews,
        discover: discover,
        logExplorerProfileStateService: logExplorerProfileStateService
      }));
    },
    PrependFilterBar: () => /*#__PURE__*/_react.default.createElement(LazyCustomDatasetFilters, {
      logExplorerProfileStateService: logExplorerProfileStateService,
      data: data
    })
  });

  /**
   * Hide New, Open and Save settings to prevent working with saved views.
   */
  customizations.set({
    id: 'top_nav',
    defaultMenu: {
      newItem: {
        disabled: true
      },
      openItem: {
        disabled: true
      },
      saveItem: {
        disabled: true
      }
    },
    defaultBadges: {
      unsavedChangesBadge: {
        disabled: true
      }
    }
  });

  /**
   * Hide flyout actions to prevent rendering hard-coded actions.
   */
  customizations.set({
    id: 'flyout',
    size: '60%',
    title: _i18n.i18n.translate('xpack.logExplorer.flyoutDetail.title', {
      defaultMessage: 'Log details'
    }),
    actions: {
      defaultActions: {
        viewSingleDocument: {
          disabled: true
        },
        viewSurroundingDocument: {
          disabled: true
        }
      }
    },
    Content: props => {
      const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins);
      const internalState = (0, _useObservable.default)(stateContainer.internalState.state$, stateContainer.internalState.get());
      return /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, null, /*#__PURE__*/_react.default.createElement(_use_log_explorer_customizations.LogExplorerCustomizationsProvider, {
        value: logExplorerCustomizations
      }, /*#__PURE__*/_react.default.createElement(LazyCustomFlyoutContent, (0, _extends2.default)({}, props, {
        dataView: internalState.dataView
      }))));
    }
  });
  return () => {
    if (stateSubscription) {
      stateSubscription.unsubscribe();
    }
  };
};
exports.createLogExplorerProfileCustomizations = createLogExplorerProfileCustomizations;
const createStateUpdater = ({
  logExplorerProfileStateService,
  stateContainer
}) => {
  return (0, _rxjs.combineLatest)([(0, _rxjs.from)(logExplorerProfileStateService), stateContainer.appState.state$]).pipe((0, _rxjs.map)(([logExplorerState, appState]) => ({
    logExplorerState: logExplorerState.context,
    appState
  })));
};