"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.integrationRT = exports.datasetRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const datasetRT = rt.exact(rt.intersection([rt.type({
  name: _ioTsUtils.indexPatternRt
}), rt.partial({
  title: rt.string
})]));
exports.datasetRT = datasetRT;
const integrationStatusRT = rt.keyof({
  installed: null,
  installing: null,
  install_failed: null
});
const iconRT = rt.intersection([rt.type({
  src: rt.string
}), rt.partial({
  title: rt.string,
  size: rt.string,
  type: rt.string
})]);
const integrationRT = rt.intersection([rt.type({
  name: rt.string,
  status: integrationStatusRT,
  version: rt.string,
  dataStreams: rt.array(datasetRT)
}), rt.partial({
  title: rt.union([rt.string, rt.undefined]),
  icons: rt.union([rt.array(iconRT), rt.undefined]),
  description: rt.union([rt.string, rt.undefined])
})]);
exports.integrationRT = integrationRT;