"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnresolvedDatasetSelection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _datasets = require("../datasets");
var _encoding = require("./encoding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UnresolvedDatasetSelection {
  constructor(dataset) {
    var _dataset$parentIntegr;
    (0, _defineProperty2.default)(this, "selectionType", void 0);
    (0, _defineProperty2.default)(this, "selection", void 0);
    this.selectionType = 'unresolved';
    this.selection = {
      name: (_dataset$parentIntegr = dataset.parentIntegration) === null || _dataset$parentIntegr === void 0 ? void 0 : _dataset$parentIntegr.name,
      dataset
    };
  }
  toDataviewSpec() {
    const {
      name,
      title
    } = this.selection.dataset.toDataviewSpec();
    return {
      id: this.toURLSelectionId(),
      name,
      title
    };
  }
  toURLSelectionId() {
    return (0, _encoding.encodeDatasetSelection)({
      selectionType: this.selectionType,
      selection: {
        name: this.selection.name,
        dataset: this.selection.dataset.toPlain()
      }
    });
  }
  static fromSelection(selection) {
    const {
      name,
      dataset
    } = selection;

    // Attempt reconstructing the integration object
    const integration = name ? {
      name
    } : undefined;
    const datasetInstance = _datasets.Dataset.create(dataset, integration);
    return new UnresolvedDatasetSelection(datasetInstance);
  }
  static create(dataset) {
    return new UnresolvedDatasetSelection(dataset);
  }
}
exports.UnresolvedDatasetSelection = UnresolvedDatasetSelection;