"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_ID_FIELD = exports.TIMESTAMP_FIELD = exports.SERVICE_NAME_FIELD = exports.ORCHESTRATOR_RESOURCE_ID_FIELD = exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = exports.MESSAGE_FIELD = exports.LOG_LEVEL_FIELD = exports.LOG_FILE_PATH_FIELD = exports.LOG_EXPLORER_PROFILE_ID = exports.HOST_NAME_FIELD = exports.DATA_GRID_DEFAULT_COLUMNS = exports.DATA_GRID_COLUMN_WIDTH_SMALL = exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = exports.DATA_GRID_COLUMNS_PREFERENCES = exports.DATASTREAM_NAMESPACE_FIELD = exports.DATASTREAM_DATASET_FIELD = exports.CLOUD_REGION_FIELD = exports.CLOUD_PROVIDER_FIELD = exports.CLOUD_PROJECT_ID_FIELD = exports.CLOUD_INSTANCE_ID_FIELD = exports.CLOUD_AVAILABILITY_ZONE_FIELD = exports.AGENT_NAME_FIELD = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_EXPLORER_PROFILE_ID = 'log-explorer';

// Fields constants
exports.LOG_EXPLORER_PROFILE_ID = LOG_EXPLORER_PROFILE_ID;
const TIMESTAMP_FIELD = '@timestamp';
exports.TIMESTAMP_FIELD = TIMESTAMP_FIELD;
const HOST_NAME_FIELD = 'host.name';
exports.HOST_NAME_FIELD = HOST_NAME_FIELD;
const LOG_LEVEL_FIELD = 'log.level';
exports.LOG_LEVEL_FIELD = LOG_LEVEL_FIELD;
const MESSAGE_FIELD = 'message';
exports.MESSAGE_FIELD = MESSAGE_FIELD;
const SERVICE_NAME_FIELD = 'service.name';
exports.SERVICE_NAME_FIELD = SERVICE_NAME_FIELD;
const TRACE_ID_FIELD = 'trace.id';
exports.TRACE_ID_FIELD = TRACE_ID_FIELD;
const AGENT_NAME_FIELD = 'agent.name';
exports.AGENT_NAME_FIELD = AGENT_NAME_FIELD;
const ORCHESTRATOR_CLUSTER_NAME_FIELD = 'orchestrator.cluster.name';
exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = ORCHESTRATOR_CLUSTER_NAME_FIELD;
const ORCHESTRATOR_RESOURCE_ID_FIELD = 'orchestrator.resource.id';
exports.ORCHESTRATOR_RESOURCE_ID_FIELD = ORCHESTRATOR_RESOURCE_ID_FIELD;
const CLOUD_PROVIDER_FIELD = 'cloud.provider';
exports.CLOUD_PROVIDER_FIELD = CLOUD_PROVIDER_FIELD;
const CLOUD_REGION_FIELD = 'cloud.region';
exports.CLOUD_REGION_FIELD = CLOUD_REGION_FIELD;
const CLOUD_AVAILABILITY_ZONE_FIELD = 'cloud.availability_zone';
exports.CLOUD_AVAILABILITY_ZONE_FIELD = CLOUD_AVAILABILITY_ZONE_FIELD;
const CLOUD_PROJECT_ID_FIELD = 'cloud.project.id';
exports.CLOUD_PROJECT_ID_FIELD = CLOUD_PROJECT_ID_FIELD;
const CLOUD_INSTANCE_ID_FIELD = 'cloud.instance.id';
exports.CLOUD_INSTANCE_ID_FIELD = CLOUD_INSTANCE_ID_FIELD;
const LOG_FILE_PATH_FIELD = 'log.file.path';
exports.LOG_FILE_PATH_FIELD = LOG_FILE_PATH_FIELD;
const DATASTREAM_NAMESPACE_FIELD = 'data_stream.namespace';
exports.DATASTREAM_NAMESPACE_FIELD = DATASTREAM_NAMESPACE_FIELD;
const DATASTREAM_DATASET_FIELD = 'data_stream.dataset';

// Sizing
exports.DATASTREAM_DATASET_FIELD = DATASTREAM_DATASET_FIELD;
const DATA_GRID_COLUMN_WIDTH_SMALL = 240;
exports.DATA_GRID_COLUMN_WIDTH_SMALL = DATA_GRID_COLUMN_WIDTH_SMALL;
const DATA_GRID_COLUMN_WIDTH_MEDIUM = 320;

// UI preferences
exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = DATA_GRID_COLUMN_WIDTH_MEDIUM;
const DATA_GRID_DEFAULT_COLUMNS = [SERVICE_NAME_FIELD, HOST_NAME_FIELD, MESSAGE_FIELD];
exports.DATA_GRID_DEFAULT_COLUMNS = DATA_GRID_DEFAULT_COLUMNS;
const DATA_GRID_COLUMNS_PREFERENCES = {
  [HOST_NAME_FIELD]: {
    width: DATA_GRID_COLUMN_WIDTH_MEDIUM
  },
  [SERVICE_NAME_FIELD]: {
    width: DATA_GRID_COLUMN_WIDTH_SMALL
  }
};
exports.DATA_GRID_COLUMNS_PREFERENCES = DATA_GRID_COLUMNS_PREFERENCES;