"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSaveToLibrary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
var _common = require("../../common");
var _duplicate_title_check = require("./duplicate_title_check");
var _attribute_service = require("../services/attribute_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const modalTitle = _i18n.i18n.translate('links.contentManagement.saveModalTitle', {
  defaultMessage: `Save {contentId} panel to library`,
  values: {
    contentId: _common.CONTENT_ID
  }
});
const runSaveToLibrary = async (newAttributes, initialInput) => {
  return new Promise(resolve => {
    const onSave = async ({
      newTitle,
      newDescription,
      onTitleDuplicate,
      isTitleDuplicateConfirmed
    }) => {
      const stateFromSaveModal = {
        title: newTitle,
        description: newDescription
      };
      if (!(await (0, _duplicate_title_check.checkForDuplicateTitle)({
        title: newTitle,
        lastSavedTitle: newAttributes.title,
        copyOnSave: false,
        onTitleDuplicate,
        isTitleDuplicateConfirmed
      }))) {
        return {};
      }
      const stateToSave = {
        ...newAttributes,
        ...stateFromSaveModal
      };
      const updatedInput = await (0, _attribute_service.getLinksAttributeService)().wrapAttributes(stateToSave, true, initialInput);
      resolve(updatedInput);
      return {
        id: updatedInput.savedObjectId
      };
    };
    const saveModal = /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
      onSave: onSave,
      onClose: () => resolve(undefined),
      title: newAttributes.title,
      customModalTitle: modalTitle,
      description: newAttributes.description,
      showDescription: true,
      showCopyOnSave: false,
      objectType: _common.CONTENT_ID
    });
    (0, _public.showSaveModal)(saveModal);
  });
};
exports.runSaveToLibrary = runSaveToLibrary;