"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevertToBasic = void 0;
var _reactRedux = require("react-redux");
var _revert_to_basic = require("./revert_to_basic");
var _license_management = require("../../../store/reducers/license_management");
var _start_basic = require("../../../store/actions/start_basic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    shouldShowRevertToBasicLicense: (0, _license_management.shouldShowRevertToBasicLicense)(state),
    licenseType: (0, _license_management.getLicenseType)(state),
    needsAcknowledgement: (0, _license_management.startBasicLicenseNeedsAcknowledgement)(state),
    messages: (0, _license_management.getStartBasicMessages)(state)
  };
};
const mapDispatchToProps = {
  startBasicLicense: _start_basic.startBasicLicense,
  cancelStartBasicLicense: _start_basic.cancelStartBasicLicense
};
const RevertToBasic = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_revert_to_basic.RevertToBasic);
exports.RevertToBasic = RevertToBasic;