"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryOptIn = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/telemetry-management-section-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryOptIn extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showMoreTelemetryInfo: false,
      showExample: false
    });
    (0, _defineProperty2.default)(this, "closeReadMorePopover", () => {
      this.setState({
        showMoreTelemetryInfo: false
      });
    });
    (0, _defineProperty2.default)(this, "onClickReadMore", () => {
      const {
        showMoreTelemetryInfo
      } = this.state;
      this.setState({
        showMoreTelemetryInfo: !showMoreTelemetryInfo
      });
    });
    (0, _defineProperty2.default)(this, "onClickExample", () => {
      this.setState({
        showExample: true
      });
      this.closeReadMorePopover();
    });
    (0, _defineProperty2.default)(this, "onChangeOptIn", event => {
      const isOptingInToTelemetry = event.target.checked;
      const {
        onOptInChange
      } = this.props;
      onOptInChange(isOptingInToTelemetry);
    });
  }
  render() {
    const {
      showMoreTelemetryInfo,
      showExample
    } = this.state;
    const {
      isStartTrial,
      isOptingInToTelemetry,
      telemetry
    } = this.props;
    let example = null;
    if (showExample) {
      // Using React.Suspense and lazy loading here to avoid crashing the plugin when importing
      // OptInExampleFlyout but telemetryManagementSection is disabled
      example = /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
        fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
      }, /*#__PURE__*/_react.default.createElement(_public.LazyOptInExampleFlyout, {
        onClose: () => this.setState({
          showExample: false
        }),
        fetchExample: telemetry.telemetryService.fetchExample
      }));
    }
    let toCurrentCustomers;
    if (!isStartTrial) {
      toCurrentCustomers = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.telemetryOptIn.customersHelpSupportDescription",
        defaultMessage: "Help Elastic support provide better service"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }));
    }
    const readMoreButton = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.onClickReadMore
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.telemetryOptIn.readMoreLinkText",
      defaultMessage: "Read more"
    }));
    const popover = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      ownFocus: true,
      id: "readMorePopover",
      button: readMoreButton,
      isOpen: showMoreTelemetryInfo,
      closePopover: this.closeReadMorePopover,
      className: "eui-AlignBaseline"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: "licManagement__narrowText"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.telemetryOptIn.featureUsageWarningMessage",
      defaultMessage: "This feature periodically sends basic feature usage statistics. This information will not be shared outside of Elastic. See an {exampleLink} or read our {telemetryPrivacyStatementLink}. You can disable this feature any time.",
      values: {
        exampleLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: this.onClickExample
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.telemetryOptIn.exampleLinkText",
          defaultMessage: "example"
        })),
        telemetryPrivacyStatementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: telemetry.telemetryConstants.getPrivacyStatementUrl(),
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.telemetryOptIn.telemetryPrivacyStatementLinkText",
          defaultMessage: "telemetry privacy statement"
        }))
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, example, toCurrentCustomers, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      label: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.telemetryOptIn.sendBasicFeatureStatisticsLabel",
        defaultMessage: "Send basic feature usage statistics to Elastic periodically. {popover}",
        values: {
          popover
        }
      })),
      id: "isOptingInToTelemetry",
      checked: isOptingInToTelemetry,
      onChange: this.onChangeOptIn
    }));
  }
}
exports.TelemetryOptIn = TelemetryOptIn;