"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTagcloudVisualization = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/expression-xy-plugin/public");
var _common = require("@kbn/expressions-plugin/common");
var _coloring = require("@kbn/coloring");
var _chartIcons = require("@kbn/chart-icons");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _utils = require("../../utils");
var _suggestions = require("./suggestions");
var _tagcloud_toolbar = require("./tagcloud_toolbar");
var _tags_dimension_editor = require("./tags_dimension_editor");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAG_GROUP_ID = 'tags';
const METRIC_GROUP_ID = 'metric';
const getTagcloudVisualization = ({
  paletteService,
  kibanaTheme
}) => ({
  id: 'lnsTagcloud',
  visualizationTypes: [{
    id: 'lnsTagcloud',
    icon: _chartIcons.IconChartTagcloud,
    label: _constants.TAGCLOUD_LABEL,
    groupLabel: _i18n.i18n.translate('xpack.lens.pie.groupLabel', {
      defaultMessage: 'Proportion'
    })
  }],
  getVisualizationTypeId() {
    return 'lnsTagcloud';
  },
  clearLayer(state) {
    const newState = {
      ...state,
      ..._constants.DEFAULT_STATE
    };
    delete newState.tagAccessor;
    delete newState.valueAccessor;
    delete newState.palette;
    return newState;
  },
  getLayerIds(state) {
    return [state.layerId];
  },
  getDescription() {
    return {
      icon: _chartIcons.IconChartTagcloud,
      label: _constants.TAGCLOUD_LABEL
    };
  },
  getSuggestions: _suggestions.getSuggestions,
  getSuggestionFromConvertToLensContext({
    suggestions,
    context
  }) {
    return !suggestions.length ? undefined : {
      ...suggestions[0],
      visualizationState: {
        ...suggestions[0].visualizationState,
        ...context.configuration
      }
    };
  },
  getMainPalette: state => {
    if (!state) return;
    return state.colorMapping ? {
      type: 'colorMapping',
      value: state.colorMapping
    } : state.palette ? {
      type: 'legacyPalette',
      value: state.palette
    } : undefined;
  },
  triggers: [_public.VIS_EVENT_TO_TRIGGER.filter],
  initialize(addNewLayer, state, mainPalette) {
    return state || {
      layerId: addNewLayer(),
      layerType: _public2.LayerTypes.DATA,
      ..._constants.DEFAULT_STATE,
      colorMapping: (mainPalette === null || mainPalette === void 0 ? void 0 : mainPalette.type) === 'colorMapping' ? mainPalette.value : (0, _utils.getColorMappingDefaults)()
    };
  },
  getConfiguration({
    state
  }) {
    const canUseColorMapping = state.colorMapping ? true : false;
    let colors = [];
    if (canUseColorMapping) {
      kibanaTheme.theme$.subscribe({
        next(theme) {
          colors = (0, _coloring.getColorsFromMapping)(theme.darkMode, state.colorMapping);
        }
      }).unsubscribe();
    } else {
      var _state$palette, _state$palette2;
      colors = paletteService.get(((_state$palette = state.palette) === null || _state$palette === void 0 ? void 0 : _state$palette.name) || 'default').getCategoricalColors(10, (_state$palette2 = state.palette) === null || _state$palette2 === void 0 ? void 0 : _state$palette2.params);
    }
    return {
      groups: [{
        groupId: TAG_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.lens.tagcloud.tagLabel', {
          defaultMessage: 'Tags'
        }),
        layerId: state.layerId,
        accessors: state.tagAccessor ? [{
          columnId: state.tagAccessor,
          triggerIconType: 'colorBy',
          palette: colors
        }] : [],
        supportsMoreColumns: !state.tagAccessor,
        filterOperations: op => op.isBucketed,
        enableDimensionEditor: true,
        required: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsTagcloud_tagDimensionPanel'
      }, {
        groupId: METRIC_GROUP_ID,
        groupLabel: _i18n.i18n.translate('xpack.lens.tagcloud.metricValueLabel', {
          defaultMessage: 'Metric'
        }),
        isMetricDimension: true,
        layerId: state.layerId,
        accessors: state.valueAccessor ? [{
          columnId: state.valueAccessor
        }] : [],
        supportsMoreColumns: !state.valueAccessor,
        filterOperations: op => !op.isBucketed && op.dataType === 'number',
        enableDimensionEditor: true,
        required: true,
        requiredMinDimensionCount: 1,
        dataTestSubj: 'lnsTagcloud_valueDimensionPanel'
      }]
    };
  },
  getSupportedLayers() {
    return [{
      type: _public2.LayerTypes.DATA,
      label: _i18n.i18n.translate('xpack.lens.tagcloud.addLayer', {
        defaultMessage: 'Add visualization layer'
      })
    }];
  },
  getLayerType(layerId, state) {
    if ((state === null || state === void 0 ? void 0 : state.layerId) === layerId) {
      return _public2.LayerTypes.DATA;
    }
  },
  toExpression: (state, datasourceLayers, attributes, datasourceExpressionsByLayers = {}) => {
    if (!state.tagAccessor || !state.valueAccessor) {
      return null;
    }
    const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
    return {
      type: 'expression',
      chain: [...(datasourceExpression ? datasourceExpression.chain : []), (0, _common.buildExpressionFunction)('tagcloud', {
        bucket: state.tagAccessor,
        metric: state.valueAccessor,
        maxFontSize: state.maxFontSize,
        minFontSize: state.minFontSize,
        orientation: state.orientation,
        palette: (0, _common.buildExpression)([state.palette ? (0, _common.buildExpressionFunction)('theme', {
          variable: 'palette',
          default: [paletteService.get(state.palette.name).toExpression(state.palette.params)]
        }) : (0, _common.buildExpressionFunction)('system_palette', {
          name: 'default'
        })]).toAst(),
        showLabel: state.showLabel,
        colorMapping: state.colorMapping ? JSON.stringify(state.colorMapping) : undefined
      }).toAst()]
    };
  },
  toPreviewExpression: (state, datasourceLayers, datasourceExpressionsByLayers = {}) => {
    if (!state.tagAccessor || !state.valueAccessor) {
      return null;
    }
    const datasourceExpression = datasourceExpressionsByLayers[state.layerId];
    return {
      type: 'expression',
      chain: [...(datasourceExpression ? datasourceExpression.chain : []), (0, _common.buildExpressionFunction)('tagcloud', {
        bucket: state.tagAccessor,
        isPreview: true,
        metric: state.valueAccessor,
        maxFontSize: 18,
        minFontSize: 4,
        orientation: state.orientation,
        palette: (0, _common.buildExpression)([state.palette ? (0, _common.buildExpressionFunction)('theme', {
          variable: 'palette',
          default: [paletteService.get(state.palette.name).toExpression(state.palette.params)]
        }) : (0, _common.buildExpressionFunction)('system_palette', {
          name: 'default'
        })]).toAst(),
        showLabel: false,
        colorMapping: state.colorMapping ? JSON.stringify(state.colorMapping) : undefined
      }).toAst()]
    };
  },
  setDimension({
    columnId,
    groupId,
    prevState
  }) {
    const update = {};
    if (groupId === TAG_GROUP_ID) {
      update.tagAccessor = columnId;
    } else if (groupId === METRIC_GROUP_ID) {
      update.valueAccessor = columnId;
    }
    return {
      ...prevState,
      ...update
    };
  },
  removeDimension({
    prevState,
    layerId,
    columnId
  }) {
    const update = {
      ...prevState
    };
    if (prevState.tagAccessor === columnId) {
      delete update.tagAccessor;
    } else if (prevState.valueAccessor === columnId) {
      delete update.valueAccessor;
    }
    return update;
  },
  DimensionEditorComponent(props) {
    const isDarkMode = (0, _useObservable.default)(kibanaTheme.theme$, {
      darkMode: false
    }).darkMode;
    if (props.groupId === TAG_GROUP_ID) {
      return /*#__PURE__*/_react.default.createElement(_tags_dimension_editor.TagsDimensionEditor, {
        isDarkMode: isDarkMode,
        paletteService: paletteService,
        state: props.state,
        setState: props.setState,
        frame: props.frame,
        panelRef: props.panelRef,
        isInlineEditing: props.isInlineEditing
      });
    }
    return null;
  },
  ToolbarComponent(props) {
    return /*#__PURE__*/_react.default.createElement(_tagcloud_toolbar.TagcloudToolbar, props);
  }
});
exports.getTagcloudVisualization = getTagcloudVisualization;