"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FontSizeInput = FontSizeInput;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FontSizeInput(props) {
  const [fontSize, setFontSize] = (0, _react.useState)([props.minFontSize, props.maxFontSize]);
  const [, cancel] = (0, _useDebounce.default)(() => {
    props.onChange(fontSize[0], fontSize[1]);
  }, 150, [fontSize]);
  (0, _react.useEffect)(() => {
    return () => {
      cancel();
    };
  }, [cancel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, {
    id: "tagCloudFontSizeSlider",
    min: 1,
    max: 120,
    step: 1,
    value: fontSize,
    onChange: value => {
      setFontSize(value);
    },
    showLabels: true,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.lens.label.tagcloud.fontSizeLabel', {
      defaultMessage: 'Font size'
    })
  });
}