"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchProvider = void 0;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Global search provider adding a Lens entry.
 * This is necessary because Lens does not show up in the nav bar and is filtered out by the
 * default app provider.
 *
 * It is inlining the same search term matching logic as the application search provider.
 *
 * TODO: This is a workaround and can be removed once there is a generic way to register sub features
 * of apps. In this case, Lens should be considered a feature of Visualize.
 */
const getSearchProvider = uiCapabilities => ({
  id: 'lens',
  find: ({
    term = '',
    types,
    tags
  }) => {
    if (tags || types && !types.includes('application')) {
      return (0, _rxjs.of)([]);
    }
    return (0, _rxjs.from)(uiCapabilities.then(({
      navLinks: {
        visualize: visualizeNavLink
      }
    }) => {
      if (!visualizeNavLink) {
        return [];
      }
      const title = _i18n.i18n.translate('xpack.lens.searchTitle', {
        defaultMessage: 'Lens: create visualizations',
        description: 'Lens is a product name and should not be translated'
      });
      const searchableTitle = title.toLowerCase();
      term = term.toLowerCase();
      let score = 0;

      // shortcuts to avoid calculating the distance when there is an exact match somewhere.
      if (searchableTitle === term) {
        score = 100;
      } else if (searchableTitle.startsWith(term)) {
        score = 90;
      } else if (searchableTitle.includes(term)) {
        score = 75;
      }
      if (score === 0) return [];
      return [{
        id: 'lens',
        title,
        type: 'application',
        icon: 'logoKibana',
        meta: {
          categoryId: _public.DEFAULT_APP_CATEGORIES.kibana.id,
          categoryLabel: _public.DEFAULT_APP_CATEGORIES.kibana.label
        },
        score,
        url: (0, _constants.getFullPath)()
      }];
    }));
  },
  getSearchableTypes: () => ['application']
});
exports.getSearchProvider = getSearchProvider;