"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loader = Loader;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Executes the specified load function any time loadDeps changes. Ensures the load
 * function is never run in parallel. Shows a loading indicator while loading.
 */
function Loader(props) {
  const [isProcessing, setIsProcessing] = (0, _react.useState)(false);
  const prevRequest = (0, _react.useRef)(undefined);
  const nextRequest = (0, _react.useRef)(undefined);
  (0, _react.useEffect)(function performLoad() {
    if (prevRequest.current) {
      nextRequest.current = performLoad;
      return;
    }
    setIsProcessing(true);
    prevRequest.current = props.load().catch(() => {}).then(() => {
      const reload = nextRequest.current;
      prevRequest.current = undefined;
      nextRequest.current = undefined;
      if (reload) {
        reload();
      } else {
        setIsProcessing(false);
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  props.loadDeps);
  if (!isProcessing) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  });
}