"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FrameLayout = FrameLayout;
require("./frame_layout.scss");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _state_management = require("../../state_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FrameLayout(props) {
  const isFullscreen = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none",
    alignItems: "stretch"
  }, props.bannerMessages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("aside", {
    "aria-labelledby": "bannerMessagesId"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "bannerMessagesId"
  }, _i18n.i18n.translate('xpack.lens.section.bannerMessagesLabel', {
    defaultMessage: 'Deprecation messages'
  }))), props.bannerMessages)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: "lnsFrameLayout__wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "none",
    className: (0, _classnames.default)('lnsFrameLayout', {
      'lnsFrameLayout-isFullscreen': isFullscreen
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: false,
    className: "lnsFrameLayout__pageContent",
    "aria-labelledby": "lns_ChartTitle"
  }, /*#__PURE__*/_react.default.createElement("section", {
    className: 'lnsFrameLayout__sidebar lnsFrameLayout__sidebar--left hide-for-sharing',
    "aria-labelledby": "dataPanelId"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "dataPanelId"
  }, _i18n.i18n.translate('xpack.lens.section.dataPanelLabel', {
    defaultMessage: 'Data panel'
  }))), props.dataPanel), /*#__PURE__*/_react.default.createElement("section", {
    className: (0, _classnames.default)('lnsFrameLayout__pageBody', {
      'lnsFrameLayout__pageBody-isFullscreen': isFullscreen
    }),
    "aria-labelledby": "workspaceId"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "workspaceId"
  }, _i18n.i18n.translate('xpack.lens.section.workspaceLabel', {
    defaultMessage: 'Visualization workspace'
  }))), props.workspacePanel, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsFrameLayout__suggestionPanel hide-for-sharing"
  }, props.suggestionsPanel)), /*#__PURE__*/_react.default.createElement("section", {
    className: (0, _classnames.default)('lnsFrameLayout__sidebar lnsFrameLayout__sidebar--right', 'hide-for-sharing', {
      'lnsFrameLayout__sidebar-isFullscreen': isFullscreen
    }),
    "aria-labelledby": "configPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "configPanel"
  }, _i18n.i18n.translate('xpack.lens.section.configPanelLabel', {
    defaultMessage: 'Config panel'
  }))), props.configPanel)))));
}